/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.sets;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.sets.ACDistinct;
import mb.nabl2.terms.ITerm;

public final class CDistinct
extends ACDistinct
implements Serializable {
    private final ITerm set;
    private final String projection;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CDistinct(ITerm set, Optional<String> projection, IMessageInfo messageInfo) {
        this.set = Objects.requireNonNull(set, "set");
        this.projection = projection.orElse(null);
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CDistinct(CDistinct original, ITerm set, String projection, IMessageInfo messageInfo) {
        this.set = set;
        this.projection = projection;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getSet() {
        return this.set;
    }

    @Override
    public Optional<String> getProjection() {
        return Optional.ofNullable(this.projection);
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CDistinct withSet(ITerm value) {
        if (this.set == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "set");
        return new CDistinct(this, newValue, this.projection, this.messageInfo);
    }

    public final CDistinct withProjection(String value) {
        String newValue = Objects.requireNonNull(value, "projection");
        if (Objects.equals(this.projection, newValue)) {
            return this;
        }
        return new CDistinct(this, this.set, newValue, this.messageInfo);
    }

    public final CDistinct withProjection(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.projection, value)) {
            return this;
        }
        return new CDistinct(this, this.set, value, this.messageInfo);
    }

    public final CDistinct withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CDistinct(this, this.set, this.projection, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CDistinct && this.equalTo(0, (CDistinct)another);
    }

    private boolean equalTo(int synthetic, CDistinct another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.set.equals(another.set) && Objects.equals(this.projection, another.projection) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + Objects.hashCode(this.projection);
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CDistinct of(ITerm set, Optional<String> projection, IMessageInfo messageInfo) {
        return new CDistinct(set, projection, messageInfo);
    }

    public static CDistinct copyOf(ACDistinct instance) {
        if (instance instanceof CDistinct) {
            return (CDistinct)instance;
        }
        return CDistinct.of(instance.getSet(), instance.getProjection(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CDistinct(this, this.set, this.projection, this.messageInfo);
    }
}

