/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.relations;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.relations.ACEvalFunction;
import mb.nabl2.relations.terms.FunctionName;
import mb.nabl2.terms.ITerm;

public final class CEvalFunction
extends ACEvalFunction
implements Serializable {
    private final ITerm result;
    private final FunctionName function;
    private final ITerm term;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CEvalFunction(ITerm result, FunctionName function, ITerm term, IMessageInfo messageInfo) {
        this.result = Objects.requireNonNull(result, "result");
        this.function = Objects.requireNonNull(function, "function");
        this.term = Objects.requireNonNull(term, "term");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CEvalFunction(CEvalFunction original, ITerm result, FunctionName function, ITerm term, IMessageInfo messageInfo) {
        this.result = result;
        this.function = function;
        this.term = term;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getResult() {
        return this.result;
    }

    @Override
    public FunctionName getFunction() {
        return this.function;
    }

    @Override
    public ITerm getTerm() {
        return this.term;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CEvalFunction withResult(ITerm value) {
        if (this.result == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "result");
        return new CEvalFunction(this, newValue, this.function, this.term, this.messageInfo);
    }

    public final CEvalFunction withFunction(FunctionName value) {
        if (this.function == value) {
            return this;
        }
        FunctionName newValue = Objects.requireNonNull(value, "function");
        return new CEvalFunction(this, this.result, newValue, this.term, this.messageInfo);
    }

    public final CEvalFunction withTerm(ITerm value) {
        if (this.term == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "term");
        return new CEvalFunction(this, this.result, this.function, newValue, this.messageInfo);
    }

    public final CEvalFunction withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CEvalFunction(this, this.result, this.function, this.term, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CEvalFunction && this.equalTo(0, (CEvalFunction)another);
    }

    private boolean equalTo(int synthetic, CEvalFunction another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.result.equals(another.result) && this.function.equals(another.function) && this.term.equals(another.term) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + this.function.hashCode();
        h += (h << 5) + this.term.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CEvalFunction of(ITerm result, FunctionName function, ITerm term, IMessageInfo messageInfo) {
        return new CEvalFunction(result, function, term, messageInfo);
    }

    public static CEvalFunction copyOf(ACEvalFunction instance) {
        if (instance instanceof CEvalFunction) {
            return (CEvalFunction)instance;
        }
        return CEvalFunction.of(instance.getResult(), instance.getFunction(), instance.getTerm(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CEvalFunction(this, this.result, this.function, this.term, this.messageInfo);
    }
}

