/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.base;

import java.util.function.Function;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.base.CConj;
import mb.nabl2.constraints.base.CExists;
import mb.nabl2.constraints.base.CFalse;
import mb.nabl2.constraints.base.CNew;
import mb.nabl2.constraints.base.CTrue;
import org.metaborg.util.functions.CheckedFunction1;

public interface IBaseConstraint
extends IConstraint {
    public <T> T match(Cases<T> var1);

    public <T, E extends Throwable> T matchOrThrow(CheckedCases<T, E> var1) throws E;

    public static interface Cases<T> {
        public T caseTrue(CTrue var1);

        public T caseFalse(CFalse var1);

        public T caseConj(CConj var1);

        public T caseExists(CExists var1);

        public T caseNew(CNew var1);

        public static <T> Cases<T> of(final Function<CTrue, T> onTrue, final Function<CFalse, T> onFalse, final Function<CConj, T> onConj, final Function<CExists, T> onExists, final Function<CNew, T> onNew) {
            return new Cases<T>(){

                @Override
                public T caseTrue(CTrue constraint) {
                    return onTrue.apply(constraint);
                }

                @Override
                public T caseFalse(CFalse constraint) {
                    return onFalse.apply(constraint);
                }

                @Override
                public T caseConj(CConj constraint) {
                    return onConj.apply(constraint);
                }

                @Override
                public T caseExists(CExists constraint) {
                    return onExists.apply(constraint);
                }

                @Override
                public T caseNew(CNew constraint) {
                    return onNew.apply(constraint);
                }
            };
        }
    }

    public static interface CheckedCases<T, E extends Throwable> {
        public T caseTrue(CTrue var1) throws E;

        public T caseFalse(CFalse var1) throws E;

        public T caseConj(CConj var1) throws E;

        public T caseExists(CExists var1) throws E;

        public T caseNew(CNew var1) throws E;

        public static <T, E extends Throwable> CheckedCases<T, E> of(final CheckedFunction1<CTrue, T, E> onTrue, final CheckedFunction1<CFalse, T, E> onFalse, final CheckedFunction1<CConj, T, E> onConj, final CheckedFunction1<CExists, T, E> onExists, final CheckedFunction1<CNew, T, E> onNew) {
            return new CheckedCases<T, E>(){

                @Override
                public T caseTrue(CTrue constraint) throws Throwable {
                    return onTrue.apply(constraint);
                }

                @Override
                public T caseFalse(CFalse constraint) throws Throwable {
                    return onFalse.apply(constraint);
                }

                @Override
                public T caseConj(CConj constraint) throws Throwable {
                    return onConj.apply(constraint);
                }

                @Override
                public T caseExists(CExists constraint) throws Throwable {
                    return onExists.apply(constraint);
                }

                @Override
                public T caseNew(CNew constraint) throws Throwable {
                    return onNew.apply(constraint);
                }
            };
        }
    }
}

