/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.PropNode;
import org.spoofax.interpreter.terms.IStrategoTerm;

@GeneratedBy(value=PropNode.class)
public final class PropNodeGen
extends PropNode {
    @Node.Child
    private ExpressionNode rhs_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private PropNodeGen(String propName, ExpressionNode rhs) {
        super(propName);
        this.rhs_ = rhs;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object rhsValue_ = this.rhs_.executeGeneric(frameValue);
        if ((state & 1) != 0 && rhsValue_ instanceof ICFGNode) {
            ICFGNode rhsValue__ = (ICFGNode)rhsValue_;
            return this.lookup(rhsValue__);
        }
        if ((state & 2) != 0 && rhsValue_ instanceof IStrategoTerm) {
            IStrategoTerm rhsValue__ = (IStrategoTerm)rhsValue_;
            return this.lookup(rhsValue__);
        }
        if ((state & 4) != 0) {
            return this.lookup(rhsValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(rhsValue_);
    }

    private IStrategoTerm executeAndSpecialize(Object rhsValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (rhsValue instanceof ICFGNode) {
                ICFGNode rhsValue_ = (ICFGNode)rhsValue;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                IStrategoTerm iStrategoTerm = this.lookup(rhsValue_);
                return iStrategoTerm;
            }
            if (rhsValue instanceof IStrategoTerm) {
                IStrategoTerm rhsValue_ = (IStrategoTerm)rhsValue;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                IStrategoTerm iStrategoTerm = this.lookup(rhsValue_);
                return iStrategoTerm;
            }
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            IStrategoTerm iStrategoTerm = this.lookup(rhsValue);
            return iStrategoTerm;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static PropNode create(String propName, ExpressionNode rhs) {
        return new PropNodeGen(propName, rhs);
    }
}

