/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.frame.VirtualFrame;
import mb.flowspec.runtime.InitValues;
import mb.flowspec.runtime.Initializable;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class BooleanLiteralNode
extends ExpressionNode
implements Initializable {
    private static IStrategoAppl FALSE_TERM;
    private static IStrategoAppl TRUE_TERM;
    private final boolean boolValue;
    private IStrategoAppl value;

    public BooleanLiteralNode(boolean value) {
        this.boolValue = value;
    }

    @Override
    public IStrategoTerm executeIStrategoTerm(VirtualFrame frame) {
        if (this.value == null) {
            this.value = BooleanLiteralNode.booleanToTerm(this.boolValue);
        }
        return this.value;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        return this.boolValue;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public void init(InitValues initValues) {
        FALSE_TERM = initValues.termBuilder.applShared("False", new IStrategoTerm[0]);
        TRUE_TERM = initValues.termBuilder.applShared("True", new IStrategoTerm[0]);
    }

    public static IStrategoAppl booleanToTerm(boolean b) {
        return b ? TRUE_TERM : FALSE_TERM;
    }

    public static boolean isTrueTerm(Object o) {
        if (!(o instanceof IStrategoTerm)) {
            return false;
        }
        return TermUtils.isAppl((IStrategoTerm)o, "True", 0);
    }

    public static boolean isFalseTerm(Object o) {
        if (!(o instanceof IStrategoTerm)) {
            return false;
        }
        return TermUtils.isAppl((IStrategoTerm)o, "False", 0);
    }
}

