/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter;

import com.oracle.truffle.api.frame.FrameDescriptor;
import io.usethesource.capsule.BinaryRelation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.IFlowSpecSolution;
import mb.flowspec.runtime.InitValues;
import mb.flowspec.runtime.Initializable;
import mb.flowspec.runtime.interpreter.InitFunction;
import mb.flowspec.runtime.interpreter.TransferFunction;
import mb.flowspec.runtime.interpreter.Where;
import mb.flowspec.runtime.interpreter.expressions.AddNodeGen;
import mb.flowspec.runtime.interpreter.expressions.AndNodeGen;
import mb.flowspec.runtime.interpreter.expressions.ApplicationNode;
import mb.flowspec.runtime.interpreter.expressions.BooleanLiteralNode;
import mb.flowspec.runtime.interpreter.expressions.CompPredicateNode;
import mb.flowspec.runtime.interpreter.expressions.DivNodeGen;
import mb.flowspec.runtime.interpreter.expressions.EmptySetOrMapLiteral;
import mb.flowspec.runtime.interpreter.expressions.EqualNodeGen;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.ExtPropNode;
import mb.flowspec.runtime.interpreter.expressions.FunRefNode;
import mb.flowspec.runtime.interpreter.expressions.FunRefRefNode;
import mb.flowspec.runtime.interpreter.expressions.GtNodeGen;
import mb.flowspec.runtime.interpreter.expressions.GteNodeGen;
import mb.flowspec.runtime.interpreter.expressions.IfNode;
import mb.flowspec.runtime.interpreter.expressions.IntLiteralNode;
import mb.flowspec.runtime.interpreter.expressions.LatticeItemRefNode;
import mb.flowspec.runtime.interpreter.expressions.LatticeOpRefNode;
import mb.flowspec.runtime.interpreter.expressions.LtNodeGen;
import mb.flowspec.runtime.interpreter.expressions.LteNodeGen;
import mb.flowspec.runtime.interpreter.expressions.MapCompNode;
import mb.flowspec.runtime.interpreter.expressions.MapLiteralNode;
import mb.flowspec.runtime.interpreter.expressions.MapLookupNode;
import mb.flowspec.runtime.interpreter.expressions.MatchNode;
import mb.flowspec.runtime.interpreter.expressions.ModNodeGen;
import mb.flowspec.runtime.interpreter.expressions.MulNodeGen;
import mb.flowspec.runtime.interpreter.expressions.NaBL2OccurrenceNode;
import mb.flowspec.runtime.interpreter.expressions.NegNodeGen;
import mb.flowspec.runtime.interpreter.expressions.NotNodeGen;
import mb.flowspec.runtime.interpreter.expressions.OrNodeGen;
import mb.flowspec.runtime.interpreter.expressions.PropNode;
import mb.flowspec.runtime.interpreter.expressions.PropNodeGen;
import mb.flowspec.runtime.interpreter.expressions.QualRefNode;
import mb.flowspec.runtime.interpreter.expressions.SetCompMatchPredicateNode;
import mb.flowspec.runtime.interpreter.expressions.SetCompNode;
import mb.flowspec.runtime.interpreter.expressions.SetContainsNodeGen;
import mb.flowspec.runtime.interpreter.expressions.SetIntersectNodeGen;
import mb.flowspec.runtime.interpreter.expressions.SetLiteralNode;
import mb.flowspec.runtime.interpreter.expressions.SetMinusNodeGen;
import mb.flowspec.runtime.interpreter.expressions.SetUnionNodeGen;
import mb.flowspec.runtime.interpreter.expressions.StringLiteralNode;
import mb.flowspec.runtime.interpreter.expressions.SubNodeGen;
import mb.flowspec.runtime.interpreter.expressions.TermIndexNodeGen;
import mb.flowspec.runtime.interpreter.expressions.TermNode;
import mb.flowspec.runtime.interpreter.expressions.TupleNode;
import mb.flowspec.runtime.interpreter.expressions.TypeNode;
import mb.flowspec.runtime.interpreter.locals.ArgToVarNode;
import mb.flowspec.runtime.interpreter.locals.ReadVarNode;
import mb.flowspec.runtime.interpreter.locals.ReadVarNodeGen;
import mb.flowspec.runtime.interpreter.locals.WriteVarNode;
import mb.flowspec.runtime.interpreter.locals.WriteVarNodeGen;
import mb.flowspec.runtime.interpreter.patterns.AtPatternNode;
import mb.flowspec.runtime.interpreter.patterns.ConsPatternNode;
import mb.flowspec.runtime.interpreter.patterns.IntLiteralPatternNode;
import mb.flowspec.runtime.interpreter.patterns.NilPatternNode;
import mb.flowspec.runtime.interpreter.patterns.PatternNode;
import mb.flowspec.runtime.interpreter.patterns.StringLiteralPatternNode;
import mb.flowspec.runtime.interpreter.patterns.TermPatternNode;
import mb.flowspec.runtime.interpreter.patterns.TuplePatternNode;
import mb.flowspec.runtime.interpreter.patterns.VarPatternNode;
import mb.flowspec.runtime.interpreter.patterns.WildcardPatternNode;
import mb.flowspec.runtime.interpreter.values.Function;
import mb.flowspec.runtime.lattice.CompleteLattice;
import mb.flowspec.runtime.lattice.FullSetLattice;
import mb.flowspec.runtime.lattice.MapLattice;
import mb.flowspec.runtime.lattice.UserDefinedLattice;
import mb.flowspec.runtime.solver.FunctionInfo;
import mb.flowspec.runtime.solver.ImmutableMapType;
import mb.flowspec.runtime.solver.ImmutableSetType;
import mb.flowspec.runtime.solver.ImmutableSimpleType;
import mb.flowspec.runtime.solver.ImmutableTupleType;
import mb.flowspec.runtime.solver.ImmutableUserType;
import mb.flowspec.runtime.solver.LatticeInfo;
import mb.flowspec.runtime.solver.MapType;
import mb.flowspec.runtime.solver.Metadata;
import mb.flowspec.runtime.solver.SimpleType;
import mb.flowspec.runtime.solver.StaticInfo;
import mb.flowspec.runtime.solver.Type;
import mb.flowspec.runtime.solver.UserType;
import mb.flowspec.terms.B;
import mb.nabl2.terms.build.Attachments;
import mb.nabl2.terms.stratego.TermIndex;
import mb.scopegraph.pepm16.terms.Namespace;
import org.metaborg.util.Ref;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.M;

public class InterpreterBuilder {
    protected final ArrayList<Initializable> initializable = new ArrayList();
    protected StaticInfo staticInfo = new StaticInfo();
    protected final Deque<FrameDescriptor> frameStack = new ArrayDeque<FrameDescriptor>();
    protected String moduleName;

    public InterpreterBuilder add(IStrategoTerm term, String moduleName) {
        try {
            try {
                this.moduleName = moduleName;
                this.frameStack.push(new FrameDescriptor());
                this.staticInfo = this.staticInfo.addAll(this.staticInfo(term));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parse error on reading Static Info", e);
            }
        }
        finally {
            this.frameStack.pop();
            this.moduleName = null;
        }
        return this;
    }

    public InterpreterBuilder add(InterpreterBuilder that) {
        this.initializable.addAll(that.initializable);
        this.staticInfo = this.staticInfo.addAll(that.staticInfo);
        return this;
    }

    public StaticInfo build(ITermFactory termFactory, IFlowSpecSolution solution, Map<String, Map<ICFGNode, Ref<IStrategoTerm>>> preProperties) {
        InitValues initValues = new InitValues(solution.config(), solution.controlFlowGraph(), preProperties, solution.scopeGraph(), solution.nameResolutionCache(), solution.unifier(), solution.astProperties(), this.staticInfo.functions.functions, this.staticInfo.lattices.latticeDefs, new B(termFactory));
        for (Initializable i : this.initializable) {
            i.init(initValues);
        }
        return this.staticInfo;
    }

    private StaticInfo staticInfo(IStrategoTerm term) {
        IStrategoTuple appl = M.tuple(term, 3);
        LatticeInfo latticeInfo = this.latticeInfo(M.at(appl, 1));
        FunctionInfo functionInfo = this.functionInfo(M.at(appl, 2));
        Map<String, CompleteLattice> latticeDefs = latticeInfo.latticeDefs;
        HashMap propMetadata = new HashMap();
        BinaryRelation.Transient dependsOn = BinaryRelation.Transient.of();
        for (IStrategoTerm tfInfoTerm : M.list(M.at(appl, 0))) {
            IStrategoTuple tfInfoTuple = M.tuple(tfInfoTerm, 2);
            String propName = M.string(M.at(tfInfoTuple, 0));
            IStrategoTuple tfNestedTuple = M.tuple(M.at(tfInfoTuple, 1), 3);
            Type type = InterpreterBuilder.type(M.at(tfNestedTuple, 0));
            Metadata.Direction dir = InterpreterBuilder.direction(M.at(tfNestedTuple, 1));
            IStrategoList funs = M.list(M.at(tfNestedTuple, 2));
            HashMap<Tuple2<String, Integer>, TransferFunction> tfMap = new HashMap<Tuple2<String, Integer>, TransferFunction>();
            for (IStrategoTerm funTerm : funs) {
                IStrategoTuple funTuple = M.tuple(funTerm, 2);
                int index = M.integer(M.at(funTuple, 0));
                TransferFunction tf = this.transferFunction(M.at(funTuple, 1));
                tfMap.put(Tuple2.of(this.moduleName, index), tf);
            }
            propMetadata.put(propName, new Metadata(dir, InterpreterBuilder.latticeFromType(latticeDefs, type), Collections.unmodifiableMap(tfMap)));
        }
        return new StaticInfo((BinaryRelation.Immutable<String, String>)dependsOn.freeze(), Collections.unmodifiableMap(propMetadata), functionInfo, latticeInfo);
    }

    public static Type type(IStrategoTerm term) {
        switch (M.appl(term).getName()) {
            case "Tuple": {
                IStrategoAppl appl = M.appl(term, 2);
                return ImmutableTupleType.of(InterpreterBuilder.type(M.at(appl, 0)), InterpreterBuilder.type(M.at(appl, 1)));
            }
            case "Map": {
                IStrategoAppl appl = M.appl(term, 2);
                return ImmutableMapType.of(InterpreterBuilder.type(M.at(appl, 0)), InterpreterBuilder.type(M.at(appl, 1)));
            }
            case "Set": {
                IStrategoAppl appl = M.appl(term, 1);
                return ImmutableSetType.of(InterpreterBuilder.type(M.at(appl, 0)));
            }
            case "UserType": {
                IStrategoAppl appl = M.appl(term, 2);
                IStrategoList typeTerms = M.list(M.at(appl, 1));
                Type[] types = new Type[typeTerms.size()];
                int i = 0;
                for (IStrategoTerm typeTerm : typeTerms) {
                    types[i] = InterpreterBuilder.type(typeTerm);
                    ++i;
                }
                return ImmutableUserType.of(M.string(M.at(appl, 0)), types);
            }
        }
        IStrategoAppl appl = M.appl(term, 0);
        return ImmutableSimpleType.of(SimpleType.SimpleTypeEnum.valueOf(appl.getName()));
    }

    public static Metadata.Direction direction(IStrategoTerm term) {
        IStrategoAppl appl = M.appl(term, 0);
        switch (appl.getName()) {
            case "Bw": {
                return Metadata.Direction.Backward;
            }
            case "Fw": {
                return Metadata.Direction.Forward;
            }
        }
        throw new AssertionError((Object)"Direction was not equal to Fw or Bw");
    }

    private TransferFunction transferFunction(IStrategoTerm term) {
        IStrategoAppl appl = M.appl(term, 2);
        ArgToVarNode[] args = this.argList(M.at(appl, 0));
        Where body = this.where(M.at(appl, 1));
        switch (appl.getName()) {
            case "TransferFunction": {
                return new TransferFunction(null, this.frameStack.peek(), args, body);
            }
            case "InitFunction": {
                return new InitFunction(null, this.frameStack.peek(), args, body);
            }
        }
        throw new AssertionError((Object)"Transfer function was not equal to TransferFunction or InitFunction");
    }

    private Where where(IStrategoTerm appl) {
        IStrategoAppl whereAppl = M.appl(appl, "Where", 2);
        IStrategoList varList = M.list(M.at(whereAppl, 1));
        WriteVarNode[] writeVars = new WriteVarNode[varList.size()];
        int i = 0;
        for (IStrategoTerm varTerm : varList) {
            IStrategoAppl varAppl = M.appl(varTerm, "Binding", 2);
            String name = M.string(M.at(varAppl, 0));
            ExpressionNode expr = this.expressionNode(M.at(varAppl, 1));
            FrameDescriptor fd = this.frameStack.peek();
            writeVars[i] = WriteVarNodeGen.create(expr, fd.findOrAddFrameSlot((Object)name));
            ++i;
        }
        ExpressionNode expr = this.expressionNode(M.at(whereAppl, 0));
        Where body = new Where(writeVars, expr);
        return body;
    }

    public static CompleteLattice latticeFromType(Map<String, CompleteLattice> latticeDefs, Type type) {
        if (type instanceof UserType) {
            UserType utype = (UserType)type;
            return latticeDefs.get(utype.name());
        }
        if (type instanceof MapType) {
            MapType mtype = (MapType)type;
            return new MapLattice(InterpreterBuilder.latticeFromType(latticeDefs, mtype.value()));
        }
        throw new AssertionError((Object)"Type was not UserType or MapType");
    }

    private FunctionInfo functionInfo(IStrategoTerm term) {
        HashMap<String, Function> map = new HashMap<String, Function>();
        for (IStrategoTerm functionTerm : M.list(term)) {
            IStrategoAppl appl = M.appl(functionTerm, "FunDef", 3);
            String name = M.string(M.at(appl, 0));
            IStrategoList argsList = M.list(M.at(appl, 1));
            IStrategoTerm bodyTerm = M.at(appl, 2);
            FrameDescriptor frameDescriptor = new FrameDescriptor();
            ArgToVarNode[] args = new ArgToVarNode[argsList.size()];
            int i = 0;
            for (IStrategoTerm argTerm : argsList) {
                IStrategoAppl arg = M.appl(argTerm, "Arg", 2);
                args[i] = ArgToVarNode.of(frameDescriptor, i, M.string(M.at(arg, 0)));
                ++i;
            }
            this.frameStack.push(frameDescriptor);
            ExpressionNode body = this.expressionNode(bodyTerm);
            this.frameStack.pop();
            Function function = new Function(null, frameDescriptor, args, body);
            map.put(name, function);
        }
        return new FunctionInfo(Collections.unmodifiableMap(map));
    }

    private LatticeInfo latticeInfo(IStrategoTerm term) {
        HashMap latticeDefs = new HashMap();
        latticeDefs.put("MaySet", new FullSetLattice());
        latticeDefs.put("MustSet", new FullSetLattice().flip());
        for (IStrategoTerm tfTerm : M.list(term)) {
            IStrategoTuple tfTuple = M.tuple(tfTerm, 4);
            String name = M.string(M.at(tfTuple, 0));
            IStrategoTuple latticeTuple = M.tuple(M.at(tfTuple, 3), 3);
            Function lub = this.binaryFunction("Lub", M.at(latticeTuple, 0));
            Function top = this.nullaryFunction(M.at(latticeTuple, 1));
            Function bottom = this.nullaryFunction(M.at(latticeTuple, 2));
            UserDefinedLattice udl = new UserDefinedLattice(top, bottom, lub);
            latticeDefs.put(name, udl);
        }
        return new LatticeInfo(Collections.unmodifiableMap(latticeDefs));
    }

    private Function nullaryFunction(IStrategoTerm term) {
        FrameDescriptor frameDescriptor = new FrameDescriptor();
        this.frameStack.push(frameDescriptor);
        ExpressionNode body = this.expressionNode(term);
        this.frameStack.pop();
        return new Function(null, frameDescriptor, new ArgToVarNode[0], body);
    }

    private Function binaryFunction(String op, IStrategoTerm term) {
        IStrategoAppl appl = M.appl(term, op, 3);
        String left = M.string(M.at(appl, 0));
        String right = M.string(M.at(appl, 1));
        FrameDescriptor frameDescriptor = new FrameDescriptor();
        ArgToVarNode[] args = new ArgToVarNode[]{ArgToVarNode.of(frameDescriptor, 0, left), ArgToVarNode.of(frameDescriptor, 1, right)};
        this.frameStack.push(frameDescriptor);
        ExpressionNode body = this.expressionNode(M.at(appl, 2));
        this.frameStack.pop();
        return new Function(null, frameDescriptor, args, body);
    }

    private ExpressionNode expressionNode(IStrategoTerm term) {
        switch (M.appl(term).getName()) {
            case "Term": {
                IStrategoAppl appl = M.appl(term, 2);
                String consName = M.string(M.at(appl, 0));
                ExpressionNode[] exprs = this.exprList(M.at(appl, 1));
                TermNode termNode = new TermNode(consName, exprs);
                this.initializable.add(termNode);
                return termNode;
            }
            case "Ref": {
                IStrategoAppl appl = M.appl(term, 1);
                return this.readVarNode(M.at(appl, 0));
            }
            case "TopOf": {
                IStrategoAppl appl = M.appl(term, 1);
                String name = M.string(M.at(appl, 0));
                LatticeItemRefNode latticeItemRefNode = new LatticeItemRefNode(LatticeItemRefNode.LatticeItem.Top, name);
                this.initializable.add(latticeItemRefNode);
                return latticeItemRefNode;
            }
            case "BottomOf": {
                IStrategoAppl appl = M.appl(term, 1);
                String name = M.string(M.at(appl, 0));
                LatticeItemRefNode latticeItemRefNode = new LatticeItemRefNode(LatticeItemRefNode.LatticeItem.Bottom, name);
                this.initializable.add(latticeItemRefNode);
                return latticeItemRefNode;
            }
            case "Prop": {
                IStrategoAppl appl = M.appl(term, 2);
                String propName = M.string(M.at(appl, 0));
                ReadVarNode rhs = this.readVarNode(M.at(appl, 1));
                PropNode propNode = PropNodeGen.create(propName, rhs);
                this.initializable.add(propNode);
                return propNode;
            }
            case "ExtProp": {
                IStrategoAppl appl = M.appl(term, 2);
                String propName = M.string(M.at(appl, 0));
                ReadVarNode rhs = this.readVarNode(M.at(appl, 1));
                ExtPropNode propNode = new ExtPropNode(propName, rhs);
                this.initializable.add(propNode);
                return propNode;
            }
            case "Tuple": {
                IStrategoAppl appl = M.appl(term, 2);
                IStrategoList exprTerms = M.list(M.at(appl, 1));
                ExpressionNode[] exprs = new ExpressionNode[exprTerms.size() + 1];
                exprs[0] = this.expressionNode(M.at(appl, 0));
                int i = 1;
                for (IStrategoTerm exprTerm : exprTerms) {
                    exprs[i] = this.expressionNode(exprTerm);
                    ++i;
                }
                return new TupleNode(exprs);
            }
            case "Int": {
                IStrategoAppl appl = M.appl(term, 1);
                int value = Integer.parseInt(M.string(M.at(appl, 0)));
                return new IntLiteralNode(value);
            }
            case "String": {
                IStrategoAppl appl = M.appl(term, 1);
                String value = M.string(M.at(appl, 0));
                return new StringLiteralNode(value);
            }
            case "True": {
                M.appl(term, 0);
                BooleanLiteralNode booleanLiteralNode = new BooleanLiteralNode(true);
                this.initializable.add(booleanLiteralNode);
                return booleanLiteralNode;
            }
            case "False": {
                M.appl(term, 0);
                BooleanLiteralNode booleanLiteralNode = new BooleanLiteralNode(false);
                this.initializable.add(booleanLiteralNode);
                return booleanLiteralNode;
            }
            case "Type": {
                IStrategoAppl appl = M.appl(term, 1);
                ReadVarNode rvn = this.readVarNode(M.at(appl, 0));
                return new TypeNode(rvn);
            }
            case "Appl": {
                IStrategoAppl appl = M.appl(term, 2);
                FunRefNode reference = this.funRefNode(M.at(appl, 0));
                ExpressionNode[] exprs = this.exprList(M.at(appl, 1));
                return new ApplicationNode(reference, exprs);
            }
            case "If": {
                IStrategoAppl appl = M.appl(term, 3);
                return new IfNode(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)), this.expressionNode(M.at(appl, 2)));
            }
            case "Eq": {
                IStrategoAppl appl = M.appl(term, 2);
                return EqualNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "NEq": {
                IStrategoAppl appl = M.appl(term, 2);
                return NotNodeGen.create(EqualNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1))));
            }
            case "And": {
                IStrategoAppl appl = M.appl(term, 2);
                return AndNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Or": {
                IStrategoAppl appl = M.appl(term, 2);
                return OrNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Not": {
                IStrategoAppl appl = M.appl(term, 1);
                return NotNodeGen.create(this.expressionNode(M.at(appl, 0)));
            }
            case "Lt": {
                IStrategoAppl appl = M.appl(term, 2);
                return LtNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Lte": {
                IStrategoAppl appl = M.appl(term, 2);
                return LteNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Gt": {
                IStrategoAppl appl = M.appl(term, 2);
                return GtNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Gte": {
                IStrategoAppl appl = M.appl(term, 2);
                return GteNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Add": {
                IStrategoAppl appl = M.appl(term, 2);
                return AddNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Sub": {
                IStrategoAppl appl = M.appl(term, 2);
                return SubNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Mul": {
                IStrategoAppl appl = M.appl(term, 2);
                return MulNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Div": {
                IStrategoAppl appl = M.appl(term, 2);
                return DivNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Mod": {
                IStrategoAppl appl = M.appl(term, 2);
                return ModNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "Neg": {
                IStrategoAppl appl = M.appl(term, 1);
                return NegNodeGen.create(this.expressionNode(M.at(appl, 0)));
            }
            case "Match": {
                IStrategoAppl appl = M.appl(term, 2);
                ExpressionNode expr = this.expressionNode(M.at(appl, 0));
                IStrategoList arms = M.list(M.at(appl, 1));
                PatternNode[] patterns = new PatternNode[arms.size()];
                ExpressionNode[] bodies = new ExpressionNode[arms.size()];
                int i = 0;
                for (IStrategoTerm arm : arms) {
                    IStrategoAppl armAppl = M.appl(arm, "MatchArm", 2);
                    patterns[i] = this.patternNode(M.at(armAppl, 0));
                    bodies[i] = this.expressionNode(M.at(armAppl, 1));
                    ++i;
                }
                return new MatchNode(expr, patterns, bodies);
            }
            case "SetLiteral": {
                IStrategoAppl appl = M.appl(term, 1);
                ExpressionNode[] exprs = this.exprList(M.at(appl, 0));
                return new SetLiteralNode(exprs);
            }
            case "MapLiteral": {
                IStrategoAppl appl = M.appl(term, 1);
                ExpressionNode[] exprs = this.exprList(M.at(appl, 0));
                return new MapLiteralNode(exprs);
            }
            case "SetComp": {
                IStrategoAppl appl = M.appl(term, 4);
                PatternNode[] patterns = this.patternList(M.at(appl, 1));
                ExpressionNode expr = this.expressionNode(M.at(appl, 0));
                ExpressionNode[] exprs = this.exprList(M.at(appl, 2));
                CompPredicateNode[] preds = this.predList(M.at(appl, 3));
                return new SetCompNode(expr, patterns, exprs, preds);
            }
            case "MapComp": {
                IStrategoAppl appl = M.appl(term, 4);
                PatternNode[] patterns = this.patternList(M.at(appl, 1));
                ExpressionNode expr = this.expressionNode(M.at(appl, 0));
                ExpressionNode[] exprs = this.exprList(M.at(appl, 2));
                CompPredicateNode[] preds = this.predList(M.at(appl, 3));
                return new MapCompNode(expr, patterns, exprs, preds);
            }
            case "MapLookup": {
                IStrategoAppl appl = M.appl(term, 2);
                return new MapLookupNode(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "EmptySetOrMapLiteral": {
                M.appl(term, 0);
                return new EmptySetOrMapLiteral();
            }
            case "TermIndex": {
                IStrategoAppl appl = M.appl(term, 1);
                ReadVarNode var = this.readVarNode(M.at(appl, 0));
                return TermIndexNodeGen.create(var);
            }
            case "NaBL2Occurrence": {
                IStrategoAppl appl = M.appl(term, 1);
                IStrategoAppl occurrenceAppl = M.appl(M.at(appl, 0), "Occurrence", 3);
                Namespace ns = InterpreterBuilder.namespace(M.at(occurrenceAppl, 0));
                IStrategoAppl refAppl = M.appl(M.at(occurrenceAppl, 1), "Ref", 1);
                M.appl(M.at(occurrenceAppl, 2), "FSNoIndex", 0);
                ReadVarNode rvn = this.readVarNode(M.at(refAppl, 0));
                NaBL2OccurrenceNode naBL2OccurrenceNode = new NaBL2OccurrenceNode(ns, rvn);
                this.initializable.add(naBL2OccurrenceNode);
                return naBL2OccurrenceNode;
            }
            case "SetUnion": {
                IStrategoAppl appl = M.appl(term, 2);
                return SetUnionNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "SetDifference": {
                IStrategoAppl appl = M.appl(term, 2);
                return SetMinusNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "SetContains": {
                IStrategoAppl appl = M.appl(term, 2);
                return SetContainsNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
            case "SetIntersection": {
                IStrategoAppl appl = M.appl(term, 2);
                return SetIntersectNodeGen.create(this.expressionNode(M.at(appl, 0)), this.expressionNode(M.at(appl, 1)));
            }
        }
        throw new AssertionError((Object)("Unrecognised ExpressionNode: " + term));
    }

    public static Namespace namespace(IStrategoTerm term) {
        String ns;
        switch (M.appl(term).getName()) {
            case "DefaultNamespace": {
                M.appl(term, 0);
                ns = "";
                break;
            }
            case "Namespace": {
                IStrategoAppl appl = M.appl(term, 1);
                ns = M.string(M.at(appl, 0));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognised Namespace: " + term));
            }
        }
        Optional<TermIndex> optTI = mb.flowspec.terms.TermIndex.get(term).map(mb.flowspec.terms.TermIndex::toNaBL2TermIndex);
        if (optTI.isPresent()) {
            return Namespace.of(ns).withAttachments(Attachments.of(TermIndex.class, optTI.get()));
        }
        return Namespace.of(ns);
    }

    private ReadVarNode readVarNode(IStrategoTerm term) {
        String name = M.string(term);
        return ReadVarNodeGen.create(Objects.requireNonNull(this.frameStack.peek().findFrameSlot((Object)name)));
    }

    private PatternNode patternNode(IStrategoTerm term) {
        switch (M.appl(term).getName()) {
            case "Term": {
                IStrategoAppl appl = M.appl(term, 2);
                String consName = M.string(M.at(appl, 0));
                PatternNode[] childPatterns = this.patternList(M.at(appl, 1));
                switch (consName) {
                    case "Cons": {
                        if (childPatterns.length != 2) break;
                        return new ConsPatternNode(childPatterns[0], childPatterns[1]);
                    }
                    case "Nil": {
                        if (childPatterns.length != 0) break;
                        return NilPatternNode.SINGLETON;
                    }
                }
                return new TermPatternNode(consName, childPatterns);
            }
            case "Tuple": {
                IStrategoAppl appl = M.appl(term, 2);
                IStrategoList patternTerms = M.list(M.at(appl, 1));
                PatternNode[] patterns = new PatternNode[patternTerms.size() + 1];
                patterns[0] = this.patternNode(M.at(appl, 0));
                int i = 1;
                for (IStrategoTerm exprTerm : patternTerms) {
                    patterns[i] = this.patternNode(exprTerm);
                    ++i;
                }
                return new TuplePatternNode(patterns);
            }
            case "Wildcard": {
                M.appl(term, 0);
                return WildcardPatternNode.of();
            }
            case "Var": {
                return this.varPattern(term);
            }
            case "At": {
                IStrategoAppl appl = M.appl(term, 2);
                return new AtPatternNode(this.varPattern(M.at(appl, 0)), this.patternNode(M.at(appl, 1)));
            }
            case "Int": {
                IStrategoAppl appl = M.appl(term, 1);
                return new IntLiteralPatternNode(M.integer(M.at(appl, 0)));
            }
            case "String": {
                IStrategoAppl appl = M.appl(term, 1);
                return new StringLiteralPatternNode(M.string(M.at(appl, 0)));
            }
        }
        throw new AssertionError((Object)("Unrecognised PatterNode: " + term));
    }

    private VarPatternNode varPattern(IStrategoTerm term) {
        IStrategoAppl appl = M.appl(term, "Var", 1);
        String name = M.string(M.at(appl, 0));
        return new VarPatternNode(this.frameStack.peek().findOrAddFrameSlot((Object)name));
    }

    private FunRefNode funRefNode(IStrategoTerm term) {
        switch (M.appl(term).getName()) {
            case "Ref": {
                IStrategoAppl appl = M.appl(term, 1);
                FunRefRefNode frrn = new FunRefRefNode(M.string(M.at(appl, 0)));
                this.initializable.add(frrn);
                return frrn;
            }
            case "LubOf": {
                IStrategoAppl appl = M.appl(term, 1);
                LatticeOpRefNode lorn = new LatticeOpRefNode(LatticeOpRefNode.LatticeOp.Lub, M.string(M.at(appl, 0)));
                this.initializable.add(lorn);
                return lorn;
            }
            case "GlbOf": {
                IStrategoAppl appl = M.appl(term, 1);
                LatticeOpRefNode lorn = new LatticeOpRefNode(LatticeOpRefNode.LatticeOp.Glb, M.string(M.at(appl, 0)));
                this.initializable.add(lorn);
                return lorn;
            }
            case "LeqOf": {
                IStrategoAppl appl = M.appl(term, 1);
                LatticeOpRefNode lorn = new LatticeOpRefNode(LatticeOpRefNode.LatticeOp.Leq, M.string(M.at(appl, 0)));
                this.initializable.add(lorn);
                return lorn;
            }
            case "GeqOf": {
                IStrategoAppl appl = M.appl(term, 1);
                LatticeOpRefNode lorn = new LatticeOpRefNode(LatticeOpRefNode.LatticeOp.Geq, M.string(M.at(appl, 0)));
                this.initializable.add(lorn);
                return lorn;
            }
            case "NLeqOf": {
                IStrategoAppl appl = M.appl(term, 1);
                LatticeOpRefNode lorn = new LatticeOpRefNode(LatticeOpRefNode.LatticeOp.NLeq, M.string(M.at(appl, 0)));
                this.initializable.add(lorn);
                return lorn;
            }
            case "QualRef": {
                IStrategoAppl appl = M.appl(term, 2);
                return new QualRefNode(M.string(M.at(appl, 0)), M.string(M.at(appl, 1)));
            }
        }
        throw new AssertionError((Object)("Unrecognised FunNode: " + term));
    }

    private CompPredicateNode compPredicateNode(IStrategoTerm term) {
        switch (M.appl(term).getName()) {
            case "Predicate": {
                IStrategoAppl appl = M.appl(term, 1);
                return new CompPredicateNode(this.expressionNode(M.at(appl, 0)));
            }
            case "MatchPredicate": {
                IStrategoAppl appl = M.appl(term, 2);
                ExpressionNode expr = this.expressionNode(M.at(appl, 0));
                PatternNode[] patterns = this.patternList(M.at(appl, 1));
                return new SetCompMatchPredicateNode(expr, patterns);
            }
        }
        throw new AssertionError((Object)("Unrecognised CompPredicate: " + term));
    }

    private ArgToVarNode[] argList(IStrategoTerm term) {
        IStrategoList argTerms = M.list(term);
        ArgToVarNode[] args = new ArgToVarNode[argTerms.size()];
        int i = 0;
        for (IStrategoTerm argTerm : argTerms) {
            String name = M.string(argTerm);
            FrameDescriptor fd = this.frameStack.peek();
            args[i] = new ArgToVarNode(i, fd.findOrAddFrameSlot((Object)name));
            ++i;
        }
        return args;
    }

    private ExpressionNode[] exprList(IStrategoTerm term) {
        IStrategoList exprTerms = M.list(term);
        ExpressionNode[] exprs = new ExpressionNode[exprTerms.size()];
        int i = 0;
        for (IStrategoTerm exprTerm : exprTerms) {
            exprs[i] = this.expressionNode(exprTerm);
            ++i;
        }
        return exprs;
    }

    private PatternNode[] patternList(IStrategoTerm term) {
        IStrategoList patternTerms = M.list(term);
        PatternNode[] patterns = new PatternNode[patternTerms.size()];
        int i = 0;
        for (IStrategoTerm patternTerm : patternTerms) {
            patterns[i] = this.patternNode(patternTerm);
            ++i;
        }
        return patterns;
    }

    private CompPredicateNode[] predList(IStrategoTerm term) {
        IStrategoList predTerms = M.list(term);
        CompPredicateNode[] preds = new CompPredicateNode[predTerms.size()];
        int i = 0;
        for (IStrategoTerm predTerm : predTerms) {
            preds[i] = this.compPredicateNode(predTerm);
            ++i;
        }
        return preds;
    }
}

