/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import oracle.datastudio.graphviz.formatter.DataStudioFormatter;
import oracle.datastudio.graphviz.gvt.GvtFormatter;
import oracle.datastudio.graphviz.gvt.json.ResultGraph;
import oracle.gvt.models.DatabaseGraphInformation;
import oracle.gvt.models.DynamicForms;
import oracle.gvt.models.GraphSchema;
import oracle.gvt.models.ResultBoth;
import oracle.pg.rdbms.RdbmsDriver;
import oracle.pg.rdbms.sqlpgq.SqlCursorWrapper;
import oracle.pg.rdbms.sqlpgq.SqlExpandQueryBuilder;
import oracle.pg.rdbms.sqlpgq.SqlGraphInformation;
import oracle.pg.rdbms.sqlpgq.SqlPgqResultSetTable;
import oracle.pg.rdbms.sqlpgq.exception.SqlPgqVisualizationException;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.graphviz.driver.CursorWrapper;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.driver.exception.CursorException;
import oracle.pgx.graphviz.driver.exception.GetGraphInformationException;
import oracle.pgx.graphviz.driver.exception.GetGraphSchemaException;
import oracle.pgx.graphviz.driver.exception.VisualizationException;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Result;
import oracle.pgx.graphviz.formatter.ResultType;
import oracle.pgx.graphviz.formatter.Table;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPgqDriver
extends RdbmsDriver {
    private static final Logger LOG = LoggerFactory.getLogger(SqlPgqDriver.class);
    private static final String DATASTUDIO_CLASS_NAME = DataStudioFormatter.class.getName();
    private static final String GVT_CLASS_NAME = GvtFormatter.class.getName();
    private static String getMetadataFunction;
    public static int ORA_CODE_NON_VISUALIZABLE_RESULT;
    public static int ORA_CODE_FUNCTION_NOT_INSTALLED;
    public static int ORA_CODE_NO_DATA_FOUND;
    private static String SQL_FUNCTION_ERROR_MESSAGE;
    private static String SQL_FUNCTION_ERROR_MESSAGE_2;
    private static String SQL_FUNCTION_ERROR_MESSAGE_3;
    public static final String EXECUTION_SUCCESS_MESSAGE = "The statement was executed successfully. No rows returned.";
    public static final String ONE_ROW_PER_STEP_ERROR_MESSAGE = "Visualizing queries that use ONE ROW PER clause cannot use graphs with aliases for vertex or edge tables. Please create a graph without aliases for vertex or edge tables and re-try your query.";
    private static final String OPEN_CURSOR_QUERY = "DECLARE c SYS_REFCURSOR; BEGIN OPEN c FOR ?; ?:= DBMS_SQL.TO_CURSOR_NUMBER(c); END;";
    private static final String QUERY_GET_GRAPH_NAMES = "SELECT OWNER, GRAPH_NAME FROM SYS.ALL_PROPERTY_GRAPHS";
    private static String visualizeQuery;

    public SqlPgqDriver(Map<String, Object> properties) throws SQLException, IOException {
        super(properties);
        visualizeQuery = this.readFunction("/cust_sqlgraph_json.sql") + " BEGIN ? := ORA_SQLGRAPH_TO_JSON(?, ?, ?); END;";
        getMetadataFunction = this.readFunction("/get_graph_metadata.sql");
    }

    private String readFunction(String functionName) throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(functionName), (Charset)StandardCharsets.UTF_8);
    }

    private static Set<GraphName> getGraphNames(Connection conn) throws SQLException {
        HashSet<GraphName> pgSqlNames = new HashSet<GraphName>();
        try (PreparedStatement preparedStatement = conn.prepareStatement(QUERY_GET_GRAPH_NAMES);){
            HashSet<GraphName> hashSet;
            block13: {
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    while (rs.next()) {
                        GraphName graphNameObject;
                        String schema = rs.getString(1);
                        String graphName = rs.getString(2);
                        if (graphName == null || schema == null || pgSqlNames.contains(graphNameObject = new GraphName(schema, graphName))) continue;
                        LOG.debug("Graph added to the list: {}", (Object)graphNameObject.toString());
                        pgSqlNames.add(graphNameObject);
                    }
                    hashSet = pgSqlNames;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashSet;
        }
    }

    public EnhancedResultSet query(@Nonnull String query, String graphName, @Nullable String schema, Map<String, Object> properties) throws PgqlException, SQLException {
        throw new UnsupportedOperationException();
    }

    public String modify(@Nonnull String pgqlQuery, String graphName, Map<String, Object> properties) throws PgqlException, SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection<GraphName> getGraphs(Map<String, Object> properties) throws SQLException {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            Set<GraphName> graphs;
            Set<GraphName> set = graphs = SqlPgqDriver.getGraphNames(conn);
            return set;
        }
    }

    public GraphSchema getGraphSchema(String graphOwner, String graphName, Map<String, Object> properties) throws GetGraphSchemaException {
        LOG.debug("Started get graph schema process for graph: {} and owner: {}", (Object)graphName, (Object)graphOwner);
        String result = "";
        GraphSchema schema = new GraphSchema();
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            String finalQuery = getMetadataFunction + " SELECT get_graph_metadata(?, ?) AS RESULT FROM SYS.DUAL";
            try (PreparedStatement preparedStatement = conn.prepareStatement(finalQuery);){
                preparedStatement.setString(1, graphOwner);
                preparedStatement.setString(2, graphName);
                ResultSet rs = preparedStatement.executeQuery();
                if (rs.next()) {
                    result = rs.getString("RESULT");
                    LOG.debug("Executed get graph schema query, got following result: {}", (Object)result);
                }
            }
            schema = (GraphSchema)mapper.readValue(result, GraphSchema.class);
        }
        catch (SQLException e) {
            throw new GetGraphSchemaException((Throwable)e);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error during graph schema mapping", (Throwable)e);
            throw new IllegalArgumentException("JSON Schema returned by the database was invalid.");
        }
        return schema;
    }

    @Nonnull
    public GraphInformation getGraph(@Nullable String schemaName, @Nonnull String name, Map<String, Object> properties) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectedSupported() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMultipleIterations() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    private String constructTable(Connection conn, String query, int start, int size) throws SQLException {
        ArrayList<String> header = new ArrayList<String>();
        try (PreparedStatement preparedStatement = conn.prepareStatement(query);){
            Object object;
            ResultSet rs = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int count = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String columnName = resultSetMetaData.getColumnName(i);
                header.add(columnName);
            }
            SqlPgqResultSetTable table = new SqlPgqResultSetTable(rs, header);
            if (table.getHeader().size() > 0) {
                object = String.join((CharSequence)"\t", table.getHeader()) + "\n" + StreamSupport.stream(table.getRows().spliterator(), false).skip(start).limit(size).map(cells -> cells.stream().map(DataStudioFormatter::toStringValue).collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
                return object;
            }
            object = "";
            return object;
        }
    }

    private Optional<Result> constructFullJson(String graph, String table, String schema, String graphName) throws JsonProcessingException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ResultGraph resultGraph = (ResultGraph)mapper.readValue(graph, ResultGraph.class);
        ret.put("graph", resultGraph);
        ret.put("name", graphName);
        ret.put("schema", schema);
        ret.put("resultSetId", UUID.randomUUID().toString());
        ret.put("table", table);
        String json = mapper.writeValueAsString(ret);
        LOG.debug("Result as JSON: {}", (Object)json);
        return Optional.of(new Result(ResultType.NETWORK, json));
    }

    private Optional<Result> constructTableJson(String table, String schema, String graphName) throws JsonProcessingException {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("table", table);
        String json = mapper.writeValueAsString(ret);
        return Optional.of(new Result(ResultType.TABLE, json));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Result> execute(String query, @Nullable String schema, String graphName, Map<String, Object> properties) {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            CallableStatement cs;
            block27: {
                if (schema == null) {
                    schema = conn.getSchema();
                }
                String formatterClass = (String)properties.getOrDefault("graphviz.formatter.class", GVT_CLASS_NAME);
                int size = Integer.parseInt(properties.getOrDefault("size", 100).toString());
                int start = Integer.parseInt(properties.getOrDefault("start", 0).toString());
                if (formatterClass.equals(DATASTUDIO_CLASS_NAME)) {
                    throw new IllegalArgumentException("DataStudioFormatter is not longer supported, please use GvtFormatter instead.");
                }
                if (!formatterClass.equals(GVT_CLASS_NAME)) throw new IllegalArgumentException("The formatter specified does not exist");
                String table = null;
                table = this.constructTable(conn, query, start, size);
                if (table != null && table.isEmpty()) {
                    Optional<Result> optional = Optional.of(new Result(ResultType.TEXT, EXECUTION_SUCCESS_MESSAGE));
                    return optional;
                }
                Integer cursorId = this.openCursor(query, conn);
                try {
                    Optional<Result> optional;
                    cs = conn.prepareCall(visualizeQuery);
                    try {
                        cs.registerOutParameter(1, 2005);
                        cs.setLong(2, (long)cursorId.intValue());
                        cs.setInt(3, start);
                        if (size == Integer.MAX_VALUE) {
                            cs.setNull(4, 4);
                        } else {
                            cs.setInt(4, size);
                        }
                        cs.execute();
                        String graphResult = cs.getString(1);
                        if (graphResult == null) break block27;
                        LOG.debug("Result from function {}", (Object)graphResult);
                        optional = this.constructFullJson(graphResult, table, schema, graphName);
                        if (cs == null) return optional;
                    }
                    catch (Throwable graphResult) {
                        if (cs == null) throw graphResult;
                        try {
                            cs.close();
                            throw graphResult;
                        }
                        catch (Throwable throwable) {
                            graphResult.addSuppressed(throwable);
                        }
                        throw graphResult;
                    }
                    cs.close();
                    return optional;
                }
                catch (SQLException e) {
                    int oraCode = e.getErrorCode();
                    if (oraCode == ORA_CODE_NON_VISUALIZABLE_RESULT) {
                        if (StringUtils.containsIgnoreCase((CharSequence)query, (CharSequence)"ONE ROW PER") & e.getMessage().contains("not found in graph")) {
                            throw new IllegalStateException(ONE_ROW_PER_STEP_ERROR_MESSAGE);
                        }
                        if (!e.getMessage().contains(SQL_FUNCTION_ERROR_MESSAGE) && !e.getMessage().contains(SQL_FUNCTION_ERROR_MESSAGE_2)) {
                            if (!e.getMessage().contains(SQL_FUNCTION_ERROR_MESSAGE_3)) throw e;
                        }
                        Optional<Result> optional = this.constructTableJson(table, schema, graphName);
                        if (conn == null) return optional;
                        conn.close();
                        return optional;
                    }
                    if (oraCode == ORA_CODE_FUNCTION_NOT_INSTALLED) {
                        throw new IllegalArgumentException("This feature is only supported on Oracle Database version 23.4 or newer");
                    }
                    if (oraCode != ORA_CODE_NO_DATA_FOUND) throw e;
                    throw new IllegalStateException("The result is empty.");
                }
            }
            if (cs == null) throw new IllegalArgumentException("The formatter specified does not exist");
            cs.close();
            throw new IllegalArgumentException("The formatter specified does not exist");
        }
        catch (IOException | SQLException ex) {
            throw new SqlPgqVisualizationException(ex);
        }
    }

    public Future<Optional<Result>> executeAsync(String query, @Nullable String schema, String graphName, Map<String, Object> properties) {
        CompletableFuture<Optional<Result>> queryExecution = CompletableFuture.supplyAsync(() -> this.execute(query, schema, graphName, properties));
        return queryExecution;
    }

    public Future<CursorWrapper> createCursorWrapperAsync(String connectionId, String query, Map<String, Object> properties) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.createCursorWrapper(connectionId, query, properties);
            }
            catch (CursorException e) {
                throw new RuntimeException(e);
            }
        }).exceptionally(ex -> {
            LOG.debug(ex.getMessage());
            return null;
        });
    }

    public CursorWrapper createCursorWrapper(String connectionId, String query, Map<String, Object> properties) throws CursorException {
        DataSource ds = (DataSource)properties.get("datasource");
        SqlCursorWrapper cursorWrapper = null;
        try {
            Connection connection = ds.getConnection();
            cursorWrapper = new SqlCursorWrapper(connectionId, connection);
            Table table = this.getResultTable(query, connection);
            cursorWrapper.setResultTable(table);
            if (table.getHeader().size() > 0) {
                Integer cursorId = this.openCursor(query, connection);
                cursorWrapper.setCursorId(cursorId);
                if (StringUtils.containsIgnoreCase((CharSequence)query, (CharSequence)"ONE ROW PER")) {
                    cursorWrapper.setHasOneRowPerStep(true);
                }
            }
            return cursorWrapper;
        }
        catch (IOException | SQLException ex) {
            LOG.error("Failed to create cursor and execute query", (Throwable)ex);
            if (cursorWrapper != null) {
                try {
                    cursorWrapper.close();
                }
                catch (SQLException e) {
                    throw new CursorException(e.getMessage());
                }
            }
            if (ex instanceof SQLException) {
                throw new CursorException(ex.getMessage());
            }
            throw new CursorException((Throwable)ex);
        }
    }

    private Integer openCursor(String query, Connection connection) throws SQLException {
        CallableStatement cs = connection.prepareCall(OPEN_CURSOR_QUERY);
        cs.setString(1, query);
        cs.registerOutParameter(2, 2);
        cs.execute();
        Integer cursorId = cs.getInt(2);
        return cursorId;
    }

    private Table getResultTable(String query, Connection connection) throws SQLException {
        ArrayList<String> header = new ArrayList<String>();
        PreparedStatement preparedStatement = connection.prepareStatement(query);
        ResultSet rs = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        int count = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String columnName = resultSetMetaData.getColumnName(i);
            header.add(columnName);
        }
        return new SqlPgqResultSetTable(rs, header);
    }

    public oracle.gvt.models.GraphInformation getGraphInformation(String graphName, @Nullable String schemaName, Map<String, Object> properties) throws GetGraphInformationException {
        DatabaseGraphInformation databaseGraphInformation;
        block8: {
            DataSource dataSource = (DataSource)properties.get("datasource");
            Connection conn = dataSource.getConnection();
            try {
                databaseGraphInformation = SqlGraphInformation.getSqlGraphInformation(schemaName, graphName, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new GetGraphInformationException("An error happened while getting graph information of " + graphName, (Throwable)ex);
                }
            }
            conn.close();
        }
        return databaseGraphInformation;
    }

    public ResultBoth expandGraph(@Nullable String schema, String graphName, String[] selectedVertices, int hops, DynamicForms dynamicFormsParams, Map<String, Object> properties) throws VisualizationException {
        ResultBoth resultBoth;
        String query = "";
        DataSource dataSource = (DataSource)properties.get("datasource");
        try (Connection conn = dataSource.getConnection();){
            LOG.debug("Executing expand action for graphName: {}", (Object)graphName);
            query = SqlExpandQueryBuilder.generateExpandQuery(conn.createStatement(), schema, graphName, selectedVertices, hops);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not get connection from data source.", e);
        }
        Optional<Result> result = this.execute(query, schema, null, properties);
        if (!result.isPresent()) {
            throw new VisualizationException("Result is not present after query execution.");
        }
        if (result.get().getType() != ResultType.NETWORK) {
            throw new VisualizationException("ResultType is not NETWORK.");
        }
        String json = result.get().getJson();
        LOG.debug("JSON obteined from execute API: {}", (Object)json);
        try {
            resultBoth = (ResultBoth)mapper.readValue(json, ResultBoth.class);
        }
        catch (JsonProcessingException e) {
            throw new VisualizationException("Exception happened when trying to build ResultBoth object.", (Throwable)e);
        }
        resultBoth.setResultType(ResultBoth.ResultTypeEnum.GRAPH_AND_TABLE);
        return resultBoth;
    }

    static {
        ORA_CODE_NON_VISUALIZABLE_RESULT = 20000;
        ORA_CODE_FUNCTION_NOT_INSTALLED = 6553;
        ORA_CODE_NO_DATA_FOUND = 1403;
        SQL_FUNCTION_ERROR_MESSAGE = "Please add vertex_id/edge_id in CLOUMNS clause";
        SQL_FUNCTION_ERROR_MESSAGE_2 = "Please add vertex_id/edge_id in both the COLUMNS and SELECT clause";
        SQL_FUNCTION_ERROR_MESSAGE_3 = "Please add vertex_id/edge_id to the COLUMNS clause and project the corresponding column name in the SELECT clause";
    }
}

