/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.gvt.models.DatabaseGraphInformation;
import oracle.gvt.models.GraphState;

public class SqlGraphInformation {
    static final String QUERY_TO_GET_LABEL_OF_SQL_PROPERTY_GRAPH = "SELECT l.label_name, e.element_kind FROM ALL_PG_ELEMENT_LABELS l INNER JOIN ALL_PG_ELEMENTS e ON l.ELEMENT_NAME = e.ELEMENT_NAME WHERE l.owner = ? AND l.graph_name = ?";
    static final String QUERY_TO_GET_PROPERTIES_OF_SQL_PROPERTY_GRAPH = "SELECT lp.property_name, e.element_kind \n    FROM ALL_PG_ELEMENT_LABELS l \n        INNER JOIN \n        ALL_PG_ELEMENTS e ON l.ELEMENT_NAME = e.ELEMENT_NAME \n        INNER JOIN\n        ALL_PG_LABEL_PROPERTIES lp ON l.LABEL_NAME = lp.LABEL_NAME\n    WHERE l.owner = ? AND l.graph_name = ?";

    public static DatabaseGraphInformation getSqlGraphInformation(String owner, String name, Connection conn) throws SQLException {
        String elementKind;
        ResultSet rs;
        DatabaseGraphInformation information = new DatabaseGraphInformation();
        information.setEdgeLabels(new ArrayList());
        information.setVertexLabels(new ArrayList());
        information.setEdgeProperties(new ArrayList());
        information.setVertexProperties(new ArrayList());
        information.setSchema(owner);
        information.setState(GraphState.DATABASE);
        try (PreparedStatement statement = conn.prepareStatement(QUERY_TO_GET_LABEL_OF_SQL_PROPERTY_GRAPH);){
            statement.setString(1, owner);
            statement.setString(2, name);
            rs = statement.executeQuery();
            try {
                while (rs.next()) {
                    String labelName = rs.getString(1);
                    elementKind = rs.getString(2);
                    if (elementKind.equals("VERTEX")) {
                        information.addVertexLabelsItem(labelName);
                        continue;
                    }
                    information.addEdgeLabelsItem(labelName);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        statement = conn.prepareStatement(QUERY_TO_GET_PROPERTIES_OF_SQL_PROPERTY_GRAPH);
        try {
            statement.setString(1, owner);
            statement.setString(2, name);
            rs = statement.executeQuery();
            try {
                while (rs.next()) {
                    String propertyName = rs.getString(1);
                    elementKind = rs.getString(2);
                    if (elementKind.equals("VERTEX")) {
                        information.addVertexPropertiesItem(propertyName);
                        continue;
                    }
                    information.addEdgePropertiesItem(propertyName);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return information;
    }
}

