/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import oracle.pg.rdbms.ExpandQueryBuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExpandQueryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SqlExpandQueryBuilder.class);
    private static final String BASE_PATTERN = "(x)%s -[e]-> (z)";
    private static final String BASE_QUERY = "SELECT * FROM GRAPH_TABLE ( %s MATCH %s %s COLUMNS (%s))";

    private static String getPattern(int hops) {
        String multiHops = hops > 1 ? String.format("->{,%d} (y)", hops - 1) : "";
        return String.format(BASE_PATTERN, multiHops);
    }

    private static String getWhereClause(Statement statement, String[] verticesIds) {
        String formattedIds = "";
        formattedIds = Arrays.stream(verticesIds).map(p -> {
            try {
                return statement.enquoteLiteral((String)p);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Could not enquote this literal: " + p, e);
            }
        }).collect(Collectors.joining(", "));
        return String.format("WHERE JSON_VALUE(vertex_id(x), '$.ELEM_TABLE') || JSON_QUERY(vertex_id(x), '$.KEY_VALUE' RETURNING VARCHAR2) IN (%s)", formattedIds);
    }

    private static String getColumns(int hops) {
        if (hops > 1) {
            return "vertex_id(y) AS id_y, edge_id(e) AS id_e, vertex_id(z) AS id_z";
        }
        return "vertex_id(x) AS id_x, edge_id(e) AS id_e, vertex_id(z) AS id_z";
    }

    public static String generateExpandQuery(Statement statement, @Nullable String schema, String graphName, String[] verticesIds, int hops) {
        String enquotedName = ExpandQueryBuilderUtils.enquotedGraphName(statement, schema, graphName);
        String matchPattern = SqlExpandQueryBuilder.getPattern(hops);
        String whereClause = SqlExpandQueryBuilder.getWhereClause(statement, verticesIds);
        String columns = SqlExpandQueryBuilder.getColumns(hops);
        String query = String.format(BASE_QUERY, enquotedName, matchPattern, whereClause, columns);
        LOG.info("Generated following query for expand action {}", (Object)query);
        return query;
    }
}

