/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import oracle.datastudio.graphviz.formatter.DataStudioFormatter;
import oracle.datastudio.graphviz.gvt.json.ResultGraph;
import oracle.pg.rdbms.sqlpgq.SqlPgqDriver;
import oracle.pgx.graphviz.driver.AbstractCursorWrapper;
import oracle.pgx.graphviz.driver.CursorWrapper;
import oracle.pgx.graphviz.formatter.Result;
import oracle.pgx.graphviz.formatter.ResultType;
import oracle.pgx.graphviz.formatter.Table;
import oracle.pgx.graphviz.formatter.TableException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCursorWrapper
extends AbstractCursorWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SqlCursorWrapper.class);
    private static final String PAGE_START_INDEX_OUT_OF_BOUND = "page_start index exceeds the total number of rows returned. Please reset page_start to a valid value within the range of available results.";
    private static ObjectMapper mapper = new ObjectMapper();
    private static String visualizeQuery;
    private int cursorId = -1;
    private Connection connection;
    private Table table;
    private boolean hasOneRowPerStep = false;

    public SqlCursorWrapper(String connectionId, Connection connection) throws IOException {
        super(connectionId);
        this.connection = connection;
        visualizeQuery = this.readFunction("/cust_sqlgraph_json.sql") + " BEGIN ? := ORA_SQLGRAPH_TO_JSON(?, ?, ?); END;";
    }

    private String readFunction(String functionName) throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(functionName), (Charset)StandardCharsets.UTF_8);
    }

    public Integer getCursorId() {
        return this.cursorId;
    }

    public Table getResultTable() {
        return this.table;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isOneRowPerStep() {
        return this.hasOneRowPerStep;
    }

    public void setCursorId(Integer cursorId) {
        this.cursorId = cursorId;
    }

    public void setResultTable(Table table) {
        this.table = table;
    }

    public void setHasOneRowPerStep(boolean hasOneRowPerStep) {
        this.hasOneRowPerStep = hasOneRowPerStep;
    }

    private void closeResultSet() {
        Table table = this.getResultTable();
        if (table != null && !this.isResultSetDone()) {
            try {
                table.closeResultSet();
                this.setIsResultSetDone(true);
                LOG.info("Successfully closed ResultSet associated with connection ID {}", (Object)this.getConnectionId());
            }
            catch (TableException e) {
                LOG.error("Failed to close ResultSet associated with connection ID {}", (Object)this.getConnectionId(), (Object)e);
            }
        }
    }

    private void closeCursorId() {
        Connection connection = this.getConnection();
        String connectionId = this.getConnectionId();
        if (this.cursorId != -1 && !this.isCursorDone()) {
            try {
                CallableStatement statement = connection.prepareCall("{call DBMS_SQL.CLOSE_CURSOR(?)}");
                statement.setInt(1, this.cursorId);
                statement.execute();
                this.setIsCursorDone(true);
                LOG.info("Successfully closed cursor ID {} associated with connection ID {}", (Object)this.cursorId, (Object)connectionId);
            }
            catch (SQLException e) {
                LOG.error("Failed to close cursor ID {} associated with connection ID {}", new Object[]{this.cursorId, connectionId, e});
            }
        }
    }

    public void close() throws SQLException {
        Connection connection = this.getConnection();
        this.closeResultSet();
        this.closeCursorId();
        this.setCursorPosition(-1L);
        if (connection != null) {
            connection.close();
        }
    }

    public String getSchema() throws SQLException {
        return this.getConnection().getSchema();
    }

    public boolean isConnectionClosed() throws SQLException {
        return this.getConnection().isClosed();
    }

    public boolean isResultSetClosed() throws SQLException {
        return this.table.isResultSetClosed();
    }

    public int getResultSetRow() throws SQLException {
        return this.table.getRow();
    }

    private ResultGraph getGraphResultObject(CursorWrapper cursorWrapper, Map<String, Object> properties) throws SQLException, JsonMappingException, JsonProcessingException {
        ResultGraph resultGraph;
        block13: {
            Connection conn = this.getConnection();
            Integer cursorId = this.getCursorId();
            CallableStatement cs = conn.prepareCall(visualizeQuery);
            try {
                ResultGraph result;
                cs.registerOutParameter(1, 2005);
                int size = Integer.parseInt(properties.getOrDefault("size", 100).toString());
                int start = Integer.parseInt(properties.getOrDefault("start", 0).toString());
                cs.setLong(2, (long)cursorId.intValue());
                cs.setInt(3, start);
                if (size == Integer.MAX_VALUE) {
                    cs.setNull(4, 4);
                } else {
                    cs.setInt(4, size);
                }
                cs.execute();
                String graphResult = cs.getString(1);
                long numOfResults = mapper.readTree(graphResult).get("numResults").asLong();
                this.setCursorPosition(Math.max(0L, this.getCursorPosition()) + numOfResults);
                JsonNode isLastResultSetNode = mapper.readTree(graphResult).get("isLastResultSet");
                if (isLastResultSetNode == null || isLastResultSetNode.asBoolean()) {
                    this.closeCursorId();
                }
                resultGraph = result = (ResultGraph)mapper.readValue(graphResult, ResultGraph.class);
                if (cs == null) break block13;
            }
            catch (Throwable size) {
                try {
                    if (cs != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable) {
                            size.addSuppressed(throwable);
                        }
                    }
                    throw size;
                }
                catch (SQLException e) {
                    int oraCode = e.getErrorCode();
                    if (oraCode == SqlPgqDriver.ORA_CODE_FUNCTION_NOT_INSTALLED) {
                        throw new IllegalArgumentException("This feature is only supported on Oracle Database version 23.4 or newer");
                    }
                    if (oraCode == SqlPgqDriver.ORA_CODE_NO_DATA_FOUND && this.isOneRowPerStep()) {
                        throw new IllegalStateException("Visualizing queries that use ONE ROW PER clause cannot use graphs with aliases for vertex or edge tables. Please create a graph without aliases for vertex or edge tables and re-try your query.");
                    }
                    throw e;
                }
            }
            cs.close();
        }
        return resultGraph;
    }

    public Optional<Result> getGraphResult(Map<String, Object> properties) throws JsonMappingException, JsonProcessingException, SQLException {
        if (this.isCursorDone()) {
            return Optional.of(new Result(ResultType.TEXT, "No additional results are available."));
        }
        ResultGraph resultGraph = this.getGraphResultObject((CursorWrapper)this, properties);
        String json = mapper.writeValueAsString((Object)resultGraph);
        return Optional.of(new Result(ResultType.NETWORK, json));
    }

    private String getTableHeaderString() {
        Table table = this.getResultTable();
        if (table == null) {
            return "";
        }
        if (table.getHeader().size() > 0) {
            String headerString = String.join((CharSequence)"\t", table.getHeader());
            return headerString;
        }
        return "The statement was executed successfully. No rows returned.";
    }

    public Optional<Result> getTableHeaderResult() throws JsonProcessingException {
        String headerString = this.getTableHeaderString();
        if (headerString == "The statement was executed successfully. No rows returned.") {
            return Optional.of(new Result(ResultType.TEXT, "The statement was executed successfully. No rows returned."));
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("tableHeader", headerString);
        String json = mapper.writeValueAsString(ret);
        LOG.debug("Table Header Result as JSON: {}", (Object)json);
        return Optional.of(new Result(ResultType.TABLE, json));
    }

    private String getTableString(Map<String, Object> properties) throws SQLException {
        Table table = this.getResultTable();
        int size = Integer.parseInt(properties.getOrDefault("size", 100).toString());
        int start = Integer.parseInt(properties.getOrDefault("start", 0).toString());
        if (table == null) {
            return "";
        }
        if (table.getHeader().size() > 0) {
            String tableString = StreamSupport.stream(table.getRows().spliterator(), false).skip(start).limit(size).map(cells -> cells.stream().map(DataStudioFormatter::toStringValue).collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
            if (this.isResultSetClosed()) {
                this.setIsResultSetDone(true);
            }
            return tableString;
        }
        return "The statement was executed successfully. No rows returned.";
    }

    public Optional<Result> getTableDataResult(Map<String, Object> properties) throws SQLException, JsonProcessingException {
        if (this.isResultSetDone()) {
            return Optional.of(new Result(ResultType.TEXT, "No additional results are available."));
        }
        String tableResultString = this.getTableString(properties);
        if (tableResultString == "The statement was executed successfully. No rows returned.") {
            return Optional.of(new Result(ResultType.TEXT, "The statement was executed successfully. No rows returned."));
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("tableResult", tableResultString);
        String json = mapper.writeValueAsString(ret);
        LOG.debug("Table Result Result as JSON: {}", (Object)json);
        return Optional.of(new Result(ResultType.TABLE, json));
    }

    private Optional<Result> getTableResult(Map<String, Object> properties) throws JsonMappingException, JsonProcessingException, SQLException {
        Optional<Result> tableHeader = this.getTableHeaderResult();
        Optional<Result> tableData = this.getTableDataResult(properties);
        if (tableHeader.isPresent() && tableHeader.get().getType() == ResultType.TEXT) {
            return tableHeader;
        }
        if (tableData.isPresent() && tableData.get().getType() == ResultType.TEXT) {
            return tableData;
        }
        String headerJsonStr = tableHeader.isPresent() ? tableHeader.get().getJson() : "";
        String dataJsonStr = tableData.isPresent() ? tableData.get().getJson() : "";
        Map tableHeaderMap = (Map)mapper.readValue(headerJsonStr, Map.class);
        Object headerStr = (String)tableHeaderMap.get("tableHeader");
        headerStr = (String)headerStr + (((String)headerStr).equals("") ? "" : "\n");
        Map tableDataMap = (Map)mapper.readValue(dataJsonStr, Map.class);
        String dataStr = (String)tableDataMap.get("tableResult");
        return Optional.of(new Result(ResultType.TABLE, (String)headerStr + dataStr));
    }

    public Optional<Result> getResult(Map<String, Object> properties) throws JsonProcessingException, SQLException {
        HashMap<String, String> ret = new HashMap<String, String>();
        boolean visualize = properties.get("includeNetwork") != null && (Boolean)properties.get("includeNetwork") != false;
        String schema = this.getSchema();
        ResultType resultType = ResultType.TABLE;
        properties.put("start", Integer.toString(0));
        Optional<Result> tableResult = this.getTableResult(properties);
        ret.put("schema", schema);
        ret.put("name", null);
        ret.put("resultSetId", UUID.randomUUID().toString());
        ret.put("table", tableResult.isPresent() ? tableResult.get().getJson() : "");
        if (visualize) {
            try {
                Optional<Result> graphResult = this.getGraphResult(properties);
                Object graphResultAsObject = "";
                if (graphResult.isPresent()) {
                    if (graphResult.get().getType() == ResultType.NETWORK) {
                        graphResultAsObject = mapper.readValue(graphResult.get().getJson(), ResultGraph.class);
                        ret.put("name", ((ResultGraph)graphResultAsObject).graphName);
                    } else {
                        graphResultAsObject = graphResult.get().getJson();
                    }
                }
                ret.put("graph", (String)graphResultAsObject);
                resultType = ResultType.NETWORK;
            }
            catch (SQLException e) {
                int oraCode = e.getErrorCode();
                LOG.debug("Failed to read graph result with code {} and message {}", (Object)e.getErrorCode(), (Object)e.getMessage());
                if (oraCode == SqlPgqDriver.ORA_CODE_NON_VISUALIZABLE_RESULT && e.getMessage().contains(PAGE_START_INDEX_OUT_OF_BOUND)) {
                    ResultGraph resultGraph = new ResultGraph();
                    resultGraph.vertices = new ArrayList();
                    resultGraph.edges = new ArrayList();
                    resultGraph.numResults = 0L;
                    resultGraph.isLastResultSet = true;
                    resultGraph.graphOwner = schema;
                    resultGraph.graphName = null;
                    ret.put("graph", (String)resultGraph);
                }
                throw e;
            }
        }
        String result = mapper.writeValueAsString(ret);
        LOG.debug("Result of query execution: {}", (Object)result);
        return Optional.of(new Result(resultType, result));
    }
}

