/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import oracle.pg.rdbms.pgql.PgProperty;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlPreparedStatement;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.driver.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PgViewMetadataInformation
implements GraphInformation {
    private static final String PG_VIEW_POSTFIX = "_ELEM_TABLE$";
    private static final String PGVIEW_NAMES_QUERY = "SELECT OWNER, SUBSTR(TABLE_NAME, 1, LENGTH(TABLE_NAME) - 12) FROM SYS.ALL_TABLES WHERE TABLE_NAME LIKE '%ELEM_TABLE$'";
    private static final String EDGE_QUERY_WITH_SCHEMA_PGM = "SELECT DISTINCT l.label_name, p.property_name FROM MATCH (g:property_graph)-[:has_edge_table]->(v)-[:has_label]->(l:label)-[:has_property]->(p:property) ON property_graph_metadata WHERE g.graph_name = ? AND g.owner = ?";
    private static final String VERTEX_QUERY_WITH_SCHEMA_PGM = "SELECT DISTINCT l.label_name, p.property_name FROM MATCH (g:property_graph)-[:has_vertex_table]->(v)-[:has_label]->(l:label)-[:has_property]->(p:property) ON property_graph_metadata WHERE g.graph_name = ? AND g.owner = ?";
    private static final String LABELS_PROPERTIES_QUERY = "SELECT l.LABEL_NAME, p.COLUMN_NAME, l.ET_TYPE FROM %s l LEFT JOIN %s p ON l.LABEL_NAME = p.LABEL_NAME";
    private final Connection conn;
    private final String graphName;
    private final String schemaName;
    private final Map<Set<String>, Set<String>> vertexPropertiesPerLabel = new HashMap<Set<String>, Set<String>>();
    private final Map<Set<String>, Set<String>> edgePropertiesPerLabel = new HashMap<Set<String>, Set<String>>();
    private static final Logger LOG = LoggerFactory.getLogger(PgViewMetadataInformation.class);

    public PgViewMetadataInformation(String schemaName, String graphName, Connection conn) throws PgqlException, SQLException {
        this.conn = conn;
        this.schemaName = schemaName == null ? this.conn.getSchema() : schemaName;
        this.graphName = graphName;
        if ("PROPERTY_GRAPH_METADATA".equals(graphName)) {
            this.getGraphMetadataFromPropertyGraphMetadata(EDGE_QUERY_WITH_SCHEMA_PGM, false);
            this.getGraphMetadataFromPropertyGraphMetadata(VERTEX_QUERY_WITH_SCHEMA_PGM, true);
        } else {
            this.checkIfGraphExists(schemaName, graphName);
            this.getGraphMetadataFromPgViewMetadataTables(LABELS_PROPERTIES_QUERY);
        }
    }

    private void checkIfGraphExists(String schema, String graphName) throws SQLException {
        String query = "";
        query = this.schemaName == null ? "SELECT TABLE_NAME FROM SYS.ALL_TABLES WHERE TABLE_NAME LIKE ? OR OWNER = ?" : "SELECT TABLE_NAME FROM SYS.ALL_TABLES WHERE TABLE_NAME LIKE ? AND OWNER = ?";
        try (PreparedStatement preparedStatement = this.conn.prepareStatement(query);){
            preparedStatement.setString(1, graphName + PG_VIEW_POSTFIX);
            preparedStatement.setString(2, this.schemaName);
            try (ResultSet rs = preparedStatement.executeQuery();){
                if (!rs.next()) {
                    throw new NoSuchElementException(String.format("no graph named %s found in database", graphName));
                }
            }
        }
    }

    private void getGraphMetadataFromPropertyGraphMetadata(String query, boolean isVertex) throws PgqlException {
        PgqlConnection pgqlConnection = PgqlConnection.getConnection((Connection)this.conn);
        try (PgqlPreparedStatement statement = pgqlConnection.prepareStatement(query);){
            statement.setString(1, this.graphName);
            if (this.schemaName != null) {
                statement.setString(2, this.schemaName);
            }
            try (PgqlResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    Set<String> label = Set.of(rs.getString(1));
                    String property = rs.getString(2);
                    if (label == null || property == null) continue;
                    if (isVertex) {
                        this.vertexPropertiesPerLabel.putIfAbsent(label, new HashSet());
                        this.vertexPropertiesPerLabel.get(label).add(property);
                    } else {
                        this.edgePropertiesPerLabel.putIfAbsent(label, new HashSet());
                        this.edgePropertiesPerLabel.get(label).add(property);
                    }
                    LOG.debug("Included property {} for label {}", (Object)property, label);
                }
            }
        }
    }

    private void getGraphMetadataFromPgViewMetadataTables(String query) throws SQLException {
        try (Statement stmnt = this.conn.createStatement();){
            SchemaQualifiedName schemaQualifiedNameLabel = new SchemaQualifiedName(this.schemaName, this.graphName + "_LABEL$");
            SchemaQualifiedName schemaQualifiedNameProperty = new SchemaQualifiedName(this.schemaName, this.graphName + "_PROPERTY$");
            String queryWithTableName = String.format(query, schemaQualifiedNameLabel.toString(), schemaQualifiedNameProperty.toString());
            try (ResultSet rs = stmnt.executeQuery(queryWithTableName);){
                while (rs.next()) {
                    Set<String> label = Set.of(rs.getString(1));
                    String property = rs.getString(2);
                    String type = rs.getString(3);
                    if (label == null || type == null) continue;
                    if (type.equals("VERTEX")) {
                        this.vertexPropertiesPerLabel.putIfAbsent(label, new HashSet());
                        if (property != null) {
                            this.vertexPropertiesPerLabel.get(label).add(property);
                        }
                    } else {
                        this.edgePropertiesPerLabel.putIfAbsent(label, new HashSet());
                        if (property != null) {
                            this.edgePropertiesPerLabel.get(label).add(property);
                        }
                    }
                    LOG.debug("Included property {} for label {}, which is type {}", new Object[]{property, label, type});
                }
            }
        }
    }

    public static Set<GraphName> getPgViewNames(Connection conn) throws SQLException {
        HashSet<GraphName> pgViews = new HashSet<GraphName>();
        try (Statement stmnt = conn.createStatement();){
            ResultSet rs = stmnt.executeQuery(PGVIEW_NAMES_QUERY);
            while (rs.next()) {
                String schema = rs.getString(1);
                String graphName = rs.getString(2);
                if (schema == null || graphName == null) continue;
                GraphName graphNameObject = new GraphName(schema, graphName);
                LOG.debug("PG View name added to the list: {}", (Object)graphNameObject.toString());
                pgViews.add(graphNameObject);
            }
        }
        return pgViews;
    }

    public String getSchema() {
        return this.schemaName;
    }

    public String getGraphName() {
        return this.graphName;
    }

    @Nonnull
    public Set<Property> getVertexProperties() {
        return this.vertexPropertiesPerLabel.values().stream().flatMap(Collection::stream).map(PgProperty::new).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<Property> getEdgeProperties() {
        return this.edgePropertiesPerLabel.values().stream().flatMap(Collection::stream).map(PgProperty::new).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<String> getEdgeLabels() {
        return this.edgePropertiesPerLabel.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<String> getVertexLabels() {
        return this.vertexPropertiesPerLabel.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getVertexProperties(Set<String> label) {
        return this.vertexPropertiesPerLabel.get(label);
    }

    public Set<String> getEdgeProperties(Set<String> label) {
        return this.edgePropertiesPerLabel.get(label);
    }
}

