/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.shell.aargparse.impl;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.pgx.shell.aargparse.Arg;
import oracle.pgx.shell.aargparse.Argument;
import oracle.pgx.shell.aargparse.ArgumentAction;
import oracle.pgx.shell.aargparse.ArgumentConverter;
import oracle.pgx.shell.aargparse.ArgumentGroup;
import oracle.pgx.shell.aargparse.ArgumentParser;
import oracle.pgx.shell.aargparse.exceptions.ArgumentParserException;
import oracle.pgx.shell.aargparse.impl.ArgumentGroupImpl;
import oracle.pgx.shell.aargparse.impl.ArgumentImpl;

public class ArgumentParserImpl
extends ArgumentGroupImpl
implements ArgumentParser {
    private final List<ArgumentGroupImpl> argumentGroups = new ArrayList<ArgumentGroupImpl>();
    private final List<ArgumentImpl> allArgs = new ArrayList<ArgumentImpl>();
    private String version;

    public ArgumentParserImpl(String parserName) {
        super(null, parserName);
        this.argumentGroups.add(this.thisArgumentGroup());
    }

    protected ArgumentGroupImpl thisArgumentGroup() {
        return this;
    }

    public void doAdd(ArgumentImpl arg) {
        this.allArgs.add(arg);
    }

    @Override
    public void parseArgs(String[] arguments, Object argumentsHolder) throws ArgumentParserException {
        ArrayList<ArgumentImpl> positionalArgumentsMap = new ArrayList<ArgumentImpl>();
        HashMap<String, ArgumentImpl> shortArgumentsMap = new HashMap<String, ArgumentImpl>();
        HashMap<String, ArgumentImpl> longArgumentsMap = new HashMap<String, ArgumentImpl>();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.buildArgumentMap(positionalArgumentsMap, longArgumentsMap, shortArgumentsMap, attributes);
        this.doParseArgs(positionalArgumentsMap, longArgumentsMap, shortArgumentsMap, attributes, arguments);
        this.setFieldsFromAttributes(argumentsHolder, attributes);
    }

    private void setFieldsFromAttributes(Object argumentsHolder, Map<String, Object> attributes) {
        for (Field f : argumentsHolder.getClass().getFields()) {
            Object value;
            Arg annotation;
            if (Modifier.isStatic(f.getModifiers()) || (annotation = f.getAnnotation(Arg.class)) == null) continue;
            String dest = annotation.dest();
            if (dest == null || dest.isEmpty()) {
                dest = f.getName();
            }
            if ((value = attributes.get(dest)) == null) continue;
            this.setFieldToValue(argumentsHolder, f, dest, value);
        }
    }

    private void setFieldToValue(Object argumentsHolder, Field f, String destination, Object v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        Class<?> fieldType = f.getType();
        Class<?> valueType = v.getClass();
        if (fieldType.isArray() && !valueType.isArray()) {
            Class<?> componentType = fieldType.getComponentType();
            if (v instanceof List) {
                List l = (List)v;
                v = l.toArray((Object[])Array.newInstance(componentType, l.size()));
            } else if (valueType.isAssignableFrom(componentType)) {
                Object[] arr = (Object[])Array.newInstance(componentType, 1);
                arr[0] = v;
                v = arr;
            } else {
                throw new IllegalStateException("coult not convert to array");
            }
        }
        try {
            f.set(argumentsHolder, v);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("could not set field " + f.getName() + " with destination " + destination + " to " + v);
        }
    }

    private void doParseArgs(List<ArgumentImpl> positionalArgumentsMap, Map<String, ArgumentImpl> longArgumentsMap, Map<String, ArgumentImpl> shortArgumentsMap, Map<String, Object> attributes, String[] arguments) throws ArgumentParserException {
        int currentPositionalArgIndex = 0;
        ArrayList<String> argValues = new ArrayList<String>();
        int argIndex = 0;
        while (argIndex < arguments.length) {
            boolean positional = false;
            argValues.clear();
            String providedArg = arguments[argIndex];
            boolean looksLikeAnArg = this.looksLikeShortOrLongArg(providedArg);
            ArgumentImpl argument = null;
            if (looksLikeAnArg && (argument = this.getShortOrLongArg(longArgumentsMap, shortArgumentsMap, providedArg)) == null) {
                throw new ArgumentParserException(this, null, providedArg, "Unrecognized argument " + providedArg);
            }
            if (argument == null && currentPositionalArgIndex < positionalArgumentsMap.size()) {
                positional = true;
                argument = positionalArgumentsMap.get(currentPositionalArgIndex++);
            }
            if (argument == null) {
                throw new ArgumentParserException(this, null, providedArg, "Could not find argument " + providedArg);
            }
            String destination = argument.getDest();
            String embeddedValue = ArgumentParserImpl.getEmbeddedArg(providedArg);
            ArgumentAction action = argument.getAction();
            if (action != null && !action.consumeArguments()) {
                if (embeddedValue != null) {
                    throw new ArgumentParserException(this, argument, providedArg, "Argument was given a value but shouldn't have one");
                }
                action.run(this, argument, attributes, null);
                ++argIndex;
                continue;
            }
            int minArgs = argument.getMinArgs();
            int maxArgs = argument.getMaxArgs();
            if (!positional && embeddedValue != null) {
                if (minArgs > 1) {
                    throw new ArgumentParserException(this, argument, providedArg, "Did not receive enough values");
                }
                argValues.add(embeddedValue);
            } else {
                String potentialValue;
                int nextArg;
                int n = nextArg = positional ? argIndex : argIndex + 1;
                while (nextArg < arguments.length && argValues.size() < maxArgs && !this.looksLikeShortOrLongArg(potentialValue = arguments[nextArg])) {
                    argValues.add(potentialValue);
                    argIndex = nextArg++;
                }
            }
            int argValuesSize = argValues.size();
            if (argValuesSize < minArgs) {
                throw new IllegalArgumentException("not enough values provided to " + destination);
            }
            if (argValuesSize > maxArgs) {
                throw new IllegalArgumentException("too many values provided to " + destination);
            }
            Object values = this.convertValues(argValues, argument);
            if (values != null) {
                attributes.put(destination, values);
            }
            if (action != null) {
                action.run(this, argument, attributes, values);
            }
            ++argIndex;
        }
    }

    private static String getEmbeddedArg(String providedArg) {
        int eqIndex = providedArg.indexOf(61);
        if (eqIndex != -1) {
            return providedArg.substring(eqIndex + 1);
        }
        return null;
    }

    private Object convertValues(List<String> argValues, ArgumentImpl argument) throws ArgumentParserException {
        Object argumentDefaultValue = argument.getDefaultValue();
        if (argValues.isEmpty()) {
            return argumentDefaultValue;
        }
        ArgumentConverter<?> converter = argument.getConverter();
        if (converter != null) {
            ArrayList convertedValues = new ArrayList();
            for (String argValue : argValues) {
                convertedValues.add(converter.convert(this, argument, argValue));
            }
            if (convertedValues.size() == 1) {
                return convertedValues.get(0);
            }
            return convertedValues;
        }
        if (argValues.size() == 1) {
            return argValues.get(0);
        }
        return new ArrayList<String>(argValues);
    }

    private boolean looksLikeShortOrLongArg(String providedArg) {
        return providedArg.charAt(0) == '-';
    }

    private ArgumentImpl getShortOrLongArg(Map<String, ArgumentImpl> longArgumentsMap, Map<String, ArgumentImpl> shortArgumentsMap, String providedArg) {
        boolean positionalForm = false;
        boolean longForm = false;
        int startOfFlag = 0;
        int endOfFlag = providedArg.length();
        if (providedArg.charAt(0) == '-') {
            if (providedArg.charAt(1) == '-') {
                startOfFlag = 2;
                longForm = true;
            } else {
                startOfFlag = 1;
            }
        } else {
            return null;
        }
        int eqPos = providedArg.indexOf(61);
        if (eqPos != -1) {
            endOfFlag = eqPos;
        }
        String flag = providedArg.substring(startOfFlag, endOfFlag);
        if (longForm) {
            return longArgumentsMap.get(flag);
        }
        return shortArgumentsMap.get(flag);
    }

    private void buildArgumentMap(List<ArgumentImpl> posArgumentMap, Map<String, ArgumentImpl> longArgumentMap, Map<String, ArgumentImpl> shortArgumentMap, Map<String, Object> attributes) {
        this.allArgs.forEach(arg -> {
            Object defVal;
            String destination = arg.getDest();
            String positionalForm = arg.getPositionalForm();
            String longForm = arg.getLongForm();
            String shortForm = arg.getShortForm();
            if (positionalForm != null) {
                posArgumentMap.add((ArgumentImpl)arg);
            }
            if (longForm != null) {
                this.addInArgMap((ArgumentImpl)arg, longForm, longArgumentMap);
            }
            if (shortForm != null) {
                this.addInArgMap((ArgumentImpl)arg, shortForm, shortArgumentMap);
            }
            if ((defVal = arg.getDefaultValue()) != null) {
                attributes.put(destination, defVal);
            }
        });
    }

    private void addInArgMap(ArgumentImpl arg, String positionalForm, Map<String, ArgumentImpl> map) {
        Argument prevArgument = map.put(positionalForm, arg);
        if (prevArgument != null && prevArgument != arg) {
            throw new IllegalStateException("An argument with flag " + positionalForm + " was already present");
        }
    }

    @Override
    public void printHelp() {
        this.printHelp(System.out);
    }

    protected void printHelp(PrintStream stream) {
        String lineSeparator = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        this.printUsage(lineSeparator, stringBuilder);
        this.printCommandHelps(stream, lineSeparator, stringBuilder);
    }

    private void printUsage(String lineSeparator, StringBuilder stringBuilder) {
        int maxPerLine = 4;
        stringBuilder.append("usage: ").append(this.getGroupDesc()).append(' ');
        int currentOnLine = this.printNonPositionalArgs(maxPerLine, lineSeparator, stringBuilder);
        this.printPositionalArgs(maxPerLine, lineSeparator, currentOnLine, stringBuilder);
        stringBuilder.append(lineSeparator).append(lineSeparator);
    }

    private int printNonPositionalArgs(int maxPerLine, String lineSeparator, StringBuilder stringBuilder) {
        int currentOnLine = 0;
        for (ArgumentImpl arg : this.allArgs) {
            String shortForm = arg.getShortForm();
            String longForm = arg.getLongForm();
            String positionalForm = arg.getPositionalForm();
            if (positionalForm != null) continue;
            currentOnLine = this.breakLineIfNecessary(maxPerLine, lineSeparator, stringBuilder, currentOnLine);
            stringBuilder.append('[');
            if (shortForm != null) {
                stringBuilder.append('-').append(shortForm);
            }
            if (longForm != null) {
                if (shortForm != null) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("--").append(longForm);
            }
            stringBuilder.append(']');
        }
        return currentOnLine;
    }

    private void printPositionalArgs(int maxPerLine, String lineSeparator, int currentOnLine, StringBuilder stringBuilder) {
        for (ArgumentImpl positionalArg : this.allArgs) {
            String positionalForm = positionalArg.getPositionalForm();
            if (positionalForm == null) continue;
            currentOnLine = this.breakLineIfNecessary(maxPerLine, lineSeparator, stringBuilder, currentOnLine);
            stringBuilder.append(' ').append(positionalForm).append(' ');
        }
    }

    private int breakLineIfNecessary(int maxPerLine, String lineSeparator, StringBuilder stringBuilder, int currentOnLine) {
        if (currentOnLine == maxPerLine) {
            stringBuilder.append(lineSeparator);
            currentOnLine = 0;
        }
        return ++currentOnLine;
    }

    private void printCommandHelps(PrintStream stream, String lineSeparator, StringBuilder stringBuilder) {
        stringBuilder.append("Command usages:").append(lineSeparator);
        int identLevel = 1;
        for (ArgumentGroupImpl argumentGroup : this.argumentGroups) {
            if (argumentGroup != this) {
                this.ident(stringBuilder, identLevel);
                stringBuilder.append(argumentGroup.getGroupDesc()).append(":").append(lineSeparator);
            }
            for (ArgumentImpl argument : argumentGroup.argumentList) {
                this.printArgHelp(lineSeparator, identLevel, stringBuilder, argument);
            }
            stringBuilder.append(lineSeparator);
        }
        stream.println(stringBuilder);
    }

    private void printArgHelp(String lineSeparator, int identLevel, StringBuilder stringBuilder, ArgumentImpl argument) {
        String longForm;
        String dest = argument.getDest();
        this.ident(stringBuilder, identLevel + 1);
        stringBuilder.append(dest).append(": ");
        String shortForm = argument.getShortForm();
        if (shortForm != null) {
            stringBuilder.append('-').append(shortForm).append(' ');
        }
        if ((longForm = argument.getLongForm()) != null) {
            stringBuilder.append("--").append(longForm).append(' ');
        }
        if (shortForm == null && longForm == null) {
            stringBuilder.append("(positional)");
        }
        stringBuilder.append(lineSeparator);
        this.ident(stringBuilder, identLevel + 2);
        stringBuilder.append(argument.getHelp()).append(lineSeparator);
        stringBuilder.append(lineSeparator);
    }

    private StringBuilder ident(StringBuilder b, int n) {
        String ident = "  ";
        while (n > 0) {
            b.append(ident);
            --n;
        }
        return b;
    }

    @Override
    public void printVersion() {
        this.printVersion(System.out);
    }

    protected void printVersion(PrintStream stream) {
        stream.println(this.version);
    }

    @Override
    public void version(String version) {
        this.version = version;
    }

    @Override
    public ArgumentGroup addArgumentGroup(String groupDesc) {
        ArgumentGroupImpl argumentGroup = new ArgumentGroupImpl(this, groupDesc);
        this.argumentGroups.add(argumentGroup);
        return argumentGroup;
    }

    @Override
    public void handleError(ArgumentParserException e) {
        this.handleError(e, System.err);
    }

    public void handleError(ArgumentParserException e, PrintStream stream) {
        String lineSeparator = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        this.printUsage(lineSeparator, stringBuilder);
        stringBuilder.append(this.getGroupDesc());
        Argument argument = e.getArgument();
        if (argument == null) {
            stringBuilder.append(": unrecognized argument: ").append(e.getProvidedArg());
        } else {
            stringBuilder.append(": error while parsing argument: ").append(argument.getDest());
            stringBuilder.append(" from provided value ").append(e.getProvidedArg());
        }
        stringBuilder.append(lineSeparator);
        if (e.getMessage() != null) {
            stringBuilder.append(e.getMessage());
        }
        stringBuilder.append(lineSeparator);
        stream.print(stringBuilder.toString());
    }
}

