/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib.loss;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import oracle.pgx.common.GmParseException;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.SupervisedGraphWiseModelConfig;
import oracle.pgx.config.mllib.loss.LossFunction;

public class DevNetLoss
extends LossFunction {
    public static final double DEFAULT_CONFIDENCE_MARGIN = 5.0;
    public static final int EXPECTED_CLASSES = 2;
    private final double confidenceMargin;
    private final String anomalyPropertyStringValue;
    private PropertyType labelType;

    @JsonCreator
    public DevNetLoss(@JsonProperty(value="confidenceMargin") double confidenceMargin, @JsonProperty(value="labelType") PropertyType labelType, @JsonProperty(value="anomalyPropertyStringValue") String anomalyPropertyStringValue) {
        super(LossFunction.LossType.DEVNET);
        this.confidenceMargin = confidenceMargin;
        this.labelType = labelType;
        this.anomalyPropertyStringValue = anomalyPropertyStringValue;
    }

    public DevNetLoss(Object anomalyPropertyValue) {
        this(5.0, anomalyPropertyValue);
    }

    public DevNetLoss(double confidenceMargin, Object anomalyPropertyValue) {
        super(LossFunction.LossType.DEVNET);
        this.confidenceMargin = confidenceMargin;
        this.anomalyPropertyStringValue = anomalyPropertyValue.toString();
        for (PropertyType propertyType : SupervisedGraphWiseModelConfig.SUPPORTED_LABEL_TYPES) {
            if (!propertyType.getTypeClass().isAssignableFrom(anomalyPropertyValue.getClass())) continue;
            this.labelType = propertyType;
        }
        if (this.labelType == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_CLASS_WEIGHTS_KEY_TYPE", (Object[])new Object[]{anomalyPropertyValue.getClass()}));
        }
    }

    public double getConfidenceMargin() {
        return this.confidenceMargin;
    }

    @JsonIgnore
    public Object getAnomalyPropertyValue() {
        try {
            return this.labelType.parse(this.anomalyPropertyStringValue);
        }
        catch (GmParseException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getAnomalyPropertyStringValue() {
        return this.anomalyPropertyStringValue;
    }

    public PropertyType getLabelType() {
        return this.labelType;
    }
}

