/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal.categorymapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import oracle.pgx.config.internal.categorymapping.CategoryMapSet;

public class CategoryMappingConfig {
    private final CategoryMapSet sharedVertexCategoricalFeatureMaps;
    private final CategoryMapSet sharedEdgeCategoricalFeatureMaps;
    private final List<CategoryMapSet> edgeTypeCategoricalFeatureMaps;
    private final List<CategoryMapSet> vertexTypeCategoricalFeatureMaps;
    protected List<List<String>> orderedVertexTypePropertyNames;
    protected List<List<String>> orderedEdgeTypePropertyNames;
    protected List<List<Integer>> originalVertexTypePropertyIndices;
    protected List<List<Integer>> originalEdgeTypePropertyIndices;

    @JsonCreator
    public CategoryMappingConfig(@JsonProperty(required=true, value="sharedVertexCategoricalFeatureMaps") CategoryMapSet sharedVertexCategoricalFeatureMaps, @JsonProperty(required=true, value="sharedEdgeCategoricalFeatureMaps") CategoryMapSet sharedEdgeCategoricalFeatureMaps, @JsonProperty(required=true, value="vertexTypeCategoricalFeatureMaps") List<CategoryMapSet> vertexTypeCategoricalFeatureMaps, @JsonProperty(required=true, value="edgeTypeCategoricalFeatureMaps") List<CategoryMapSet> edgeTypeCategoricalFeatureMaps, @JsonProperty(required=true, value="orderedVertexTypePropertyNames") List<List<String>> orderedVertexTypePropertyNames, @JsonProperty(required=true, value="orderedEdgeTypePropertyNames") List<List<String>> orderedEdgeTypePropertyNames, @JsonProperty(required=true, value="originalVertexTypePropertyIndices") List<List<Integer>> originalVertexTypePropertyIndices, @JsonProperty(required=true, value="originalEdgeTypePropertyIndices") List<List<Integer>> originalEdgeTypePropertyIndices) {
        this.sharedVertexCategoricalFeatureMaps = sharedVertexCategoricalFeatureMaps;
        this.sharedEdgeCategoricalFeatureMaps = sharedEdgeCategoricalFeatureMaps;
        this.vertexTypeCategoricalFeatureMaps = vertexTypeCategoricalFeatureMaps;
        this.edgeTypeCategoricalFeatureMaps = edgeTypeCategoricalFeatureMaps;
        this.orderedVertexTypePropertyNames = new ArrayList<List<String>>(orderedVertexTypePropertyNames);
        this.orderedEdgeTypePropertyNames = new ArrayList<List<String>>(orderedEdgeTypePropertyNames);
        this.originalVertexTypePropertyIndices = new ArrayList<List<Integer>>(originalVertexTypePropertyIndices);
        this.originalEdgeTypePropertyIndices = new ArrayList<List<Integer>>(originalEdgeTypePropertyIndices);
    }

    public CategoryMappingConfig() {
        this.vertexTypeCategoricalFeatureMaps = new ArrayList<CategoryMapSet>();
        this.edgeTypeCategoricalFeatureMaps = new ArrayList<CategoryMapSet>();
        this.sharedEdgeCategoricalFeatureMaps = new CategoryMapSet();
        this.sharedVertexCategoricalFeatureMaps = new CategoryMapSet();
        this.orderedVertexTypePropertyNames = new ArrayList<List<String>>();
        this.orderedEdgeTypePropertyNames = new ArrayList<List<String>>();
        this.originalVertexTypePropertyIndices = new ArrayList<List<Integer>>();
        this.originalEdgeTypePropertyIndices = new ArrayList<List<Integer>>();
    }

    public List<CategoryMapSet> getEdgeTypeCategoricalFeatureMaps() {
        return this.edgeTypeCategoricalFeatureMaps;
    }

    public List<CategoryMapSet> getVertexTypeCategoricalFeatureMaps() {
        return this.vertexTypeCategoricalFeatureMaps;
    }

    public List<List<String>> getOrderedVertexTypePropertyNames() {
        return this.orderedVertexTypePropertyNames;
    }

    public List<List<String>> getOrderedEdgeTypePropertyNames() {
        return this.orderedEdgeTypePropertyNames;
    }

    public List<List<Integer>> getOriginalVertexTypePropertyIndices() {
        return this.originalVertexTypePropertyIndices;
    }

    public List<List<Integer>> getOriginalEdgeTypePropertyIndices() {
        return this.originalEdgeTypePropertyIndices;
    }

    public CategoryMapSet getSharedEdgeCategoricalFeatureMaps() {
        return this.sharedEdgeCategoricalFeatureMaps;
    }

    public CategoryMapSet getSharedVertexCategoricalFeatureMaps() {
        return this.sharedVertexCategoricalFeatureMaps;
    }

    @JsonIgnore
    public boolean equals(Object o) {
        if (o instanceof CategoryMappingConfig) {
            CategoryMappingConfig otherConfig = (CategoryMappingConfig)o;
            return this.sharedVertexCategoricalFeatureMaps.equals(otherConfig.getSharedVertexCategoricalFeatureMaps()) && this.sharedEdgeCategoricalFeatureMaps.equals(otherConfig.getSharedEdgeCategoricalFeatureMaps()) && this.vertexTypeCategoricalFeatureMaps.equals(otherConfig.getVertexTypeCategoricalFeatureMaps()) && this.edgeTypeCategoricalFeatureMaps.equals(otherConfig.getEdgeTypeCategoricalFeatureMaps()) && this.orderedVertexTypePropertyNames.equals(otherConfig.getOrderedVertexTypePropertyNames()) && this.orderedEdgeTypePropertyNames.equals(otherConfig.getOrderedEdgeTypePropertyNames()) && this.originalVertexTypePropertyIndices.equals(otherConfig.getOriginalVertexTypePropertyIndices()) && this.originalEdgeTypePropertyIndices.equals(otherConfig.getOriginalEdgeTypePropertyIndices());
        }
        return false;
    }
}

