/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.EnterpriseSchedulerFlagsConfig;
import oracle.pgx.config.EnterpriseSchedulerFlagsConfigBuilder;
import oracle.pgx.config.FrontierTypeStrategy;
import oracle.pgx.config.GraphValidationLevel;
import oracle.pgx.config.MemoryAllocationStrategy;
import oracle.pgx.config.RandomGeneratorStrategy;
import oracle.pgx.config.ReachabilityIndexCreationMode;
import oracle.pgx.config.RuntimeConfig;
import oracle.pgx.config.SchedulerStrategy;
import oracle.pgx.config.StringPoolingStrategy;

public final class RuntimeConfigBuilder {
    private final Map<RuntimeConfig.Field, Object> values = new HashMap<RuntimeConfig.Field, Object>();

    public static RuntimeConfig buildRuntimeConfig(Consumer<RuntimeConfigBuilder> builderSetup) {
        RuntimeConfigBuilder builder = new RuntimeConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public RuntimeConfigBuilder() {
    }

    public RuntimeConfigBuilder(Map<RuntimeConfig.Field, Object> values) {
        this.putAll(values);
    }

    public RuntimeConfigBuilder(RuntimeConfig config) {
        this.putAll(config);
    }

    public RuntimeConfigBuilder(RuntimeConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public RuntimeConfigBuilder putAll(Map<RuntimeConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public RuntimeConfigBuilder putAll(RuntimeConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public RuntimeConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public RuntimeConfig build(String parentPath) {
        try {
            return RuntimeConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public RuntimeConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<RuntimeConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "RuntimeConfigBuilder" + this.values;
    }

    public RuntimeConfigBuilder setNumSpinLocks(int numSpinLocks) {
        this.values.put(RuntimeConfig.Field.NUM_SPIN_LOCKS, numSpinLocks);
        return this;
    }

    public RuntimeConfigBuilder setExplicitSpinLocks(boolean explicitSpinLocks) {
        this.values.put(RuntimeConfig.Field.EXPLICIT_SPIN_LOCKS, explicitSpinLocks);
        return this;
    }

    public RuntimeConfigBuilder setScheduler(SchedulerStrategy scheduler) {
        this.values.put(RuntimeConfig.Field.SCHEDULER, scheduler);
        return this;
    }

    public RuntimeConfigBuilder setTaskLength(int taskLength) {
        this.values.put(RuntimeConfig.Field.TASK_LENGTH, taskLength);
        return this;
    }

    public RuntimeConfigBuilder setSmallTaskLength(int smallTaskLength) {
        this.values.put(RuntimeConfig.Field.SMALL_TASK_LENGTH, smallTaskLength);
        return this;
    }

    public RuntimeConfigBuilder setMsBfsFrontierTypeStrategy(FrontierTypeStrategy msBfsFrontierTypeStrategy) {
        this.values.put(RuntimeConfig.Field.MS_BFS_FRONTIER_TYPE_STRATEGY, (Object)msBfsFrontierTypeStrategy);
        return this;
    }

    public RuntimeConfigBuilder setBfsThresholdSingleThreaded(int bfsThresholdSingleThreaded) {
        this.values.put(RuntimeConfig.Field.BFS_THRESHOLD_SINGLE_THREADED, bfsThresholdSingleThreaded);
        return this;
    }

    public RuntimeConfigBuilder setBfsThresholdReadBased(int bfsThresholdReadBased) {
        this.values.put(RuntimeConfig.Field.BFS_THRESHOLD_READ_BASED, bfsThresholdReadBased);
        return this;
    }

    public RuntimeConfigBuilder setBfsIterateQueTaskSize(int bfsIterateQueTaskSize) {
        this.values.put(RuntimeConfig.Field.BFS_ITERATE_QUE_TASK_SIZE, bfsIterateQueTaskSize);
        return this;
    }

    public RuntimeConfigBuilder setBfsThresholdParentReadBased(double bfsThresholdParentReadBased) {
        this.values.put(RuntimeConfig.Field.BFS_THRESHOLD_PARENT_READ_BASED, bfsThresholdParentReadBased);
        return this;
    }

    public RuntimeConfigBuilder setDfsThresholdLarge(int dfsThresholdLarge) {
        this.values.put(RuntimeConfig.Field.DFS_THRESHOLD_LARGE, dfsThresholdLarge);
        return this;
    }

    public RuntimeConfigBuilder setCniStopRecursionDefault(int cniStopRecursionDefault) {
        this.values.put(RuntimeConfig.Field.CNI_STOP_RECURSION_DEFAULT, cniStopRecursionDefault);
        return this;
    }

    public RuntimeConfigBuilder setCniSmallDefault(int cniSmallDefault) {
        this.values.put(RuntimeConfig.Field.CNI_SMALL_DEFAULT, cniSmallDefault);
        return this;
    }

    public RuntimeConfigBuilder setCniDiffFactorDefault(int cniDiffFactorDefault) {
        this.values.put(RuntimeConfig.Field.CNI_DIFF_FACTOR_DEFAULT, cniDiffFactorDefault);
        return this;
    }

    public RuntimeConfigBuilder setLargeArrayThreshold(int largeArrayThreshold) {
        this.values.put(RuntimeConfig.Field.LARGE_ARRAY_THRESHOLD, largeArrayThreshold);
        return this;
    }

    public RuntimeConfigBuilder setMaxOffHeapSize(int maxOffHeapSize) {
        this.values.put(RuntimeConfig.Field.MAX_OFF_HEAP_SIZE, maxOffHeapSize);
        return this;
    }

    public RuntimeConfigBuilder setMaxOnHeapMemoryUsageRatio(double maxOnHeapMemoryUsageRatio) {
        this.values.put(RuntimeConfig.Field.MAX_ON_HEAP_MEMORY_USAGE_RATIO, maxOnHeapMemoryUsageRatio);
        return this;
    }

    public RuntimeConfigBuilder setCharacterSet(String characterSet) {
        this.values.put(RuntimeConfig.Field.CHARACTER_SET, characterSet);
        return this;
    }

    public RuntimeConfigBuilder setParallelism(int parallelism) {
        this.values.put(RuntimeConfig.Field.PARALLELISM, parallelism);
        return this;
    }

    public RuntimeConfigBuilder setRandomGeneratorStrategy(RandomGeneratorStrategy randomGeneratorStrategy) {
        this.values.put(RuntimeConfig.Field.RANDOM_GENERATOR_STRATEGY, (Object)randomGeneratorStrategy);
        return this;
    }

    public RuntimeConfigBuilder setRandomSeed(long randomSeed) {
        this.values.put(RuntimeConfig.Field.RANDOM_SEED, randomSeed);
        return this;
    }

    public RuntimeConfigBuilder setPatternMatchingSupernodeCacheThreshold(int patternMatchingSupernodeCacheThreshold) {
        this.values.put(RuntimeConfig.Field.PATTERN_MATCHING_SUPERNODE_CACHE_THRESHOLD, patternMatchingSupernodeCacheThreshold);
        return this;
    }

    public RuntimeConfigBuilder setUseIndexForReachabilityQueries(ReachabilityIndexCreationMode useIndexForReachabilityQueries) {
        this.values.put(RuntimeConfig.Field.USE_INDEX_FOR_REACHABILITY_QUERIES, (Object)useIndexForReachabilityQueries);
        return this;
    }

    public RuntimeConfigBuilder setRevisitThreshold(int revisitThreshold) {
        this.values.put(RuntimeConfig.Field.REVISIT_THRESHOLD, revisitThreshold);
        return this;
    }

    public RuntimeConfigBuilder setEnterpriseSchedulerFlags(EnterpriseSchedulerFlagsConfig enterpriseSchedulerFlags) {
        this.values.put(RuntimeConfig.Field.ENTERPRISE_SCHEDULER_FLAGS, enterpriseSchedulerFlags);
        return this;
    }

    public RuntimeConfigBuilder setEnterpriseSchedulerFlags(Consumer<EnterpriseSchedulerFlagsConfigBuilder> enterpriseSchedulerFlagsBuilderSetup) {
        EnterpriseSchedulerFlagsConfigBuilder builder = new EnterpriseSchedulerFlagsConfigBuilder();
        enterpriseSchedulerFlagsBuilderSetup.accept(builder);
        this.setEnterpriseSchedulerFlags(builder.build());
        return this;
    }

    public RuntimeConfigBuilder setMemoryAllocator(MemoryAllocationStrategy memoryAllocator) {
        this.values.put(RuntimeConfig.Field.MEMORY_ALLOCATOR, (Object)memoryAllocator);
        return this;
    }

    public RuntimeConfigBuilder setMaxDistinctStringsPerPool(int maxDistinctStringsPerPool) {
        this.values.put(RuntimeConfig.Field.MAX_DISTINCT_STRINGS_PER_POOL, maxDistinctStringsPerPool);
        return this;
    }

    public RuntimeConfigBuilder setStringPoolingStrategy(StringPoolingStrategy stringPoolingStrategy) {
        this.values.put(RuntimeConfig.Field.STRING_POOLING_STRATEGY, (Object)stringPoolingStrategy);
        return this;
    }

    public RuntimeConfigBuilder setUseMemoryMapperForStoringPgb(boolean useMemoryMapperForStoringPgb) {
        this.values.put(RuntimeConfig.Field.USE_MEMORY_MAPPER_FOR_STORING_PGB, useMemoryMapperForStoringPgb);
        return this;
    }

    public RuntimeConfigBuilder setUseMemoryMapperForReadingPgb(boolean useMemoryMapperForReadingPgb) {
        this.values.put(RuntimeConfig.Field.USE_MEMORY_MAPPER_FOR_READING_PGB, useMemoryMapperForReadingPgb);
        return this;
    }

    public RuntimeConfigBuilder setPoolingFactor(double poolingFactor) {
        this.values.put(RuntimeConfig.Field.POOLING_FACTOR, poolingFactor);
        return this;
    }

    public RuntimeConfigBuilder setGraphValidationLevel(GraphValidationLevel graphValidationLevel) {
        this.values.put(RuntimeConfig.Field.GRAPH_VALIDATION_LEVEL, (Object)graphValidationLevel);
        return this;
    }

    public RuntimeConfigBuilder setAllowLazyLoadingForDatabaseGraphs(boolean allowLazyLoadingForDatabaseGraphs) {
        this.values.put(RuntimeConfig.Field.ALLOW_LAZY_LOADING_FOR_DATABASE_GRAPHS, allowLazyLoadingForDatabaseGraphs);
        return this;
    }
}

