/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.MemoryAllocationStrategy;
import oracle.pgx.config.RuntimeConfig;
import oracle.pgx.config.SchedulerStrategy;
import oracle.pgx.config.StringPoolingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuntimeConfig
extends AbstractConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRuntimeConfig.class);

    public static RuntimeConfig getInstance() {
        LOG.info("initializing runtime with system properties (if any)");
        Map<RuntimeConfig.Field, Object> map = AbstractRuntimeConfig.extractSystemProperties();
        return AbstractRuntimeConfig.getInstance(map);
    }

    private static Map<RuntimeConfig.Field, Object> extractSystemProperties() {
        return AbstractRuntimeConfig.readConfigFromEnvironment(null, null, (ConfigField[])RuntimeConfig.getConfigFields()).entrySet().stream().collect(Collectors.toMap(e -> RuntimeConfig.Field.valueOf(((String)e.getKey()).toUpperCase()), Map.Entry::getValue));
    }

    public static RuntimeConfig getInstance(Map<RuntimeConfig.Field, Object> values) {
        RuntimeConfig runtimeConfig;
        block8: {
            InputStream is = ConfigJsonUtil.toJsonInputStream(values);
            try {
                runtimeConfig = AbstractRuntimeConfig.getInstance(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
            is.close();
        }
        return runtimeConfig;
    }

    public static RuntimeConfig getInstance(InputStream is) throws IOException {
        return RuntimeConfig.parse(is, true, null);
    }

    public boolean areWeEnterprise() {
        return this.getScheduler() == SchedulerStrategy.ENTERPRISE_SCHEDULER || this.getMemoryAllocator() == MemoryAllocationStrategy.ENTERPRISE_ALLOCATOR;
    }

    public static void reset() {
    }

    public abstract Map<RuntimeConfig.Field, Object> getValues();

    @JsonValue
    public abstract Map<RuntimeConfig.Field, Object> getValuesWithoutDefaults();

    public abstract MemoryAllocationStrategy getMemoryAllocator();

    public abstract SchedulerStrategy getScheduler();

    public abstract StringPoolingStrategy getStringPoolingStrategy();

    public boolean isStringPoolEnabled() {
        return this.getStringPoolingStrategy() != StringPoolingStrategy.NONE;
    }

    @Override
    public void validate() {
        super.validate();
        this.validateMaxOnHeapRatioConfig();
    }

    private void validateMaxOnHeapRatioConfig() {
        double maxOnHeapMemoryUsageRatio = (Double)this.getValues().get(RuntimeConfig.Field.MAX_ON_HEAP_MEMORY_USAGE_RATIO);
        if (maxOnHeapMemoryUsageRatio > 1.0 || maxOnHeapMemoryUsageRatio < 0.0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_MAX_ON_HEAP_MEMORY_USAGE_RATIO", (Object[])new Object[0]));
        }
    }
}

