/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.List;
import java.util.Objects;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.keys.ForeignKeyColumnDescriptor;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.NameValidator;
import oracle.pgx.config.AbstractPartitionedGraphConfig;
import oracle.pgx.config.DbConnectionConfig;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import oracle.pgx.config.RdbmsEntityProviderConfigBuilder;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.internal.LegacyConfigUtils;

public abstract class AbstractRdbmsEntityProviderConfig
extends EntityProviderConfig
implements DbConnectionConfig {
    @Override
    public RdbmsEntityProviderConfigBuilder toEntityProviderConfigBuilder() {
        return new RdbmsEntityProviderConfigBuilder().copyFrom((RdbmsEntityProviderConfig)this);
    }

    public abstract boolean hasDefaultValue(RdbmsEntityProviderConfig.Field var1);

    public abstract String getKeyColumn();

    public abstract String getSourceColumn();

    public abstract String getDestinationColumn();

    @BetaApi
    public abstract List<? extends ForeignKeyColumnDescriptor> getSourceKeyColumns();

    @BetaApi
    public List<? extends ForeignKeyColumnDescriptor> getValidatedSourceKeyColumns() {
        return LegacyConfigUtils.extractForeignKeyColumnsFromFields(this, RdbmsEntityProviderConfig.Field.SOURCE_COLUMN, RdbmsEntityProviderConfig.Field.SOURCE_KEY_COLUMNS, this.getSourceKeyColumns());
    }

    @BetaApi
    public abstract List<? extends ForeignKeyColumnDescriptor> getDestinationKeyColumns();

    @BetaApi
    public List<? extends ForeignKeyColumnDescriptor> getValidatedDestinationKeyColumns() {
        return LegacyConfigUtils.extractForeignKeyColumnsFromFields(this, RdbmsEntityProviderConfig.Field.DESTINATION_COLUMN, RdbmsEntityProviderConfig.Field.DESTINATION_KEY_COLUMNS, this.getDestinationKeyColumns());
    }

    @Override
    public boolean supportsVectorProperties() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRdbmsEntityProviderConfig that = (AbstractRdbmsEntityProviderConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.getJdbcUrl(), that.getJdbcUrl())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), that.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getKeystoreAlias(), that.getKeystoreAlias())) {
            return false;
        }
        if (!Objects.equals(this.getLoadedDatabaseTableName(), that.getLoadedDatabaseTableName())) {
            return false;
        }
        if (!Objects.equals(this.hasKeys(), that.hasKeys())) {
            return false;
        }
        if (this.hasKeys().booleanValue() && !Objects.equals(this.getValidatedKeyColumns(), that.getValidatedKeyColumns())) {
            return false;
        }
        if (this.hasKeys().booleanValue() && !Objects.equals(this.getKeyColumn(), that.getKeyColumn())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedDestinationKeyColumns(), that.getValidatedDestinationKeyColumns())) {
            return false;
        }
        return Objects.equals(this.getValidatedSourceKeyColumns(), that.getValidatedSourceKeyColumns());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.getJdbcUrl() != null) {
            hash += this.getJdbcUrl().hashCode();
        }
        if (this.getUsername() != null) {
            hash += this.getUsername().hashCode();
        }
        if (this.getKeystoreAlias() != null) {
            hash += this.getKeystoreAlias().hashCode();
        }
        hash += this.getLoadedDatabaseTableName().hashCode();
        if (this.hasKeys().booleanValue() && this.getKeyColumn() != null) {
            hash += this.getKeyColumn().hashCode();
        }
        if (this.hasKeys().booleanValue() && this.getValidatedKeyColumns() != null) {
            hash += this.getValidatedKeyColumns().hashCode();
        }
        if (this.getDestinationColumn() != null) {
            hash += this.getDestinationColumn().hashCode();
        }
        if (this.getValidatedDestinationKeyColumns() != null) {
            hash += this.getValidatedDestinationKeyColumns().hashCode();
        }
        if (this.getSourceColumn() != null) {
            hash += this.getSourceColumn().hashCode();
        }
        if (this.getValidatedSourceKeyColumns() != null) {
            hash += this.getValidatedSourceKeyColumns().hashCode();
        }
        return hash;
    }

    @Override
    protected void validate() {
        super.validate();
        List<? extends ForeignKeyColumnDescriptor> sourceKeyColumns = this.getValidatedSourceKeyColumns();
        List<? extends ForeignKeyColumnDescriptor> destinationKeyColumns = this.getValidatedDestinationKeyColumns();
        String tableName = this.getLoadedDatabaseTableName();
        if (tableName == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"TABLE_NAMES_NOT_SET", (Object[])new Object[0]));
        }
        NameValidator.validate((String[])new String[]{tableName});
        NameValidator.validate((String[])new String[]{this.getKeyColumn()});
        for (GraphPropertyConfig prop : this.getProps()) {
            NameValidator.validate((String[])new String[]{prop.getName()});
        }
    }

    @Override
    protected void validate(AbstractPartitionedGraphConfig graphConfig) {
        this.validate();
        String dataSourceId = this.getDataSourceId(graphConfig);
        String jdbcUrl = this.getJdbcUrl(graphConfig);
        String username = this.getUsername(graphConfig);
        String keystoreAlias = this.getKeystoreAlias(graphConfig);
        this.validateDatabaseConnectionSettings(dataSourceId, jdbcUrl, username, keystoreAlias);
        if (ConfigUtils.isEdgeProviderInConfig(this, graphConfig)) {
            ConfigUtils.validateForeignKey(graphConfig, this.getName(), this.getSourceVertexProvider(), this.getValidatedSourceKeyColumns(), false);
            ConfigUtils.validateForeignKey(graphConfig, this.getName(), this.getDestinationVertexProvider(), this.getValidatedDestinationKeyColumns(), true);
        }
    }

    private void validateDatabaseConnectionSettings(String dataSourceId, String jdbcUrl, String username, String keystoreAlias) {
        if (dataSourceId != null && (jdbcUrl != null || username != null || keystoreAlias != null)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"DATA_SOURCE_ID_CANNOT_BE_COMBINED_WITH_JDBC", (Object[])new Object[]{RdbmsEntityProviderConfig.Field.DATA_SOURCE_ID.toKey(), RdbmsEntityProviderConfig.Field.JDBC_URL.toKey(), RdbmsEntityProviderConfig.Field.USERNAME.toKey(), RdbmsEntityProviderConfig.Field.KEYSTORE_ALIAS.toKey()}));
        }
    }

    @Override
    public abstract String getKeystoreAlias();

    public abstract String getDatabaseTableName();

    public abstract Integer getNumConnections();

    public String getLoadedDatabaseTableName() {
        String name = this.getDatabaseTableName();
        return name != null ? name : this.getName();
    }

    public String getDataSourceId(AbstractPartitionedGraphConfig graphConfig) {
        if (graphConfig == null) {
            return this.getDataSourceId();
        }
        return this.hasDefaultValue(RdbmsEntityProviderConfig.Field.DATA_SOURCE_ID) ? graphConfig.getDataSourceId() : this.getDataSourceId();
    }

    public String getJdbcUrl(AbstractPartitionedGraphConfig graphConfig) {
        if (graphConfig == null) {
            return this.getJdbcUrl();
        }
        return this.hasDefaultValue(RdbmsEntityProviderConfig.Field.JDBC_URL) ? graphConfig.getJdbcUrl() : this.getJdbcUrl();
    }

    public String getUsername(AbstractPartitionedGraphConfig graphConfig) {
        if (graphConfig == null) {
            return this.getUsername();
        }
        return this.hasDefaultValue(RdbmsEntityProviderConfig.Field.USERNAME) ? graphConfig.getUsername() : this.getUsername();
    }

    public String getKeystoreAlias(AbstractPartitionedGraphConfig graphConfig) {
        if (graphConfig == null) {
            return this.getKeystoreAlias();
        }
        return this.hasDefaultValue(RdbmsEntityProviderConfig.Field.KEYSTORE_ALIAS) ? graphConfig.getKeystoreAlias() : this.getKeystoreAlias();
    }

    public String getSchema(AbstractPartitionedGraphConfig graphConfig) {
        if (graphConfig == null) {
            return this.getSchema();
        }
        return this.hasDefaultValue(RdbmsEntityProviderConfig.Field.SCHEMA) ? graphConfig.getSchema() : this.getSchema();
    }

    public Integer getMaxPrefetchedRows(AbstractPartitionedGraphConfig graphConfig) {
        if (graphConfig == null) {
            return this.getMaxPrefetchedRows();
        }
        return this.hasDefaultValue(RdbmsEntityProviderConfig.Field.MAX_PREFETCHED_ROWS) ? graphConfig.getMaxPrefetchedRows() : this.getMaxPrefetchedRows();
    }

    public Integer getNumConnections(AbstractPartitionedGraphConfig graphConfig) {
        if (graphConfig == null || !this.hasDefaultValue(RdbmsEntityProviderConfig.Field.NUM_CONNECTIONS)) {
            return this.getNumConnections();
        }
        return graphConfig.getNumConnections();
    }

    public Integer getNumConnections(AbstractPartitionedGraphConfig graphConfig, int machineCount, int defaultNumConnectionsTotal) {
        if (graphConfig != null && graphConfig.isCompKeyPresent() && graphConfig.getQueries() != null && !graphConfig.getQueries().isEmpty()) {
            LOG.warn("Loading Subgraphs with Composite keys is not supported with multiple connections,defaulting to a single connection.");
            return 1;
        }
        if (!this.hasDefaultValue(RdbmsEntityProviderConfig.Field.NUM_CONNECTIONS)) {
            return Math.max(this.getNumConnections(), machineCount);
        }
        if (graphConfig == null) {
            return defaultNumConnectionsTotal;
        }
        return graphConfig.getNumConnections(machineCount, defaultNumConnectionsTotal);
    }
}

