/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.keys.ForeignKeyColumnDescriptor;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.FileUtils;
import oracle.pgx.config.AbstractPartitionedGraphConfig;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfigBuilder;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.internal.LegacyConfigUtils;
import org.apache.commons.vfs2.provider.UriParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileEntityProviderConfig
extends EntityProviderConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileEntityProviderConfig.class);

    public abstract List<String> getUris();

    @Deprecated
    public abstract FileGraphStoringConfig getStoring();

    public FileGraphStoringConfig getStoringOptions() {
        return this.getStoring();
    }

    @Override
    public abstract Map getAttributes();

    public abstract String getSeparator();

    public abstract Boolean isDetectGzip();

    public abstract Boolean isHeader();

    public abstract Object getKeyColumn();

    public abstract Object getSourceColumn();

    @BetaApi
    public abstract List<? extends ForeignKeyColumnDescriptor> getSourceKeyColumns();

    @BetaApi
    public List<? extends ForeignKeyColumnDescriptor> getValidatedSourceKeyColumns() {
        return LegacyConfigUtils.extractForeignKeyColumnsFromFields(this, FileEntityProviderConfig.Field.SOURCE_COLUMN, FileEntityProviderConfig.Field.SOURCE_KEY_COLUMNS, this.getSourceKeyColumns());
    }

    public abstract Object getDestinationColumn();

    @BetaApi
    public abstract List<? extends ForeignKeyColumnDescriptor> getDestinationKeyColumns();

    @BetaApi
    public List<? extends ForeignKeyColumnDescriptor> getValidatedDestinationKeyColumns() {
        return LegacyConfigUtils.extractForeignKeyColumnsFromFields(this, FileEntityProviderConfig.Field.DESTINATION_COLUMN, FileEntityProviderConfig.Field.DESTINATION_KEY_COLUMNS, this.getDestinationKeyColumns());
    }

    @Override
    public FileEntityProviderConfigBuilder toEntityProviderConfigBuilder() {
        return new FileEntityProviderConfigBuilder().copyFrom((FileEntityProviderConfig)this);
    }

    @Override
    public String getName() {
        String uri = this.getUris().get(0);
        if (uri.startsWith("jdbc:oracle:thin:")) {
            return this.getAttributes().getOrDefault("table_name", "table");
        }
        return FileUtils.getBaseName((String)uri);
    }

    @Override
    protected void validate() {
        super.validate();
        List<? extends ForeignKeyColumnDescriptor> ignored1 = this.getValidatedSourceKeyColumns();
        List<? extends ForeignKeyColumnDescriptor> ignored2 = this.getValidatedDestinationKeyColumns();
        this.validateIsFileFormat();
        this.validateHasSeparator();
        this.validateUriList();
        this.validateVectorComponentDelimiter();
        if (this.getFormat() == ProviderFormat.CSV || this.getFormat() == ProviderFormat.PGB) {
            this.validateColumns();
        } else {
            this.validateColumnsAreNull();
        }
        this.validateHasKeysIfRequired();
    }

    @Override
    protected void validate(AbstractPartitionedGraphConfig graphConfig) {
        this.validate();
        if (ConfigUtils.isEdgeProviderInConfig(this, graphConfig)) {
            List<? extends ForeignKeyColumnDescriptor> sourceKeyColumns = this.getValidatedSourceKeyColumns();
            if (sourceKeyColumns.isEmpty()) {
                LOG.debug("No source key columns defined for {}", (Object)this.getName());
            } else {
                ConfigUtils.validateForeignKey(graphConfig, this.getName(), this.getSourceVertexProvider(), sourceKeyColumns, false);
            }
            List<? extends ForeignKeyColumnDescriptor> destinationKeyColumns = this.getValidatedDestinationKeyColumns();
            if (destinationKeyColumns.isEmpty()) {
                LOG.debug("No destination key columns defined for {}", (Object)this.getName());
            } else {
                ConfigUtils.validateForeignKey(graphConfig, this.getName(), this.getDestinationVertexProvider(), destinationKeyColumns, true);
            }
        }
    }

    private void validateIsFileFormat() {
        if (!((ProviderFormat)((Object)this.getFormat())).isFileFormat()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_FILE_FORMAT", (Object[])new Object[]{this.getFormat()}));
        }
    }

    private boolean formatRequiresSeparator() {
        return this.getFormat() != ProviderFormat.PGB;
    }

    private final void validateHasKeysIfRequired() {
    }

    private void validateHasSeparator() {
        if (this.formatRequiresSeparator() && this.getSeparator() != null && this.getSeparator().isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{FileEntityProviderConfig.Field.SEPARATOR.toKey()}));
        }
    }

    private void validateUriList() {
        if (this.isEmptyList(this.getUris())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{FileEntityProviderConfig.Field.URIS.toKey()}));
        }
    }

    private void validateVectorComponentDelimiter() {
        String separator = this.getSeparator();
        if (separator == null) {
            separator = this.getFormat() == ProviderFormat.CSV ? "," : "\t ";
        }
        ConfigUtils.validateVectorComponentDelimiter(this.formatRequiresSeparator(), separator, this.getVectorComponentDelimiter());
    }

    private void validateColumns() {
        List<? extends ForeignKeyColumnDescriptor> destinationKeyColumns;
        List<? extends ForeignKeyColumnDescriptor> sourceKeyColumns;
        if (this.getKeyColumn() != null) {
            this.validateColumn(this.getKeyColumn(), "key column");
        }
        List<? extends KeyColumnDescriptor> keyColumns = this.getKeyColumns();
        for (int keyNr = 0; keyNr < keyColumns.size(); ++keyNr) {
            this.validateColumn(keyColumns.get(keyNr).getName(), "key column #" + keyNr);
        }
        if (this.getSourceColumn() != null) {
            this.validateColumn(this.getSourceColumn(), "source");
        }
        if ((sourceKeyColumns = this.getSourceKeyColumns()) != null) {
            for (int skeyNr = 0; skeyNr < sourceKeyColumns.size(); ++skeyNr) {
                this.validateColumn(sourceKeyColumns.get(skeyNr).getName(), "source key column #" + skeyNr);
            }
        }
        if (this.getDestinationColumn() != null) {
            this.validateColumn(this.getDestinationColumn(), "destination");
        }
        if ((destinationKeyColumns = this.getDestinationKeyColumns()) != null) {
            for (int dkeyNr = 0; dkeyNr < destinationKeyColumns.size(); ++dkeyNr) {
                this.validateColumn(destinationKeyColumns.get(dkeyNr).getName(), "destination key column #" + dkeyNr);
            }
        }
        for (GraphPropertyConfig prop : this.getProps()) {
            if (prop.getColumn() == null) continue;
            this.validateColumn(prop.getColumn(), "property \"" + prop.getName() + "\"");
        }
        if (!this.isHeader().booleanValue()) {
            this.validateNoneOrAllColumnIndices();
        }
    }

    private void validateColumn(Object column, String errorMsg) {
        if (column == null && this.isHeader().booleanValue()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CSV_UNSPECIFIED_COLUMN", (Object[])new Object[]{errorMsg, this.getName()}));
        }
        if (!this.isHeader().booleanValue() && column != null) {
            try {
                int columnIndex = Integer.parseInt(column.toString());
                if (columnIndex < 1) {
                    throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CSV_INVALID_COLUMN_INDEX", (Object[])new Object[]{columnIndex}));
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CSV_COLUMN_NAME_WITHOUT_HEADER", (Object[])new Object[]{errorMsg, this.getName()}), e);
            }
        }
    }

    private void validateNoneOrAllColumnIndices() {
        boolean isRowTable;
        boolean isEdgeTable = this.getSourceVertexProvider() != null && this.getDestinationVertexProvider() != null;
        boolean isVertexProvider = !isEdgeTable && this.hasKeys() != false;
        boolean bl = isRowTable = !isEdgeTable && !isVertexProvider;
        boolean firstColumnIsPresent = isEdgeTable ? this.getSourceColumn() != null : (isVertexProvider ? this.getKeyColumn() != null : this.getProps().stream().findFirst().map(prop -> Objects.nonNull(prop.getColumn())).orElse(false));
        if (isEdgeTable && (this.isKeyMappingEnabled() && this.getKeyColumn() != null != firstColumnIsPresent || this.getDestinationColumn() != null != firstColumnIsPresent) || this.getProps().stream().anyMatch(prop -> prop.getColumn() != null != firstColumnIsPresent)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CSV_PARTIAL_COLUMN_INDICES", (Object[])new Object[]{"graph"}));
        }
    }

    private void validateColumnsAreNull() {
        this.checkColumnIsNull(this.getKeyColumn(), "key");
        this.checkColumnIsNull(this.getSourceColumn(), "source");
        this.checkColumnIsNull(this.getDestinationColumn(), "destination");
        for (GraphPropertyConfig prop : this.getProps()) {
            this.checkColumnIsNull(prop.getColumn(), "property \"" + prop.getName() + "\"");
        }
    }

    private void checkColumnIsNull(Object column, String errorMsg) {
        if (column != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"COLUMNS_NOT_SUPPORTED_FOR_FORMAT", (Object[])new Object[]{errorMsg, this.getName()}));
        }
    }

    private boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileEntityProviderConfig that = (AbstractFileEntityProviderConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.isHeader(), that.isHeader())) {
            return false;
        }
        if (!Objects.equals(this.getSeparator(), that.getSeparator())) {
            return false;
        }
        if (!Objects.equals(this.getAttributes(), that.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.getStoring(), that.getStoring())) {
            return false;
        }
        if (!Objects.equals(this.isDetectGzip(), that.isDetectGzip())) {
            return false;
        }
        if (!Objects.equals(AbstractFileEntityProviderConfig.addSchemeIfNotPresent(this.getUris()), AbstractFileEntityProviderConfig.addSchemeIfNotPresent(that.getUris()))) {
            return false;
        }
        if (!Objects.equals(this.getKeyColumn(), that.getKeyColumn())) {
            return false;
        }
        if (!Objects.equals(this.getSourceColumn(), that.getSourceColumn())) {
            return false;
        }
        return Objects.equals(this.getDestinationColumn(), that.getDestinationColumn());
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code += this.isHeader().hashCode();
        code += this.getSeparator() == null ? 0 : this.getSeparator().hashCode();
        code += this.getAttributes().hashCode();
        code += this.getStoring().hashCode();
        code += this.isDetectGzip().hashCode();
        code += AbstractFileEntityProviderConfig.addSchemeIfNotPresent(this.getUris()).hashCode();
        code += this.getKeyColumn() == null ? 0 : this.getKeyColumn().hashCode();
        code += this.getSourceColumn() == null ? 0 : this.getSourceColumn().hashCode();
        return code += this.getDestinationColumn() == null ? 0 : this.getDestinationColumn().hashCode();
    }

    protected List<String> getUrisWithScheme() {
        return AbstractFileEntityProviderConfig.addSchemeIfNotPresent(this.getUris());
    }

    protected static List<String> addSchemeIfNotPresent(List<String> uriList) {
        ArrayList<String> list = new ArrayList<String>(uriList.size());
        for (String uri : uriList) {
            list.add(AbstractFileEntityProviderConfig.addSchemeIfNotPresent(uri));
        }
        return list;
    }

    protected static String addSchemeIfNotPresent(String uri) {
        return UriParser.extractScheme((String)uri) == null ? "file://" + uri : uri;
    }
}

