/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import oracle.pgx.common.UserContext;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigMetaFactory;
import oracle.pgx.vfs.ClasspathVirtualFileProvider;
import oracle.pgx.vfs.VirtualFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig {
    public static final String SYSTEM_PROPERTY_PREFIX = "pgx.";
    public static final String ENV_VARIABLE_PREFIX = "PGX_";
    public static final String ENV_SEPARATOR = "__";
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractConfig.class);
    private boolean serializable = true;

    static <F extends ConfigField> Map<String, Object> readConfigFromEnvironment(String parent, String prefix, F[] fields) {
        HashMap<String, Object> rawValues = new HashMap<String, Object>();
        for (Object field : fields) {
            String fieldEnvKey = AbstractConfig.getFieldEnvKey(prefix, field);
            AbstractConfig.tryParseEnvironment(fieldEnvKey, parent, field).ifPresent(v -> rawValues.put(field.toKey(), v));
        }
        return rawValues;
    }

    private static Optional<? extends Object> tryParseEnvironment(String key, String parent, ConfigField field) {
        Class<?> type = field.getType();
        if (AbstractConfig.class.isAssignableFrom(type)) {
            LOG.trace("try parsing config {} with prefix {}", type, (Object)key);
            Class<?> configType = type;
            AbstractConfig parsedConfig = AbstractConfig.readConfigFromSystemProperties(configType, parent, key);
            return Optional.ofNullable(parsedConfig);
        }
        if (Map.class.isAssignableFrom(type) && !field.isArray()) {
            Map<?, ?> value2 = AbstractConfig.readRawMapFromEnvironment(key);
            if (value2.size() > 0) {
                LOG.debug("parsed '{}' for field '{}' from environment '{}'", new Object[]{value2, field, key});
                return Optional.of(value2);
            }
            return Optional.empty();
        }
        Optional<Object> valueFromEnvironment = AbstractConfig.getValueFromEnvironment(key, type).map(value -> {
            if (field.isArray()) {
                return Collections.singletonList(value);
            }
            return value;
        });
        valueFromEnvironment.ifPresent(value -> LOG.debug("parsed '{}' for field '{}' from environment '{}'", new Object[]{value, field, key}));
        return valueFromEnvironment;
    }

    private static Map<?, ?> readRawMapFromEnvironment(String key) {
        String prefix = key + ENV_SEPARATOR;
        Properties systemProperties = (Properties)System.getProperties().clone();
        Map<?, ?> propertyValues = AbstractConfig.extractPrefixedKeys(SYSTEM_PROPERTY_PREFIX + prefix, systemProperties);
        Map<?, ?> environmentValues = AbstractConfig.extractPrefixedKeys(ENV_VARIABLE_PREFIX + prefix.toUpperCase(), System.getenv(), String::toLowerCase);
        HashMap result = new HashMap();
        result.putAll(environmentValues);
        result.putAll(propertyValues);
        return result;
    }

    private static Map<?, ?> extractPrefixedKeys(String prefix, Map<?, ?> source) {
        return AbstractConfig.extractPrefixedKeys(prefix, source, UnaryOperator.identity());
    }

    private static Map<?, ?> extractPrefixedKeys(String prefix, Map<?, ?> source, UnaryOperator<String> keyTransformator) {
        return source.entrySet().stream().filter(propKey -> propKey.toString().startsWith(prefix)).collect(Collectors.toMap(entry -> {
            String key = entry.getKey().toString().substring(prefix.length());
            return (String)keyTransformator.apply(key);
        }, Map.Entry::getValue));
    }

    private static <F extends ConfigField> String getFieldEnvKey(String prefix, F field) {
        String key = field.toKey();
        if (prefix == null) {
            return key;
        }
        return prefix + ENV_SEPARATOR + key;
    }

    private static AbstractConfig readConfigFromSystemProperties(Class<? extends AbstractConfig> type, String parent, String prefix) {
        ConfigMetaFactory configMetaFactory = ConfigMetaFactory.getForClass(type);
        ConfigField[] configFields = configMetaFactory.getConfigFields();
        Map raw = AbstractConfig.readConfigFromEnvironment((String)parent, (String)prefix, (ConfigField[])configFields);
        if (raw.isEmpty()) {
            return null;
        }
        return configMetaFactory.parse(raw, true, parent);
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    protected void initialize() {
        this.validate();
    }

    protected void validate() {
    }

    protected boolean canSerialize() {
        return this.serializable;
    }

    public abstract Map<? extends ConfigField, Object> getValues();

    public static Object parseString(String value, Class type) {
        if (type == String.class || type == Object.class) {
            return value;
        }
        if (type == Integer.class) {
            return Integer.valueOf(value);
        }
        if (type == Long.class) {
            return Long.valueOf(value);
        }
        if (type == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (type == Double.class) {
            return Double.valueOf(value);
        }
        if (type == Float.class) {
            return Float.valueOf(value);
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value.toUpperCase());
        }
        throw new IllegalArgumentException("cannot parse field type " + type);
    }

    public static Object getDefault(String schemaName, ConfigField field, Object factoryDefault) {
        Object defaultVal;
        block10: {
            defaultVal = factoryDefault;
            ClasspathVirtualFileProvider vfp = new ClasspathVirtualFileProvider();
            try {
                String path = "/META-INF/pgx/" + schemaName + ".defaults.properties";
                VirtualFile vf = vfp.resolve(path, Collections.emptyMap(), UserContext.UNAUTHENTICATED_USER_CONTEXT);
                if (!vf.exists()) break block10;
                try (InputStream is = vf.getInputStream();){
                    Properties props = new Properties();
                    props.load(is);
                    String value = props.getProperty(field.toKey());
                    if (value != null) {
                        defaultVal = AbstractConfig.parseString(value, field.getType());
                    }
                }
            }
            catch (IOException e) {
                LOG.debug("error when reading overlay", (Throwable)e);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("default value of {}:{} = {}", new Object[]{schemaName, field.toKey(), defaultVal});
        }
        return defaultVal;
    }

    public static String getValueFromEnvironment(String key) {
        String propertyValue = System.getProperty(SYSTEM_PROPERTY_PREFIX + key);
        if (propertyValue != null) {
            return propertyValue;
        }
        String environmentValue = System.getenv(ENV_VARIABLE_PREFIX + key.toUpperCase());
        if (environmentValue != null) {
            return environmentValue;
        }
        return null;
    }

    public static <T> Optional<T> getValueFromEnvironment(String key, Class<T> type) {
        return Optional.ofNullable(AbstractConfig.getValueFromEnvironment(key)).map(string -> AbstractConfig.parseString(string, type)).map(type::cast);
    }

    static Map<String, Object> constructMap(Object ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("uneven number of key value pairs");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Object keyObject = keyValuePairs[i];
            Objects.requireNonNull(keyObject, "null keys are not allowed");
            String key = keyObject.toString();
            Object value = keyValuePairs[i + 1];
            if (result.containsKey(key)) {
                throw new IllegalArgumentException("duplicate key defined: " + key);
            }
            result.put(key, value);
        }
        return Collections.unmodifiableMap(result);
    }
}

