/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.TwoTablesRdbmsGraphConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphConfigModule
extends SimpleModule {
    private static final Logger LOG = LoggerFactory.getLogger(GraphConfigModule.class);
    private static final String VERTEX_ID_TYPE_KEY = TwoTablesRdbmsGraphConfig.Field.VERTEX_ID_TYPE.toKey();
    private static final ObjectMapper OBJECT_MAPPER = ConfigJsonUtil.createObjectMapper();

    GraphConfigModule() {
        super("GraphConfigModule", Version.unknownVersion());
        this.addSerializer(new GraphConfigSerializer());
    }

    private static class GraphConfigSerializer
    extends JsonSerializer<GraphConfig> {
        private GraphConfigSerializer() {
        }

        public void serialize(GraphConfig graphConfig, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            JsonNode jsonNode = OBJECT_MAPPER.valueToTree((Object)graphConfig);
            jgen.writeTree((TreeNode)jsonNode);
        }

        public Class<GraphConfig> handledType() {
            return GraphConfig.class;
        }
    }
}

