/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import oracle.pgql.lang.CheckInvalidJavaComment;
import oracle.pgql.lang.MetadataToAstUtil;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlResult;
import oracle.pgql.lang.PgqlVersion;
import oracle.pgql.lang.SpoofaxAstToGraphQuery;
import oracle.pgql.lang.completion.PgqlCompletionGenerator;
import oracle.pgql.lang.editor.completion.PgqlCompletion;
import oracle.pgql.lang.editor.completion.PgqlCompletionContext;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgql.lang.metadata.AbstractMetadataProvider;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.parsetable.ParseTableReadException;
import org.metaborg.parsetable.ParseTableVariant;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.ImploderOriginTermFactory;
import org.spoofax.jsglr2.JSGLR2Failure;
import org.spoofax.jsglr2.JSGLR2Implementation;
import org.spoofax.jsglr2.JSGLR2Result;
import org.spoofax.jsglr2.JSGLR2Success;
import org.spoofax.jsglr2.JSGLR2Variant;
import org.spoofax.jsglr2.imploder.ImploderVariant;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.ParseForestConstruction;
import org.spoofax.jsglr2.parseforest.ParseForestRepresentation;
import org.spoofax.jsglr2.parser.ParserVariant;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.reducing.Reducing;
import org.spoofax.jsglr2.stack.StackRepresentation;
import org.spoofax.jsglr2.stack.collections.ActiveStacksRepresentation;
import org.spoofax.jsglr2.stack.collections.ForActorStacksRepresentation;
import org.spoofax.jsglr2.tokens.TokenizerVariant;
import org.spoofax.terms.TermFactory;
import org.strategoxt.lang.Context;
import pgqllang.trans.get_errors_and_offsets_0_0;
import pgqllang.trans.pgql_trans_0_0;
import pgqllang.trans.trans;

public class Pgql
implements Closeable {
    public static final String NON_BREAKING_WHITE_SPACE_ERROR = "Illegal character '\u00a0' (non-breaking white space); use a normal space instead";
    private static final String NON_BREAKING_WHITE_SPACE = "\u00a0";
    private static final String ERROR_MESSSAGE_INDENTATION = "  ";
    private static final int POS_QUERY_ANNOTATIONS = 9;
    private static final int POS_PGQL_VERSION = 1;
    private static final int POS_BIND_VARIABLE_COUNT = 2;
    private static final int POS_SELECTING_ALL_PROPERTIES = 3;
    private static final PgqlVersion LATEST_VERSION = PgqlVersion.V_1_3_OR_UP;
    private static final String ALLOW_REFERENCING_ANY_PROPERTY_FLAG = "/*ALLOW_REFERENCING_ANY_PROPERTY*/";
    private final JSGLR2Implementation<IParseForest, ?, ?, IStrategoTerm, ?, ?> jsglr2;
    private boolean closed = false;

    public Pgql() throws PgqlException {
        try {
            this.jsglr2 = this.getParser(this.getParseTable());
        }
        catch (IOException | ParseTableReadException e) {
            throw new PgqlException(e);
        }
        this.parse("SELECT 'dummy' FROM MATCH (n)");
    }

    public PgqlResult parse(String queryString) throws PgqlException {
        return this.parse(queryString, null);
    }

    public PgqlResult parse(String queryString, AbstractMetadataProvider metadataProvider) throws PgqlException {
        if (this.closed) {
            throw new PgqlException("Pgql instance was closed");
        }
        if (queryString.trim().equals("")) {
            String error = "Empty query string";
            return new PgqlResult(queryString, false, error, null, LATEST_VERSION, 0, false, metadataProvider);
        }
        JSGLR2Result parseResult = this.jsglr2.parseResult(queryString);
        if (!parseResult.isSuccess()) {
            PgqlStatement statement = null;
            Position pos = ((JSGLR2Failure)parseResult).parseFailure.failureCause.position;
            StringBuilder sb = new StringBuilder();
            this.toErrorMessage(queryString, pos.line, pos.column - 1, -1, true, null, sb);
            return new PgqlResult(queryString, false, sb.toString(), statement, LATEST_VERSION, 0, false, metadataProvider);
        }
        IStrategoTerm parseAst = (IStrategoTerm)((JSGLR2Success)parseResult).ast;
        Context c = trans.init((Context)new Context((ITermFactory)new ImploderOriginTermFactory((ITermFactory)new TermFactory())));
        boolean allowReferencingAnyProperty = queryString.contains(ALLOW_REFERENCING_ANY_PROPERTY_FLAG);
        IStrategoTerm parseAstPlusMetadata = MetadataToAstUtil.addMetadata(parseAst, metadataProvider, c.getFactory(), allowReferencingAnyProperty);
        IStrategoTerm analyzedAstPlusMetadata = pgql_trans_0_0.instance.invoke(c, parseAstPlusMetadata);
        IStrategoTerm errorMessagesT = get_errors_and_offsets_0_0.instance.invoke(c, analyzedAstPlusMetadata);
        String prettyMessages = null;
        boolean queryValid = true;
        if (errorMessagesT.getSubtermCount() > 0) {
            queryValid = false;
            StringBuilder sb = new StringBuilder();
            int errorNumber = 1;
            for (IStrategoTerm error : errorMessagesT.getSubterms()) {
                if (errorNumber > 1) {
                    sb.append("\n\n");
                }
                ++errorNumber;
                IStrategoTerm offset = error.getSubterm(0);
                int startOffset = ((IStrategoInt)offset.getSubterm(0)).intValue();
                int endOffset = ((IStrategoInt)offset.getSubterm(1)).intValue();
                int lineNumber = 1;
                int currentOffset = 0;
                int columnNumber = -1;
                int length = -1;
                for (String line : queryString.split("\\n|\\r")) {
                    if (currentOffset + line.length() < startOffset) {
                        currentOffset += line.length() + 1;
                        ++lineNumber;
                        continue;
                    }
                    columnNumber = startOffset - currentOffset;
                    length = Math.min(endOffset - startOffset, line.length() - columnNumber);
                    break;
                }
                String message = ((IStrategoString)error.getSubterm(1)).stringValue();
                this.toErrorMessage(queryString, lineNumber, columnNumber, length, false, message, sb);
            }
            prettyMessages = sb.toString();
        }
        IStrategoTerm analyzedAst = MetadataToAstUtil.removeMetadata(analyzedAstPlusMetadata);
        PgqlStatement statement = null;
        try {
            statement = SpoofaxAstToGraphQuery.translate(analyzedAst);
        }
        catch (Exception e) {
            if (e instanceof PgqlException) {
                prettyMessages = e.getMessage();
                queryValid = false;
                return new PgqlResult(queryString, queryValid, prettyMessages, statement, LATEST_VERSION, 0, false, metadataProvider);
            }
            e.printStackTrace();
        }
        IStrategoTerm queryAnnotations = analyzedAst.getSubtermCount() > 9 ? analyzedAst.getSubterm(9) : null;
        PgqlVersion pgqlVersion = this.getPgqlVersion(queryAnnotations, statement);
        if (queryValid) {
            CheckInvalidJavaComment.checkInvalidJavaComment(queryString, pgqlVersion);
        }
        int bindVariableCount = this.getBindVariableCount(queryAnnotations, statement);
        boolean querySelectsAllProperties = this.querySelectsAllProperties(queryAnnotations, statement);
        return new PgqlResult(queryString, queryValid, prettyMessages, statement, pgqlVersion, bindVariableCount, querySelectsAllProperties, metadataProvider);
    }

    private JSGLR2Implementation<IParseForest, ?, ?, IStrategoTerm, ?, ?> getParser(IParseTable parseTable) {
        ParserVariant parserVariant = new ParserVariant(ActiveStacksRepresentation.standard(), ForActorStacksRepresentation.standard(), ParseForestRepresentation.standard(), ParseForestConstruction.standard(), StackRepresentation.standard(), Reducing.standard(), false);
        JSGLR2Variant jsglr2Variant = new JSGLR2Variant(parserVariant, ImploderVariant.standard(), TokenizerVariant.standard());
        return (JSGLR2Implementation)jsglr2Variant.getJSGLR2(parseTable);
    }

    private IParseTable getParseTable() throws ParseTableReadException, IOException {
        InputStream parseTableInputStream = Pgql.class.getClassLoader().getResourceAsStream("sdf.tbl");
        ParseTableVariant tableVariant = new ParseTableVariant();
        return tableVariant.parseTableReader().read(parseTableInputStream);
    }

    private void toErrorMessage(String queryString, int lineNumber, int columnNumber, int length, boolean parseError, String message, StringBuilder sb) {
        sb.append("Error(s) in line " + lineNumber + ":\n\n");
        String line = queryString.split("\\n|\\r")[lineNumber - 1];
        sb.append(ERROR_MESSSAGE_INDENTATION + line + "\n");
        if (parseError) {
            if (line.contains(NON_BREAKING_WHITE_SPACE) && line.substring(columnNumber - 1, columnNumber).equals(NON_BREAKING_WHITE_SPACE)) {
                --columnNumber;
                String originText = NON_BREAKING_WHITE_SPACE;
                length = 1;
                message = NON_BREAKING_WHITE_SPACE_ERROR;
            } else {
                String originText;
                String[] tokens = line.substring(columnNumber).split("\\s+");
                if (tokens.length > 0) {
                    originText = tokens[0];
                    message = "Syntax error, '" + originText + "' not expected";
                } else {
                    originText = line.substring(columnNumber);
                    message = "Unexpected end of query";
                }
                length = originText.length();
            }
        } else {
            String originText = line.substring(columnNumber, columnNumber + length);
        }
        sb.append(ERROR_MESSSAGE_INDENTATION);
        Pgql.repeatString(" ", columnNumber, sb);
        Pgql.repeatString("^", length, sb);
        sb.append("\n");
        sb.append(ERROR_MESSSAGE_INDENTATION + message);
    }

    private static String repeatString(String s, int times, StringBuilder sb) {
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    private PgqlVersion getPgqlVersion(IStrategoTerm queryAnnotations, PgqlStatement statement) {
        PgqlVersion pgqlVersion;
        String pgqlVersionString;
        if (statement == null || statement.getStatementType() != StatementType.SELECT && statement.getStatementType() != StatementType.GRAPH_MODIFY) {
            return LATEST_VERSION;
        }
        switch (pgqlVersionString = ((IStrategoString)queryAnnotations.getSubterm(1)).stringValue()) {
            case "v1.0": {
                pgqlVersion = PgqlVersion.V_1_0;
                break;
            }
            case "v1.1": {
                pgqlVersion = PgqlVersion.V_1_1_OR_V_1_2;
                break;
            }
            case "v1.3": {
                pgqlVersion = PgqlVersion.V_1_3_OR_UP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Version not recognized: " + pgqlVersionString);
            }
        }
        return pgqlVersion;
    }

    private int getBindVariableCount(IStrategoTerm queryAnnotations, PgqlStatement statement) {
        if (statement == null) {
            return 0;
        }
        if (statement.getStatementType() == StatementType.SELECT || statement.getStatementType() == StatementType.GRAPH_MODIFY) {
            return ((IStrategoInt)queryAnnotations.getSubterm(2)).intValue();
        }
        return 0;
    }

    private boolean querySelectsAllProperties(IStrategoTerm queryAnnotations, PgqlStatement statement) {
        if (statement == null) {
            return false;
        }
        if (statement.getStatementType() == StatementType.SELECT || statement.getStatementType() == StatementType.GRAPH_MODIFY) {
            IStrategoAppl selectingAllPropertiesT = (IStrategoAppl)queryAnnotations.getSubterm(3);
            return selectingAllPropertiesT.getConstructor().getName().equals("True");
        }
        return false;
    }

    public List<PgqlCompletion> complete(String queryString, int cursor, PgqlCompletionContext ctx) throws PgqlException {
        PgqlResult pgqlResult = null;
        try {
            pgqlResult = this.parse(queryString);
        }
        catch (PgqlException pgqlException) {
            // empty catch block
        }
        return PgqlCompletionGenerator.generate(pgqlResult, queryString, cursor, ctx);
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

