/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jshell;

import java.io.File;
import java.util.Properties;
import oracle.pg.rdbms.GraphServer;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.shell.aargparse.Arg;
import oracle.pgx.shell.aargparse.ArgumentConverter;
import oracle.pgx.shell.aargparse.ArgumentGroup;
import oracle.pgx.shell.aargparse.ArgumentParser;
import oracle.pgx.shell.aargparse.Converters;
import oracle.pgx.shell.aargparse.exceptions.ArgumentParserException;

public class Arguments {
    public static final String BASE_URL = ClientConfig.Field.BASE_URL.toKey();
    public static final String TRUSTSTORE = ClientConfig.Field.TRUSTSTORE.toKey();
    public static final String KEYSTORE = ClientConfig.Field.KEYSTORE.toKey();
    public static final String NO_BANNER = "no_banner";
    public static final String AUTH_TOKEN_KEYSTORE_ALIAS = "AuthorizationToken";
    @Arg
    public boolean help;
    @Arg
    public boolean version;
    @Arg(dest="idle_timeout")
    public Long idleTimeoutSecs;
    @Arg(dest="task_timeout")
    public Long taskTimeoutSecs;
    @Arg(dest="base_url")
    public String baseUrl;
    @Arg(dest="username")
    public String username;
    @Arg(dest="pgx_conf")
    public File pgxConf;
    @Arg(dest="prefetch_size")
    public int prefetchSize;
    @Arg(dest="upload_batch_size")
    public int uploadBatchSize;
    @Arg(dest="remote_future_timeout")
    public int remoteFutureTimoutMillis;
    @Arg(dest="pending_retry_interval")
    public int pendingRetryIntervalMillis;
    @Arg
    public File script;
    @Arg(dest="script_args")
    public String[] scriptArgs;
    @Arg(dest="keep_running")
    public boolean keepRunning;
    @Arg(dest="truststore")
    public String truststore;
    @Arg(dest="keystore")
    public String keystore;
    @Arg(dest="no_banner")
    public boolean noBanner;
    @Arg(dest="no_connect")
    public boolean noConnect;
    @Arg
    public boolean cctrace;
    @Arg(dest="max_client_http_connections")
    public int maxConnections;
    @Arg(dest="client_server_interaction_mode")
    public String interactionMode;
    @Arg(dest="secret_store")
    public String secretStore;
    @Arg(dest="keystore_auth_token")
    public boolean keystoreAuthToken;
    @Arg(dest="create_partitioned_graphs_with_graph_builder")
    public boolean createPartitionedGraphsWithGraphBuilder;
    @Arg(dest="kerberos_ticket")
    public String kerberosTicket;

    public static Arguments parseArgs(ArgumentParser parser, String[] args) throws ArgumentParserException {
        Properties properties = GraphServer.getProductVersion();
        String productDistribution = properties.getProperty("distribution");
        String productVersion = properties.getProperty("sombrero_version");
        parser.version(productDistribution + " Shell " + productVersion);
        parser.addArgument(new String[]{"--help", "-h"}).action(oracle.pgx.shell.aargparse.Arguments.storeTrue()).help("print the help and exit");
        parser.addArgument(new String[]{"--version"}).action(oracle.pgx.shell.aargparse.Arguments.storeTrue()).help("show " + productDistribution + " version and exit");
        parser.addArgument(new String[]{"--idle_timeout"}).type(Long.class).help("after how many seconds the shell session will time out. If not set, server default will be used. Note that overwriting the server default might be forbidden by PGX engine config.");
        parser.addArgument(new String[]{"--task_timeout"}).type(Long.class).help("after how many seconds tasks submitted by the shell session will time out. If not set, server default will be used. Note that overwriting the server default might be forbidden by PGX engine config.");
        parser.addArgument(new String[]{"--" + BASE_URL, "-b"}).type(String.class).help("if a base url is given, an " + productDistribution + " remote shell is started connecting to the given Oracle Graph Server web url. If no base url is given, Oracle Graph Server shell will start in embedded mode, meaning a local PGX engine will be started, all requests being direct function calls instead of REST requests.");
        parser.addArgument(new String[]{"--no_banner", "-n"}).type(Boolean.TYPE).action(oracle.pgx.shell.aargparse.Arguments.storeTrue()).help("do not print a banner on shell start").setDefault((Object)false);
        parser.addArgument(new String[]{"--no_connect"}).type(Boolean.TYPE).action(oracle.pgx.shell.aargparse.Arguments.storeTrue()).help("if given, " + productDistribution + " shell will not start / connect to PGX nor create a session").setDefault((Object)false);
        parser.addArgument(new String[]{"script"}).type((ArgumentConverter)Converters.fileType().verifyIsFile().verifyCanRead()).help("path to a script to execute").nargs("?");
        parser.addArgument(new String[]{"script_args"}).help("arguments to be passed to script. Arguments can be accessed inside the script using the 'args' list variable.").nargs("*");
        parser.addArgument(new String[]{"--keep_running"}).action(oracle.pgx.shell.aargparse.Arguments.storeTrue()).help("if set and a script is given, the shell will not exit after the given script finished executing successfully. If the given script throws an uncaught exception, the shell will terminate upon hitting that exception regardless of this flag.");
        parser.addArgument(new String[]{"--cctrace"}).action(oracle.pgx.shell.aargparse.Arguments.storeTrue()).help("if set to true, log all Control and Core calls");
        parser.addArgument(new String[]{"--secret_store"}).type(String.class).help("path to the Java Keystore containing required secrets");
        ArgumentGroup embedded = parser.addArgumentGroup("optional embedded shell arguments");
        embedded.addArgument(new String[]{"--pgx_conf", "-c"}).type((ArgumentConverter)Converters.fileType().verifyIsFile().verifyCanRead()).help("path to PGX config file. If not set, Oracle Graph Server looks at default locations. See the 'Using the In-Memory Graph Server (PGX)' section in the Property Graph Developer's Guide.");
        ArgumentGroup authGroup = parser.addArgumentGroup("optional authentication arguments (client/remote shell only)");
        authGroup.addArgument(new String[]{"--username", "-u"}).type(String.class).help("username to use for authentication. Password will be prompted.");
        authGroup.addArgument(new String[]{"--kerberos_ticket"}).type(String.class).help("Path of kerberos ticket to use for authentication.");
        authGroup.addArgument(new String[]{"--" + TRUSTSTORE, "-T"}).type(String.class).help("if connection is over SSL/TLS, this sets the path to the trust store for the server certificate. This is equivalent to setting to Java system property 'javax.net.ssl.trustStore'. If set, the system property will be ignored.");
        authGroup.addArgument(new String[]{"--" + KEYSTORE, "-k"}).type(String.class).help("if server requires SSL/TLS client authentication, this sets the path to the keystore containing the certificate to be sent to the server. This is equivalent to setting the Java system property 'javax.net.ssl.keyStore'. A first access to the keystore will be attempted without password and in case of failure the user will be prompted for the password, which is equivalent to setting it in 'javax.net.ssl.keyStorePassword'. A second access will be attempted with this password and this program will terminate in case of failure.");
        authGroup.addArgument(new String[]{"--keystore_auth_token"}).action(oracle.pgx.shell.aargparse.Arguments.storeTrue()).help("if a keystore path is set (using --" + KEYSTORE + "/-k), then read the authorization token from that keystore using the alias \"AuthorizationToken\"");
        ArgumentGroup additionalClientConfig = parser.addArgumentGroup("optional client/remote shell arguments");
        additionalClientConfig.addArgument(new String[]{"--prefetch_size"}).type(Integer.TYPE).help("number of elements to be downloaded per HTTP request when iterating over big collections.").setDefault(ClientConfig.Field.PREFETCH_SIZE.getDefaultVal());
        additionalClientConfig.addArgument(new String[]{"--upload_batch_size"}).type(Integer.TYPE).help("number of elements to be uploaded per request when sending big collections to the server.").setDefault(ClientConfig.Field.UPLOAD_BATCH_SIZE.getDefaultVal());
        additionalClientConfig.addArgument(new String[]{"--remote_future_timeout"}).type(Integer.TYPE).help("timeout for GET requests waiting for a remote future to finish in milliseconds. See HTTP SO_TIMEOUT.").setDefault(ClientConfig.Field.REMOTE_FUTURE_TIMEOUT.getDefaultVal());
        additionalClientConfig.addArgument(new String[]{"--pending_retry_interval"}).type(Integer.TYPE).help("how many milliseconds to wait before sending another request in case a GET request for a PgxRemoteFuture receives a 202 - Accepted response.").setDefault(ClientConfig.Field.REMOTE_FUTURE_PENDING_RETRY_INTERVAL.getDefaultVal());
        additionalClientConfig.addArgument(new String[]{"--max_client_http_connections"}).type(Integer.TYPE).help("maximum number of connections to open to the Oracle Graph Server").setDefault(ClientConfig.Field.MAX_CLIENT_HTTP_CONNECTIONS.getDefaultVal());
        additionalClientConfig.addArgument(new String[]{"--client_server_interaction_mode"}).type(String.class).help("client/server interaction mode. if 'async_polling' the Oracle Graph Client would poll the status of the future until it's completed. If 'blocking' the Oracle Graph Client would send a request to directly get the value of the future and the server would block until the future result is ready").setDefault((Object)ClientConfig.Field.CLIENT_SERVER_INTERACTION_MODE.getDefaultVal().toString());
        additionalClientConfig.addArgument(new String[]{"--create_partitioned_graphs_with_graph_builder"}).type(Boolean.TYPE).help("if true, the Graph Builder will create partitioned graphs").setDefault(ClientConfig.Field.CREATE_PARTITIONED_GRAPHS_WITH_GRAPH_BUILDER.getDefaultVal());
        Arguments arguments = new Arguments();
        parser.parseArgs(args, (Object)arguments);
        return arguments;
    }
}

