/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.provider;

import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.d;

public final class TransitionMode {
    public static final String JCE_MODE_SECURITY_PROPERTY = "oracle.security.crypto.jce.mode";
    public static final String JCE_MODE_DISABLED = "disabled";
    public static final String JCE_MODE_ENABLED = "enabled";
    public static final String JCE_MODE_EXCLUSIVE = "exclusive";
    public static final String JCE_MODE_FIPS140 = "fips140";
    private static AtomicBoolean a = new AtomicBoolean();
    private static AtomicBoolean b = new AtomicBoolean();
    private static AtomicBoolean c = new AtomicBoolean();

    public static void enableJCEUse() {
        a.set(true);
    }

    public static boolean isJCEUseEnabled() {
        return a.get();
    }

    public static void disableOSDTCrypto() {
        TransitionMode.enableJCEUse();
        b.set(true);
    }

    public static boolean isOSDTCryptoDisabled() {
        return b.get();
    }

    private static void a() {
        c.set(true);
    }

    public static void enableFIPS140Mode() {
        TransitionMode.disableOSDTCrypto();
        if (!TransitionMode.isFIPS140ModeEnabled()) {
            TransitionMode.a();
            JCEUtil.a();
        }
    }

    public static boolean isFIPS140ModeEnabled() {
        return c.get();
    }

    public static void checkCryptoCoreUseAllowed() {
        if (b.get()) {
            throw new IllegalStateException("OSDT internal cryptographic module has been disabled");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 0) {
            System.exit(1);
        }
        if (TransitionMode.isFIPS140ModeEnabled()) {
            System.out.println(JCE_MODE_FIPS140);
        } else if (TransitionMode.isOSDTCryptoDisabled()) {
            System.out.println(JCE_MODE_EXCLUSIVE);
        } else if (TransitionMode.isJCEUseEnabled()) {
            System.out.println(JCE_MODE_ENABLED);
        } else {
            System.out.println(JCE_MODE_DISABLED);
        }
    }

    static {
        String string = AccessController.doPrivileged(new d());
        if (string != null) {
            if (string.equalsIgnoreCase(JCE_MODE_ENABLED)) {
                TransitionMode.enableJCEUse();
            } else if (string.equalsIgnoreCase(JCE_MODE_EXCLUSIVE)) {
                TransitionMode.disableOSDTCrypto();
            } else if (string.equalsIgnoreCase(JCE_MODE_FIPS140)) {
                TransitionMode.enableFIPS140Mode();
            }
        }
    }
}

