/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.vfs.VirtualFile;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class CommonsVfsVirtualFile
implements VirtualFile {
    private final FileObject fo;

    CommonsVfsVirtualFile(FileObject fo) {
        this.fo = fo;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    @Override
    public String getPath() throws IOException {
        return this.fo.getName().getURI();
    }

    public String getRelativeName() throws FileSystemException {
        FileName name = this.fo.getName();
        return name.getRoot().getRelativeName(name);
    }

    @Override
    public String getParent() throws IOException {
        FileObject parent = this.fo.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getURL().toString();
    }

    @Override
    public boolean exists() throws IOException {
        return this.fo.exists();
    }

    @Override
    public void delete() throws IOException {
        boolean succeeded = false;
        Throwable cause = null;
        try {
            succeeded = this.fo.deleteAll() > 0;
        }
        catch (Throwable t) {
            cause = t;
        }
        if (!succeeded) {
            if (cause != null) {
                throw new IOException(ErrorMessages.getMessage("FILE_DELETION_FAILED", new Object[0]), cause);
            }
            throw new IOException(ErrorMessages.getMessage("FILE_DELETION_FAILED", new Object[0]));
        }
    }

    @Override
    public void createFile() throws IOException {
        this.fo.createFile();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fo.getContent().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.fo.isReadable()) {
            try (RandomAccessContent randomAccessContent = this.fo.getContent().getRandomAccessContent(RandomAccessMode.READWRITE);){
                randomAccessContent.setLength(0L);
            }
        }
        return this.fo.getContent().getOutputStream();
    }

    @Override
    public long getLastModifiedTimestamp() throws IOException {
        return this.fo.getContent().getLastModifiedTime();
    }

    @Override
    public long getSizeInBytes() throws IOException {
        return this.fo.getContent().getSize();
    }

    @Override
    public boolean isFile() throws IOException {
        return this.fo.isFile();
    }

    public Stream<CommonsVfsVirtualFile> listFiles() throws IOException {
        if (this.isFile()) {
            return Stream.of(this);
        }
        FileObject[] children = this.fo.getChildren();
        Stream[] streams = new Stream[children.length];
        for (int i = 0; i < children.length; ++i) {
            streams[i] = new CommonsVfsVirtualFile(children[i]).listFiles();
        }
        return Arrays.stream(streams).flatMap(Function.identity());
    }

    public Stream<CommonsVfsVirtualFile> listJsonFiles() throws IOException {
        if (this.isFile()) {
            return Stream.of(this);
        }
        ArrayList<CommonsVfsVirtualFile> streams = new ArrayList<CommonsVfsVirtualFile>();
        for (CommonsVfsVirtualFile vf : this.listFiles().collect(Collectors.toList())) {
            if (vf.fo.isHidden() || !CommonsVfsVirtualFile.isJsonFile(vf.fo.getName())) continue;
            streams.add(vf);
        }
        return streams.stream();
    }

    private static boolean checkJsonExtension(String extension) {
        return extension.equals("json") || extension.equals("conf");
    }

    protected static boolean isJsonFile(String fileName) {
        if (fileName.lastIndexOf(46) > 0) {
            return CommonsVfsVirtualFile.checkJsonExtension(fileName.substring(fileName.lastIndexOf(46) + 1));
        }
        return false;
    }

    private static boolean isJsonFile(FileName fileName) {
        return CommonsVfsVirtualFile.checkJsonExtension(fileName.getExtension());
    }
}

