/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.Optional;
import oracle.pgx.common.util.ErrorMessages;

public class NameValidator {
    public static void validate(String ... names) {
        for (String name : names) {
            NameValidator.getValidationResult(name).ifPresent(message -> {
                throw new IllegalArgumentException((String)message);
            });
        }
    }

    public static boolean isValid(String name) {
        return !NameValidator.getValidationResult(name).isPresent();
    }

    private static Optional<String> getValidationResult(String name) {
        if (name == null) {
            return Optional.empty();
        }
        if (name.length() == 0) {
            return Optional.of(ErrorMessages.getMessage("NAME_MUST_NOT_BE_EMPTY", new Object[0]));
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '{' && c != '}') continue;
            return Optional.of(ErrorMessages.getMessage("NAME_INVALID_CURLY_BRACE_SYMBOL", name, Character.valueOf(c), i + 1));
        }
        return Optional.empty();
    }

    public static void validateDirectoryPath(String path) {
    }
}

