/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.List;
import oracle.pgx.common.Link;
import oracle.pgx.common.Self;

public class PageableCollection
extends Self {
    private long count;
    private final Long totalItems;
    private Collection<?> items;
    private final Boolean hasMore = false;
    private Long offset;
    private Long limit;
    private boolean showTotalResults = true;
    private long next = -1L;
    private long prev = -1L;

    public long getCount() {
        return this.count;
    }

    public PageableCollection() {
        this.totalItems = null;
    }

    public PageableCollection(Collection<?> items) {
        this.items = items;
        this.count = items != null ? (long)items.size() : 0L;
        this.limit = this.count;
        this.totalItems = this.count;
        this.offset = 0L;
        this.showTotalResults = true;
    }

    public PageableCollection(Collection<?> items, List<Link> links) {
        super(links);
        this.items = items;
        this.totalItems = items != null ? ((Number)items.size()).longValue() : 0L;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public Collection getItems() {
        return this.items;
    }

    public void setItems(Collection items) {
        this.items = items;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Long getTotalItems() {
        return this.totalItems;
    }

    public Boolean getHasMore() {
        return this.hasMore;
    }

    public boolean isShowTotalResults() {
        return this.showTotalResults;
    }

    @JsonIgnore
    public long getNext() {
        return this.next;
    }

    public void setNext(long next) {
        this.next = next;
    }

    @JsonIgnore
    public long getPrev() {
        return this.prev;
    }

    public void setPrev(long prev) {
        this.prev = prev;
    }

    @Override
    public void injectLinks() {
    }
}

