/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.math.BigInteger;

public enum MemoryUnit {
    INVALID_MEMORY_UNIT(0L),
    BIT(1L),
    BYTE(8L, BIT),
    KILOBYTE(1024L, BYTE),
    MEGABYTE(1024L, KILOBYTE),
    GIGABYTE(1024L, MEGABYTE),
    TERABYTE(1024L, GIGABYTE),
    PETABYTE(1024L, TERABYTE);

    private final long numBits;

    private MemoryUnit(long numBits) {
        this.numBits = numBits;
    }

    private MemoryUnit(long factor, MemoryUnit base) {
        this.numBits = base.numBits * factor;
    }

    public BigInteger convertFromBig(BigInteger sourceSize, MemoryUnit sourceUnit) {
        BigInteger bigSourceNumBits = BigInteger.valueOf(sourceUnit.numBits);
        BigInteger bigTargetSize = BigInteger.valueOf(this.numBits);
        return sourceSize.multiply(bigSourceNumBits).divide(bigTargetSize);
    }

    public BigInteger convertToBig(BigInteger size, MemoryUnit destinationUnit) {
        return destinationUnit.convertFromBig(size, this);
    }

    public double convertFromFraction(double sourceSize, MemoryUnit sourceUnit) {
        return sourceSize * (double)sourceUnit.numBits / (double)this.numBits;
    }

    public double convertToFraction(double size, MemoryUnit destinationUnit) {
        return destinationUnit.convertFromFraction(size, this);
    }

    public long convertFrom(long sourceSize, MemoryUnit sourceUnit) {
        return Math.multiplyExact(sourceSize, sourceUnit.numBits) / this.numBits;
    }

    public long convertTo(long size, MemoryUnit destinationUnit) {
        return destinationUnit.convertFrom(size, this);
    }

    public long toBits(long size) {
        return this.convertTo(size, BIT);
    }

    public long toBytes(long size) {
        return this.convertTo(size, BYTE);
    }

    public long toKilobytes(long size) {
        return this.convertTo(size, KILOBYTE);
    }

    public long toMegabytes(long size) {
        return this.convertTo(size, MEGABYTE);
    }

    public long toGigabytes(long size) {
        return this.convertTo(size, GIGABYTE);
    }

    public long toTerabytes(long size) {
        return this.convertTo(size, TERABYTE);
    }

    public long toPetabytes(long size) {
        return this.convertTo(size, PETABYTE);
    }
}

