/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import oracle.pgx.api.filter.BinaryGraphFilterOperation;
import oracle.pgx.api.filter.EdgeFilter;
import oracle.pgx.api.filter.FilterIntersection;
import oracle.pgx.api.filter.FilterType;
import oracle.pgx.api.filter.FilterUnion;
import oracle.pgx.api.filter.GraphFilterWithExpression;
import oracle.pgx.api.filter.VertexFilter;

@XmlRootElement
public abstract class GraphFilter {
    private final FilterType type;

    private GraphFilter() {
        throw new UnsupportedOperationException();
    }

    protected GraphFilter(FilterType type) {
        if (type == null) {
            throw new IllegalArgumentException("type shall never be null");
        }
        this.type = type;
    }

    public final FilterType getType() {
        return this.type;
    }

    public final FilterIntersection intersect(GraphFilter other) {
        return new FilterIntersection(this, other);
    }

    public final FilterUnion union(GraphFilter other) {
        return new FilterUnion(this, other);
    }

    public boolean hasExpression() {
        return false;
    }

    @JsonIgnore
    public boolean isBinaryOperation() {
        return false;
    }

    public GraphFilterWithExpression asGraphFilterWithExpression() {
        throw new UnsupportedOperationException();
    }

    public BinaryGraphFilterOperation asBinaryGraphFilterOperation() {
        throw new UnsupportedOperationException();
    }

    public EdgeFilter asEdgeFilter() {
        throw new UnsupportedOperationException();
    }

    public VertexFilter asVertexFilter() {
        throw new UnsupportedOperationException();
    }

    public boolean isResultSetFilter() {
        return false;
    }

    public boolean isCollectionFilter() {
        return false;
    }

    public boolean isPathFindingFilter() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphFilter filter = (GraphFilter)o;
        return this.type == filter.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }
}

