/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlExecution;
import oracle.pg.rdbms.pgql.PgqlStatement;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.PgqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMetadataHandler {
    private static final Logger ms_log = LoggerFactory.getLogger(GraphMetadataHandler.class);
    private static final List<Pair<String, String>> oldPGM = new ArrayList<Pair<String, String>>();
    static final String createGraphStatement = "CREATE PROPERTY GRAPH PROPERTY_GRAPH_METADATA VERTEX TABLES (   \"PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$\" AS property_graph    KEY(owner, graph_name)    PROPERTIES (OWNER, GRAPH_NAME),  \"PROPERTY_GRAPH_METADATA_VERTEX_TABLES$\" AS vertex_table     KEY(owner, graph_name, vertex_table_alias)    PROPERTIES (TABLE_OWNER AS OWNER, VERTEX_TABLE_ALIAS, TABLE_NAME),  \"PROPERTY_GRAPH_METADATA_EDGE_TABLES$\" AS edge_table    KEY(owner, graph_name, edge_table_alias)    PROPERTIES (TABLE_OWNER AS OWNER, EDGE_TABLE_ALIAS, TABLE_NAME),  \"PROPERTY_GRAPH_METADATA_VERTEX_KEY_COLUMNS$\" AS vertex_key_column     KEY(owner, graph_name, vertex_table_alias, column_name)    LABEL key_column    PROPERTIES (column_name, ordinal_position),  \"PROPERTY_GRAPH_METADATA_EDGE_KEY_COLUMNS$\" AS edge_key_column    KEY(owner, graph_name, edge_table_alias, column_name)    LABEL key_column    PROPERTIES (column_name, ordinal_position),  \"PROPERTY_GRAPH_METADATA_LABELS$\" AS label    KEY(owner, graph_name, label_name)    PROPERTIES (label_name),  \"PROPERTY_GRAPH_METADATA_LABEL_PROPERTIES$\" AS property    KEY(owner, graph_name, label_name, property_name)    PROPERTIES (property_name)) EDGE TABLES (  \"PROPERTY_GRAPH_METADATA_VERTEX_TABLES$\"    KEY(owner, graph_name, vertex_table_alias)    SOURCE KEY(owner, graph_name) REFERENCES property_graph    DESTINATION KEY(owner, graph_name, vertex_table_alias) REFERENCES vertex_table    LABEL has_vertex_table NO PROPERTIES,  \"PROPERTY_GRAPH_METADATA_EDGE_TABLES$\"    KEY(owner, graph_name, edge_table_alias)    SOURCE KEY(owner, graph_name) REFERENCES property_graph    DESTINATION KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    LABEL has_edge_table NO PROPERTIES,  \"PROPERTY_GRAPH_METADATA_VERTEX_KEY_COLUMNS$\"    KEY(owner, graph_name, vertex_table_alias, column_name)    SOURCE KEY(owner, graph_name, vertex_table_alias) REFERENCES vertex_table    DESTINATION KEY(owner, graph_name, vertex_table_alias, column_name) REFERENCES vertex_key_column    LABEL has_key_column NO PROPERTIES,  \"PROPERTY_GRAPH_METADATA_EDGE_KEY_COLUMNS$\"    KEY(owner, graph_name, edge_table_alias, column_name)    SOURCE KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    DESTINATION KEY(owner, graph_name, edge_table_alias, column_name) REFERENCES edge_key_column    LABEL has_key_column NO PROPERTIES,  \"PROPERTY_GRAPH_METADATA_VERTEX_LABELS$\"    KEY(owner, graph_name, vertex_table_alias, label_name)    SOURCE KEY(owner, graph_name, vertex_table_alias) REFERENCES vertex_table    DESTINATION KEY(owner, graph_name, label_name) REFERENCES label    LABEL has_label NO PROPERTIES,  \"PROPERTY_GRAPH_METADATA_EDGE_LABELS$\"    KEY(owner, graph_name, edge_table_alias, label_name)    SOURCE KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    DESTINATION KEY(owner, graph_name, label_name) REFERENCES label    LABEL has_label NO PROPERTIES,  \"PROPERTY_GRAPH_METADATA_EDGE_TABLES$\" AS edge_has_source_table    KEY(owner, graph_name, edge_table_alias, source_table_alias)    SOURCE KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    DESTINATION KEY(owner, graph_name, source_table_alias) REFERENCES vertex_table    LABEL has_source_table NO PROPERTIES,  \"PROPERTY_GRAPH_METADATA_EDGE_TABLES$\" AS edge_has_destination_table    KEY(owner, graph_name, edge_table_alias, destination_table_alias)    SOURCE KEY(owner, graph_name, edge_table_alias) REFERENCES edge_table    DESTINATION KEY(owner, graph_name, destination_table_alias) REFERENCES vertex_table    LABEL has_destination_table NO PROPERTIES,  \"PROPERTY_GRAPH_METADATA_LABEL_PROPERTIES$\" AS label_properties    KEY(owner, graph_name, label_name, property_name)    SOURCE KEY(owner, graph_name, label_name) REFERENCES label    DESTINATION KEY(owner, graph_name, label_name, property_name) REFERENCES property    LABEL has_property NO PROPERTIES) OPTIONS (PG_VIEW)";
    static final String bulkDeleteStatement = "DECLARE\n    type array_s is varray(25) of varchar2(50);\n    type array_t is varray(8) of varchar2(50);\n    array_table array_s := array_s(\n        'PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$',\n        'PROPERTY_GRAPH_METADATA_GRAPH_LIST$', \n        'PROPERTY_GRAPH_METADATA_ELEM_TABLE$',\n        'PROPERTY_GRAPH_METADATA_LABEL$',\n        'PROPERTY_GRAPH_METADATA_PROPERTY$',\n        'PROPERTY_GRAPH_METADATA_KEY$',\n        'PROPERTY_GRAPH_METADATA_SRC_DST_KEY$',\n        'PROPERTY_GRAPH_METADATA_VERTEX_TABLES$',\n        'PROPERTY_GRAPH_METADATA_VERTEX_LABELS$',\n        'PROPERTY_GRAPH_METADATA_EDGE_LABELS$',\n        'PROPERTY_GRAPH_METADATA_EDGE_TABLES$',\n        'PROPERTY_GRAPH_METADATA_VERTEX_KEY_COLUMNS$',\n        'PROPERTY_GRAPH_METADATA_EDGE_KEY_COLUMNS$',\n        'PROPERTY_GRAPH_METADATA_LABEL_PROPERTIES$',\n        'PROPERTY_GRAPH_METADATA_LABELS$',\n        'GRAPH_LIST$',\n        'TEMP_PROPERTY_GRAPHS'\n        );\n    array_view array_t := array_t(\n        'TEMP_VERTEX_TABLES',\n        'TEMP_VERTEX_LABELS',\n        'TEMP_EDGE_LABELS',\n        'TEMP_EDGE_TABLES',\n        'TEMP_VERTEX_KEY_COLUMNS',\n        'TEMP_EDGE_KEY_COLUMNS',\n        'TEMP_LABEL_PROPERTIES',\n        'TEMP_LABELS'\n        );\nBEGIN\n    FOR i in 1..array_table.count LOOP\n        BEGIN\n            EXECUTE IMMEDIATE 'DROP TABLE ' || array_table(i);\n            EXCEPTION\n                WHEN OTHERS THEN\n                IF SQLCODE != -942 THEN\n                    RAISE;\n                END IF;\n        END;\n    END LOOP;\n    FOR i in 1..array_view.count LOOP\n        BEGIN\n            EXECUTE IMMEDIATE 'DROP VIEW ' || array_view(i);\n            EXCEPTION\n                WHEN OTHERS THEN\n                IF SQLCODE != -942 THEN\n                    RAISE;\n                END IF;\n        END;\n    END LOOP;\nEND;";
    private static String mainBlock = "DECLARE\n    temp_graphs_size NUMBER;\n    query1 CLOB;\n    query2 CLOB;\n    query3 CLOB;\n    query4 CLOB;\n    query5 CLOB;\n    query6 CLOB;\n    query7 CLOB;\n    query8 CLOB;\n    graph_count DBMS_ID;\n    TYPE create_graph_list_statements_t IS VARRAY(2) OF VARCHAR2(4000);\n    create_graph_list_statements create_graph_list_statements_t := create_graph_list_statements_t(\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_GRAPH_LIST$ (\n            OWNER VARCHAR2(128), \n            GRAPH_NAME VARCHAR2(128),\n            LAST_DDL_TIME DATE\n        )',\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$ (\n            OWNER VARCHAR2(128), \n            GRAPH_NAME VARCHAR2(128),\n            LAST_DDL_TIME DATE\n        )'\n    );\n    areTablesRecreated BOOLEAN := false;\n    TYPE create_statements_t IS VARRAY(8) OF VARCHAR2(4000);\n    create_statements create_statements_t := create_statements_t(\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_VERTEX_TABLES$ (\n            OWNER VARCHAR2(128),\n            GRAPH_NAME VARCHAR2(128),\n            TABLE_OWNER VARCHAR2(128),\n            VERTEX_TABLE_ALIAS VARCHAR2(128),\n            TABLE_NAME VARCHAR2(128)\n        )',\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_EDGE_TABLES$ (\n            OWNER VARCHAR2(128),\n            GRAPH_NAME VARCHAR2(128),\n            TABLE_OWNER VARCHAR2(128),\n            EDGE_TABLE_ALIAS VARCHAR2(128),\n            TABLE_NAME VARCHAR2(128),\n            SOURCE_TABLE_ALIAS VARCHAR2(128),\n            DESTINATION_TABLE_ALIAS VARCHAR2(128)\n        )',\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_VERTEX_KEY_COLUMNS$ (\n            OWNER VARCHAR2(128),\n            GRAPH_NAME VARCHAR2(128),\n            VERTEX_TABLE_ALIAS VARCHAR2(128),\n            COLUMN_NAME VARCHAR2(128),\n            ORDINAL_POSITION NUMBER\n        )',\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_EDGE_KEY_COLUMNS$ (\n            OWNER VARCHAR2(128),\n            GRAPH_NAME VARCHAR2(128),\n            EDGE_TABLE_ALIAS VARCHAR2(128),\n            COLUMN_NAME VARCHAR2(128),\n            ORDINAL_POSITION NUMBER\n        )',\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_VERTEX_LABELS$ (\n            OWNER VARCHAR2(128),\n            GRAPH_NAME VARCHAR2(128),\n            VERTEX_TABLE_ALIAS VARCHAR2(128),\n            LABEL_NAME VARCHAR2(128)\n        )',\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_EDGE_LABELS$ (\n            OWNER VARCHAR2(128),\n            GRAPH_NAME VARCHAR2(128),\n            EDGE_TABLE_ALIAS VARCHAR2(128),\n            LABEL_NAME VARCHAR2(128)\n        )',\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_LABELS$ (\n            OWNER VARCHAR2(128),\n            GRAPH_NAME VARCHAR2(128),\n            LABEL_NAME VARCHAR2(128)\n        )',\n        'CREATE TABLE PROPERTY_GRAPH_METADATA_LABEL_PROPERTIES$ (\n            OWNER VARCHAR2(128),\n            GRAPH_NAME VARCHAR2(128),\n            LABEL_NAME VARCHAR2(128),\n            PROPERTY_NAME VARCHAR2(128)\n        )'\n    );\n    CURSOR cur IS\n         SELECT OWNER, SUBSTR(TABLE_NAME, 1, INSTR(TABLE_NAME, '_ELEM_TABLE$') - 1) AS GRAPH_NAME, ROWNUM rn, count(*) over (partition by 1) as cnt\n           FROM SYS.ALL_TABLES\n           WHERE TABLE_NAME LIKE '%_ELEM_TABLE$' AND TABLE_NAME <> 'PROPERTY_GRAPH_METADATA_ELEM_TABLE$';\nBEGIN\n    BEGIN\n        FOR i IN 1..create_statements.COUNT LOOP\n            BEGIN\n                EXECUTE IMMEDIATE create_statements(i);\n                areTablesRecreated := true;\n            EXCEPTION\n                WHEN OTHERS THEN\n                    IF SQLCODE = -955 THEN\n                        -- Table already exists, ignoring the error\n                        NULL;\n                    ELSE\n                        RAISE; -- Reraise the exception if it's not the expected error\n                    END IF;\n            END;\n        END LOOP;\n    END;\n    BEGIN\n        FOR i IN 1..create_graph_list_statements.COUNT LOOP\n            BEGIN\n                EXECUTE IMMEDIATE create_graph_list_statements(i);\n            EXCEPTION\n                WHEN OTHERS THEN\n                    IF SQLCODE = -955 THEN\n                        -- Table already exists, ignoring the error\n                        NULL;\n                    ELSE\n                        RAISE; -- Reraise the exception if it's not the expected error\n                    END IF;\n            END;\n        END LOOP;\n    END;\n    EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$';\n    EXECUTE IMMEDIATE 'INSERT INTO PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$(owner, graph_name, last_ddl_time) \n        SELECT OWNER, GRAPH_NAME, MAX(LAST_DDL_TIME) AS LAST_DDL_TIME FROM (        SELECT OWNER, \n        CASE WHEN OBJECT_NAME LIKE ''%_ELEM_TABLE$'' THEN SUBSTR(OBJECT_NAME, 1, INSTR(OBJECT_NAME, ''_ELEM_TABLE$'') - 1)\n            WHEN  OBJECT_NAME LIKE ''%_SRC_DST_KEY$'' THEN SUBSTR(OBJECT_NAME, 1, INSTR(OBJECT_NAME, ''_SRC_DST_KEY$'') - 1)\n            WHEN OBJECT_NAME LIKE ''%_LABEL$'' THEN SUBSTR(OBJECT_NAME, 1, INSTR(OBJECT_NAME, ''_LABEL$'') - 1)\n            WHEN OBJECT_NAME LIKE ''%_PROPERTY$'' THEN SUBSTR(OBJECT_NAME, 1, INSTR(OBJECT_NAME, ''_PROPERTY$'') - 1)\n            WHEN OBJECT_NAME LIKE ''%_KEY$'' THEN SUBSTR(OBJECT_NAME, 1, INSTR(OBJECT_NAME, ''_KEY$'') - 1) \n        END AS GRAPH_NAME, \n        LAST_DDL_TIME\n        FROM SYS.ALL_OBJECTS\n        WHERE (OBJECT_NAME LIKE ''%_ELEM_TABLE$'' \n                OR OBJECT_NAME LIKE ''%_KEY$'' \n                OR OBJECT_NAME LIKE ''%_LABEL$'' \n                OR OBJECT_NAME LIKE ''%_PROPERTY$'' \n                OR OBJECT_NAME LIKE ''%_SRC_DST_KEY$''\n            )\n            AND OBJECT_NAME <> ''PROPERTY_GRAPH_METADATA_ELEM_TABLE$'' \n            AND OBJECT_NAME <> ''PROPERTY_GRAPH_METADATA_KEY$'' \n            AND OBJECT_NAME <> ''PROPERTY_GRAPH_METADATA_LABEL$'' \n            AND OBJECT_NAME <> ''PROPERTY_GRAPH_METADATA_PROPERTY$'' \n            AND OBJECT_NAME <> ''PROPERTY_GRAPH_METADATA_SRC_DST_KEY$'' )\n        GROUP BY OWNER, GRAPH_NAME\n    ';\n    COMMIT;\n    EXECUTE IMMEDIATE 'SELECT COUNT(*) FROM PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$' INTO temp_graphs_size;\n    EXECUTE IMMEDIATE 'SELECT COUNT(*) as cnt FROM (\n                (SELECT OWNER, GRAPH_NAME, LAST_DDL_TIME FROM PROPERTY_GRAPH_METADATA_GRAPH_LIST$ MINUS SELECT OWNER, GRAPH_NAME, LAST_DDL_TIME FROM PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$)\n                UNION ALL\n                (SELECT OWNER, GRAPH_NAME, LAST_DDL_TIME FROM PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$ MINUS SELECT OWNER, GRAPH_NAME, LAST_DDL_TIME FROM PROPERTY_GRAPH_METADATA_GRAPH_LIST$)\n            )' INTO graph_count;\n    IF graph_count != 0 OR temp_graphs_size = 0 OR areTablesRecreated THEN\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_GRAPH_LIST$';\n        EXECUTE IMMEDIATE 'INSERT INTO PROPERTY_GRAPH_METADATA_GRAPH_LIST$ SELECT * FROM PROPERTY_GRAPH_METADATA_PROPERTY_GRAPHS$';\n        COMMIT;\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_VERTEX_TABLES$';\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_EDGE_TABLES$';\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_VERTEX_KEY_COLUMNS$';\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_EDGE_KEY_COLUMNS$';\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_VERTEX_LABELS$';\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_EDGE_LABELS$';\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_LABELS$';\n        EXECUTE IMMEDIATE 'TRUNCATE TABLE PROPERTY_GRAPH_METADATA_LABEL_PROPERTIES$';\n        query1 := 'INSERT INTO PROPERTY_GRAPH_METADATA_VERTEX_TABLES$ (OWNER, GRAPH_NAME, TABLE_OWNER, VERTEX_TABLE_ALIAS, TABLE_NAME) SELECT * FROM ( ';\n        query2 := 'INSERT INTO PROPERTY_GRAPH_METADATA_EDGE_TABLES$ (OWNER, GRAPH_NAME, TABLE_OWNER, EDGE_TABLE_ALIAS, TABLE_NAME, SOURCE_TABLE_ALIAS, DESTINATION_TABLE_ALIAS) SELECT * FROM ( ';\n        query3 := 'INSERT INTO PROPERTY_GRAPH_METADATA_VERTEX_KEY_COLUMNS$ (OWNER, GRAPH_NAME, VERTEX_TABLE_ALIAS, COLUMN_NAME, ORDINAL_POSITION) SELECT * FROM ( ';\n        query4 := 'INSERT INTO PROPERTY_GRAPH_METADATA_EDGE_KEY_COLUMNS$ (OWNER, GRAPH_NAME, EDGE_TABLE_ALIAS, COLUMN_NAME, ORDINAL_POSITION) SELECT * FROM ( ';\n        query5 := 'INSERT INTO PROPERTY_GRAPH_METADATA_VERTEX_LABELS$ (OWNER, GRAPH_NAME, VERTEX_TABLE_ALIAS, LABEL_NAME) SELECT * FROM ( ';\n        query6 := 'INSERT INTO PROPERTY_GRAPH_METADATA_EDGE_LABELS$ (OWNER, GRAPH_NAME, EDGE_TABLE_ALIAS, LABEL_NAME) SELECT * FROM ( ';\n        query7 := 'INSERT INTO PROPERTY_GRAPH_METADATA_LABELS$ (OWNER, GRAPH_NAME, LABEL_NAME) SELECT * FROM ( ';\n        query8 := 'INSERT INTO PROPERTY_GRAPH_METADATA_LABEL_PROPERTIES$ (OWNER, GRAPH_NAME, LABEL_NAME, PROPERTY_NAME) SELECT * FROM ( ';\n        FOR g_rec IN cur LOOP \n            query1:= query1 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, schema_name AS TABLE_OWNER, et_name AS VERTEX_TABLE_ALIAS, table_name AS TABLE_NAME  \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_ELEM_TABLE$', false) || '\n                    WHERE et_type=''VERTEX''';\n                     \n            query2:= query2 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, t.schema_name AS TABLE_OWNER, t.et_name AS EDGE_TABLE_ALIAS, t.table_name AS TABLE_NAME, t1.vt_name AS SOURCE_TABLE_ALIAS, t2.vt_name AS DESTINATION_TABLE_ALIAS \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_ELEM_TABLE$', false) ||' t, ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_SRC_DST_KEY$', false) || ' t1, ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_SRC_DST_KEY$', false) ||' t2\n                    WHERE t.et_type = ''EDGE'' AND t1.key_type = ''EDGE_SOURCE'' AND t1.et_name=t.et_name AND t2.key_type = ''EDGE_DESTINATION'' AND t2.et_name=t.et_name';\n                     \n            query3:= query3 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS VERTEX_TABLE_ALIAS , column_name AS COLUMN_NAME, column_number AS ORDINAL_POSITION  \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_KEY$', false) ||'\n                    WHERE key_type = ''VERTEX''';\n                     \n            query4:= query4 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS EDGE_TABLE_ALIAS , column_name AS COLUMN_NAME, column_number AS ORDINAL_POSITION  \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_KEY$', false) ||'\n                    WHERE key_type = ''EDGE''';\n                     \n            query5:= query5 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS VERTEX_TABLE_ALIAS, label_name AS LABEL_NAME \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_LABEL$', false) ||'\n                    WHERE et_type = ''VERTEX''';\n                     \n            query6:= query6 || 'SELECT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, et_name AS EDGE_TABLE_ALIAS, label_name AS LABEL_NAME \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_LABEL$', false) ||'\n                    WHERE et_type = ''EDGE''';\n                     \n            query7:= query7 || 'SELECT DISTINCT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, label_name AS LABEL_NAME \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_LABEL$', false) ||'\n                    ';\n            query8:= query8 || 'SELECT DISTINCT ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.owner, '''', '''''')) || ' AS OWNER , ' || SYS.DBMS_ASSERT.ENQUOTE_LITERAL(REPLACE(g_rec.graph_name, '''', '''''')) || ' AS GRAPH_NAME, label_name AS LABEL_NAME, property_name AS PROPERTY_NAME \n                    FROM ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.owner, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(g_rec.graph_name || '_PROPERTY$', false) ||'\n                    ';\n             \n            IF g_rec.rn != g_rec.cnt THEN \n                query1:= query1 || ' UNION ALL ';\n                query2:= query2 || ' UNION ALL ';\n                query3:= query3 || ' UNION ALL ';\n                query4:= query4 || ' UNION ALL ';\n                query5:= query5 || ' UNION ALL ';\n                query6:= query6 || ' UNION ALL ';\n                query7:= query7 || ' UNION ALL ';\n                query8:= query8 || ' UNION ALL ';\n            END IF;\n        END LOOP;\n        -- in case there are no graphs, we want to fill the tables with empty data\n        IF temp_graphs_size = 0 THEN\n            query1 := query1 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''schema_name'' AS TABLE_OWNER, ''et_name'' AS VERTEX_TABLE_ALIAS, ''table_name'' AS TABLE_NAME FROM DUAL where 1 <> 1';\n            query2 := query2 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''schema_name'' AS TABLE_OWNER, ''et_name'' AS EDGE_TABLE_ALIAS, ''table_name'' AS TABLE_NAME, ''vt_name'' AS SOURCE_TABLE_ALIAS, ''vt_name'' AS DESTINATION_TABLE_ALIAS FROM dual WHERE 1 <> 1';\n            query3 := query3 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS VERTEX_TABLE_ALIAS, ''column_name'' AS COLUMN_NAME, 1 AS ORDINAL_POSITION FROM dual WHERE 1 <> 1';\n            query4 := query4 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS EDGE_TABLE_ALIAS , ''column_name'' AS COLUMN_NAME, 1 AS ORDINAL_POSITION FROM dual WHERE 1 <> 1';\n            query5 := query5 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS VERTEX_TABLE_ALIAS, ''label_name'' AS LABEL_NAME FROM dual WHERE 1 <> 1';\n            query6 := query6 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''et_name'' AS EDGE_TABLE_ALIAS, ''label_name'' AS LABEL_NAME FROM dual WHERE 1 <> 1';\n            query7 := query7 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''label_name'' as LABEL_NAME FROM dual WHERE 1 <> 1';\n            query8 := query8 || 'SELECT ''owner'' AS OWNER, ''graph_name'' AS GRAPH_NAME, ''label_name'' as LABEL_NAME, ''property_name'' AS PROPERTY_NAME FROM dual WHERE 1 <> 1';\n        END IF;\n        query1:= query1 || ' )';\n        query2:= query2 || ' )';\n        query3:= query3 || ' )';\n        query4:= query4 || ' )';\n        query5:= query5 || ' )';\n        query6:= query6 || ' )';\n        query7:= query7 || ' )';\n        query8:= query8 || ' )';\n        EXECUTE IMMEDIATE query1;\n        EXECUTE IMMEDIATE query2;\n        EXECUTE IMMEDIATE query3;\n        EXECUTE IMMEDIATE query4;\n        EXECUTE IMMEDIATE query5;\n        EXECUTE IMMEDIATE query6;\n        EXECUTE IMMEDIATE query7;\n        EXECUTE IMMEDIATE query8;\n    END IF;\n    COMMIT;\nEND;";

    public static boolean graphMetadataInitiator(PgqlConnection pgqlConn, String schemaName) throws SQLException {
        ms_log.debug("PROPERTY_GRAPH_METADATA initialization");
        String url = pgqlConn.getJdbcConnection().getMetaData().getURL();
        Pair<String, String> tmpValue = new Pair<String, String>(url, schemaName);
        if (!oldPGM.contains(tmpValue)) {
            ms_log.debug("Cleaning old PGM content");
            oldPGM.add(tmpValue);
            GraphMetadataHandler.cleanup(pgqlConn.getJdbcConnection());
        }
        boolean created = false;
        try (ResultSet rs = null;
             PreparedStatement ps = pgqlConn.getJdbcConnection().prepareStatement("SELECT TABLE_NAME         FROM SYS.ALL_TABLES        WHERE TABLE_NAME = 'PROPERTY_GRAPH_METADATA_ELEM_TABLE$' AND OWNER=?");){
            GraphMetadataHandler.bulkExecute(pgqlConn.getJdbcConnection(), mainBlock);
            ms_log.debug("PLSQL script for PROPERTY_GRAPH_METADATA executed successfully");
            ps.setString(1, schemaName);
            rs = ps.executeQuery();
            if (!rs.next()) {
                created = true;
                GraphMetadataHandler.createGraph(pgqlConn, schemaName);
            }
            ms_log.debug("PROPERTY_GRAPH_METADATA creation completed successfully");
        }
        return created;
    }

    private static void bulkExecute(Connection conn, String plsqlBlock) throws SQLException {
        try (CallableStatement stmt = conn.prepareCall(plsqlBlock);){
            stmt.execute();
        }
    }

    public static void cleanup(Connection conn) {
        try {
            GraphMetadataHandler.bulkExecute(conn, bulkDeleteStatement);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void createGraph(PgqlConnection pgqlConn, String schemaName) throws PgqlException {
        try (PgqlStatement pgqlStmt = pgqlConn.createStatement();){
            PgqlExecution.deleteCache(pgqlConn, schemaName, "PROPERTY_GRAPH_METADATA");
            pgqlStmt.execute(createGraphStatement);
        }
    }
}

