/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.metadata.EdgeTable;
import oracle.pg.rdbms.pgql.pgview.metadata.Key;
import oracle.pg.rdbms.pgql.pgview.metadata.Label;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.metadata.Property;
import oracle.pg.rdbms.pgql.pgview.metadata.VertexTable;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ddl.propertygraph.BaseElementTable;
import oracle.pgql.lang.ddl.propertygraph.BaseGraph;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.CreateSuperPropertyGraph;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class CspgToCpg {
    private final PgqlConnection pgqlConn;
    private final String graphSchema;
    private CreateSuperPropertyGraph cspg;

    private CspgToCpg(PgqlConnection pgqlConn, String graphSchema, CreateSuperPropertyGraph cspg) {
        this.pgqlConn = pgqlConn;
        this.graphSchema = graphSchema;
        this.cspg = cspg;
    }

    public static CspgToCpg getCspgToCpg(PgqlConnection pgqlConn, String graphSchema, CreateSuperPropertyGraph cspg) {
        return new CspgToCpg(pgqlConn, graphSchema, cspg);
    }

    public CreatePropertyGraph mapCspgToCpg() throws PgqlToSqlException {
        return this.regroupListOfCpgToOneCpg(this.cspg.getBaseGraphs().stream().map(baseGraph -> this.getCpgFromBaseGraph((BaseGraph)baseGraph)).collect(Collectors.toList()));
    }

    private CreatePropertyGraph getCpgFromBaseGraph(BaseGraph baseGraph) throws PgqlToSqlException {
        boolean isAllElementTablesExceptSpecified;
        String graphSchema = baseGraph.getGraphName().getSchemaName() == null ? this.graphSchema : baseGraph.getGraphName().getSchemaName();
        baseGraph.getGraphName().setSchemaName(graphSchema);
        GraphType baseGraphType = PgqlUtils.getGraphType(this.pgqlConn.getJdbcConnection(), graphSchema, baseGraph.getGraphName().getName(), true, false, false);
        if (baseGraphType == null) {
            throw new PgqlToSqlException("The base graph with name " + this.printGraph(baseGraph.getGraphName().getSchemaName(), baseGraph.getGraphName().getName()) + " does not exist");
        }
        if (baseGraphType != GraphType.PG_VIEWS) {
            throw new PgqlToSqlException("Base graph " + this.printGraph(baseGraph.getGraphName().getSchemaName(), baseGraph.getGraphName().getName()) + " is a " + (Object)((Object)baseGraphType) + " graph, only PG_PGQL graphs are allowed in BASE GRAPHS clause");
        }
        MetadataConnector metadataConnector = new MetadataConnector(this.pgqlConn.getJdbcConnection(), graphSchema, baseGraph.getGraphName().getName(), 1000);
        List<oracle.pgql.lang.ddl.propertygraph.VertexTable> vertexTableList = this.getVertexListFromMetadata(metadataConnector);
        List<oracle.pgql.lang.ddl.propertygraph.EdgeTable> edgeTableList = this.getEdgeListFromMetadata(metadataConnector);
        boolean isBaseElementTablesSpecified = baseGraph.getBaseElementTables() != null;
        boolean bl = isAllElementTablesExceptSpecified = baseGraph.getAllElementTablesExcept() != null;
        if (isBaseElementTablesSpecified) {
            ArrayList<oracle.pgql.lang.ddl.propertygraph.VertexTable> filteredVertexList = new ArrayList<oracle.pgql.lang.ddl.propertygraph.VertexTable>();
            ArrayList<oracle.pgql.lang.ddl.propertygraph.EdgeTable> filteredEdgeList = new ArrayList<oracle.pgql.lang.ddl.propertygraph.EdgeTable>();
            HashMap<oracle.pgql.lang.ddl.propertygraph.VertexTable, String> vertexBeforeAliasChanged = new HashMap<oracle.pgql.lang.ddl.propertygraph.VertexTable, String>();
            for (BaseElementTable elementTable : baseGraph.getBaseElementTables()) {
                boolean isElementTableExistInTheBaseGraph = false;
                for (oracle.pgql.lang.ddl.propertygraph.VertexTable vt : vertexTableList) {
                    if (!vt.getTableName().getName().equals(elementTable.getReferencedTableName())) continue;
                    if (!elementTable.getTableAlias().equals(elementTable.getReferencedTableName())) {
                        vertexBeforeAliasChanged.put(vt, elementTable.getTableAlias());
                        oracle.pgql.lang.ddl.propertygraph.VertexTable vtWithUpdatedAlias = new oracle.pgql.lang.ddl.propertygraph.VertexTable(vt.getTableName(), vt.getTableAlias(), vt.getKey(), vt.getLabels());
                        vtWithUpdatedAlias.setTableAlias(elementTable.getTableAlias());
                        filteredVertexList.add(vtWithUpdatedAlias);
                    } else {
                        filteredVertexList.add(vt);
                    }
                    isElementTableExistInTheBaseGraph = true;
                }
                for (oracle.pgql.lang.ddl.propertygraph.EdgeTable ed : edgeTableList) {
                    if (!ed.getTableName().getName().equals(elementTable.getReferencedTableName())) continue;
                    if (!elementTable.getTableAlias().equals(elementTable.getReferencedTableName())) {
                        ed.setTableAlias(elementTable.getTableAlias());
                    }
                    filteredEdgeList.add(ed);
                    isElementTableExistInTheBaseGraph = true;
                }
                if (isElementTableExistInTheBaseGraph) continue;
                throw new PgqlToSqlException("Element table " + elementTable.getReferencedTableName() + " does not exist in base graph " + this.printGraph(baseGraph.getGraphName().getSchemaName(), baseGraph.getGraphName().getName()));
            }
            vertexTableList = filteredVertexList;
            edgeTableList = filteredEdgeList;
            for (oracle.pgql.lang.ddl.propertygraph.EdgeTable edge : edgeTableList) {
                if (!vertexTableList.contains(edge.getSourceVertexTable())) {
                    if (vertexBeforeAliasChanged.keySet().contains(edge.getSourceVertexTable())) {
                        edge.getSourceVertexTable().setTableAlias((String)vertexBeforeAliasChanged.get(edge.getSourceVertexTable()));
                    } else {
                        throw new PgqlToSqlException(this.missingVertex(baseGraph, edge, true));
                    }
                }
                if (vertexTableList.contains(edge.getDestinationVertexTable())) continue;
                if (vertexBeforeAliasChanged.keySet().contains(edge.getDestinationVertexTable())) {
                    edge.getDestinationVertexTable().setTableAlias((String)vertexBeforeAliasChanged.get(edge.getDestinationVertexTable()));
                    continue;
                }
                throw new PgqlToSqlException(this.missingVertex(baseGraph, edge, false));
            }
        }
        if (isAllElementTablesExceptSpecified) {
            for (String elementTableName : baseGraph.getAllElementTablesExcept()) {
                Iterator<oracle.pgql.lang.ddl.propertygraph.VertexTable> vertexTableIterator = vertexTableList.iterator();
                Iterator<oracle.pgql.lang.ddl.propertygraph.EdgeTable> edgeTableIterator = edgeTableList.iterator();
                while (vertexTableIterator.hasNext()) {
                    oracle.pgql.lang.ddl.propertygraph.VertexTable vt = vertexTableIterator.next();
                    if (!vt.getTableName().getName().equals(elementTableName)) continue;
                    vertexTableIterator.remove();
                }
                while (edgeTableIterator.hasNext()) {
                    oracle.pgql.lang.ddl.propertygraph.EdgeTable ed = edgeTableIterator.next();
                    if (!ed.getTableName().getName().equals(elementTableName)) continue;
                    edgeTableIterator.remove();
                }
            }
            for (oracle.pgql.lang.ddl.propertygraph.EdgeTable edge : edgeTableList) {
                if (!vertexTableList.contains(edge.getSourceVertexTable())) {
                    throw new PgqlToSqlException(this.missingVertex(baseGraph, edge, true));
                }
                if (vertexTableList.contains(edge.getDestinationVertexTable())) continue;
                throw new PgqlToSqlException(this.missingVertex(baseGraph, edge, false));
            }
        }
        return new CreatePropertyGraph(baseGraph.getGraphName(), vertexTableList, edgeTableList);
    }

    private CreatePropertyGraph regroupListOfCpgToOneCpg(List<CreatePropertyGraph> createPropertyGraphList) throws PgqlToSqlException {
        HashMap<String, Pair<oracle.pgql.lang.ddl.propertygraph.VertexTable, SchemaQualifiedName>> mapAliasVertex = new HashMap<String, Pair<oracle.pgql.lang.ddl.propertygraph.VertexTable, SchemaQualifiedName>>();
        this.cspg.getVertexTables().forEach(vertex -> mapAliasVertex.put(vertex.getTableAlias(), new Pair<oracle.pgql.lang.ddl.propertygraph.VertexTable, SchemaQualifiedName>((oracle.pgql.lang.ddl.propertygraph.VertexTable)vertex, this.cspg.getGraphName())));
        HashMap<String, Pair<oracle.pgql.lang.ddl.propertygraph.EdgeTable, SchemaQualifiedName>> mapAliasEdge = new HashMap<String, Pair<oracle.pgql.lang.ddl.propertygraph.EdgeTable, SchemaQualifiedName>>();
        this.cspg.getEdgeTables().forEach(edge -> mapAliasEdge.put(edge.getTableAlias(), new Pair<oracle.pgql.lang.ddl.propertygraph.EdgeTable, SchemaQualifiedName>((oracle.pgql.lang.ddl.propertygraph.EdgeTable)edge, this.cspg.getGraphName())));
        for (CreatePropertyGraph cpg : createPropertyGraphList) {
            for (oracle.pgql.lang.ddl.propertygraph.VertexTable vertex2 : cpg.getVertexTables()) {
                if (mapAliasVertex.containsKey(vertex2.getTableAlias())) {
                    if (((SchemaQualifiedName)((Pair)mapAliasVertex.get((Object)vertex2.getTableAlias())).second).equals((Object)this.cspg.getGraphName())) {
                        throw new PgqlToSqlException("The base graph " + this.printGraph(cpg.getGraphName().getSchemaName(), cpg.getGraphName().getName()) + " has a vertex table " + vertex2.getTableAlias() + " that is also defined in the VERTEX TABLES clause");
                    }
                    throw new PgqlToSqlException("Duplicate vertex table name " + vertex2.getTableAlias() + " between the two base graphs " + this.printGraph(((SchemaQualifiedName)((Pair)mapAliasVertex.get((Object)vertex2.getTableAlias())).second).getSchemaName(), ((SchemaQualifiedName)((Pair)mapAliasVertex.get((Object)vertex2.getTableAlias())).second).getName()) + " and " + this.printGraph(cpg.getGraphName().getSchemaName(), cpg.getGraphName().getName()));
                }
                mapAliasVertex.put(vertex2.getTableAlias(), new Pair<oracle.pgql.lang.ddl.propertygraph.VertexTable, SchemaQualifiedName>(vertex2, cpg.getGraphName()));
            }
            for (oracle.pgql.lang.ddl.propertygraph.EdgeTable edge2 : cpg.getEdgeTables()) {
                if (mapAliasEdge.containsKey(edge2.getTableAlias())) {
                    if (((SchemaQualifiedName)((Pair)mapAliasEdge.get((Object)edge2.getTableAlias())).second).equals((Object)this.cspg.getGraphName())) {
                        throw new PgqlToSqlException("The base graph " + this.printGraph(cpg.getGraphName().getSchemaName(), cpg.getGraphName().getName()) + " has an edge table " + edge2.getTableAlias() + " that is also defined in the EDGE TABLES clause");
                    }
                    throw new PgqlToSqlException("Duplicate edge table name " + edge2.getTableAlias() + " between the two base graphs " + this.printGraph(((SchemaQualifiedName)((Pair)mapAliasEdge.get((Object)edge2.getTableAlias())).second).getSchemaName(), ((SchemaQualifiedName)((Pair)mapAliasEdge.get((Object)edge2.getTableAlias())).second).getName()) + " and " + this.printGraph(cpg.getGraphName().getSchemaName(), cpg.getGraphName().getName()));
                }
                mapAliasEdge.put(edge2.getTableAlias(), new Pair<oracle.pgql.lang.ddl.propertygraph.EdgeTable, SchemaQualifiedName>(edge2, cpg.getGraphName()));
            }
        }
        for (oracle.pgql.lang.ddl.propertygraph.EdgeTable edge3 : this.cspg.getEdgeTables()) {
            if (!mapAliasVertex.containsKey(edge3.getSourceVertexTable().getTableAlias())) {
                throw new PgqlToSqlException("Undefined source vertex table " + edge3.getSourceVertexTable().getTableAlias());
            }
            ((oracle.pgql.lang.ddl.propertygraph.EdgeTable)((Pair)mapAliasEdge.get((Object)edge3.getTableAlias())).first).setSourceVertexTable((oracle.pgql.lang.ddl.propertygraph.VertexTable)((Pair)mapAliasVertex.get((Object)edge3.getSourceVertexTable().getTableAlias())).first);
            if (!mapAliasVertex.containsKey(edge3.getDestinationVertexTable().getTableAlias())) {
                throw new PgqlToSqlException("Undefined destination vertex table " + edge3.getDestinationVertexTable().getTableAlias());
            }
            ((oracle.pgql.lang.ddl.propertygraph.EdgeTable)((Pair)mapAliasEdge.get((Object)edge3.getTableAlias())).first).setDestinationVertexTable((oracle.pgql.lang.ddl.propertygraph.VertexTable)((Pair)mapAliasVertex.get((Object)edge3.getDestinationVertexTable().getTableAlias())).first);
        }
        return new CreatePropertyGraph(this.cspg.getGraphName(), mapAliasVertex.keySet().stream().map(vtAlias -> (oracle.pgql.lang.ddl.propertygraph.VertexTable)((Pair)mapAliasVertex.get((Object)vtAlias)).first).collect(Collectors.toList()), mapAliasEdge.keySet().stream().map(edAlias -> (oracle.pgql.lang.ddl.propertygraph.EdgeTable)((Pair)mapAliasEdge.get((Object)edAlias)).first).collect(Collectors.toList()));
    }

    private List<oracle.pgql.lang.ddl.propertygraph.VertexTable> getVertexListFromMetadata(MetadataConnector metadataConnector) {
        return metadataConnector.getVertexTables().keySet().stream().map(vtAlias -> this.toPgVt(metadataConnector.getVertexTables().get(vtAlias), (String)vtAlias)).collect(Collectors.toList());
    }

    private List<oracle.pgql.lang.ddl.propertygraph.EdgeTable> getEdgeListFromMetadata(MetadataConnector metadataConnector) {
        return metadataConnector.getEdgeTables().keySet().stream().map(edAlias -> {
            EdgeTable edgeTable = metadataConnector.getEdgeTables().get(edAlias);
            VertexTable vtSrc = metadataConnector.getVertexTables().get(edgeTable.getSource());
            VertexTable vtDes = metadataConnector.getVertexTables().get(edgeTable.getDestination());
            String alias = edAlias == null ? edgeTable.getTableName().getName() : edAlias;
            List<String> vtSrcKey = metadataConnector.getEdgeTableSrcKey(alias).stream().map(pair -> (String)pair.second).collect(Collectors.toList());
            List<String> vtDestKey = metadataConnector.getEdgeTableDstKey(alias).stream().map(pair -> (String)pair.second).collect(Collectors.toList());
            return this.toPgEt(metadataConnector.getEdgeTables().get(edAlias), (String)edAlias, vtSrc, vtSrcKey, vtDes, vtDestKey);
        }).collect(Collectors.toList());
    }

    private oracle.pgql.lang.ddl.propertygraph.VertexTable toPgVt(VertexTable vertexTable, String vtAlias) {
        return new oracle.pgql.lang.ddl.propertygraph.VertexTable(vertexTable.getTableName(), vtAlias == null ? vertexTable.getTableName().getName() : vtAlias, this.toPgKey(vertexTable.getKey()), vertexTable.getLabels().stream().map(vtlabel -> this.toPgLabel((Label)vtlabel)).collect(Collectors.toList()));
    }

    private oracle.pgql.lang.ddl.propertygraph.EdgeTable toPgEt(EdgeTable edgeTable, String edAlias, VertexTable vtSrc, List<String> vtSrcKey, VertexTable vtDest, List<String> vtDestKey) {
        String alias = edAlias == null ? edgeTable.getTableName().getName() : edAlias;
        return new oracle.pgql.lang.ddl.propertygraph.EdgeTable(edgeTable.getTableName(), alias, this.toPgKey(edgeTable.getKey()), this.toPgVt(vtSrc, edgeTable.getSource()), this.toPgKey(edgeTable.getSourceKey()), new oracle.pgql.lang.ddl.propertygraph.Key(vtSrcKey), this.toPgVt(vtDest, edgeTable.getDestination()), this.toPgKey(edgeTable.getDestinationKey()), new oracle.pgql.lang.ddl.propertygraph.Key(vtDestKey), edgeTable.getLabels().stream().map(edLabel -> this.toPgLabel((Label)edLabel)).collect(Collectors.toList()));
    }

    private oracle.pgql.lang.ddl.propertygraph.Key toPgKey(Key key) {
        return new oracle.pgql.lang.ddl.propertygraph.Key(key.getColumnsList());
    }

    private oracle.pgql.lang.ddl.propertygraph.Label toPgLabel(Label label) {
        return new oracle.pgql.lang.ddl.propertygraph.Label(label.getLabel(), label.getProperties().stream().map(propertyName -> this.toPgProperty(label.getProperty((String)propertyName))).collect(Collectors.toList()));
    }

    private oracle.pgql.lang.ddl.propertygraph.Property toPgProperty(Property property) {
        return new oracle.pgql.lang.ddl.propertygraph.Property((QueryExpression)new QueryExpression.VarRef((QueryVariable)new QueryVertex(property.getColumn().getName(), false)), property.getName());
    }

    private String printGraph(String graphSchema, String graphName) {
        if (graphSchema == null) {
            return graphName;
        }
        return graphSchema.equals(this.pgqlConn.getSchema()) ? graphName : graphSchema + "." + graphName;
    }

    private String missingVertex(BaseGraph baseGraph, oracle.pgql.lang.ddl.propertygraph.EdgeTable edge, boolean isSrc) {
        return "In the base graph " + this.printGraph(baseGraph.getGraphName().getSchemaName(), baseGraph.getGraphName().getName()) + ": the edge table " + edge.getTableAlias() + (isSrc ? " has source vertex table " + edge.getSourceVertexTable().getTableAlias() : " has destination vertex table " + edge.getDestinationVertexTable().getTableAlias()) + " that must be included too";
    }
}

