/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.util;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pgql.lang.ir.DerivedTable;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OptionalGraphPattern;
import oracle.pgql.lang.ir.OrderBy;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.Projection;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.modify.DeleteClause;
import oracle.pgql.lang.ir.modify.EdgeInsertion;
import oracle.pgql.lang.ir.modify.InsertClause;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.ir.modify.SetPropertyExpression;
import oracle.pgql.lang.ir.modify.Update;
import oracle.pgql.lang.ir.modify.UpdateClause;
import oracle.pgql.lang.ir.modify.VertexInsertion;

public abstract class ReplaceExpressions
implements QueryExpressionVisitor {
    protected abstract boolean matches(QueryExpression var1);

    public abstract QueryExpression replace(QueryExpression var1);

    private QueryExpression replaceMatching(QueryExpression expression) {
        if (expression == null) {
            return null;
        }
        if (this.matches(expression)) {
            return this.replace(expression);
        }
        expression.accept(this);
        return expression;
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.UMin uMin) {
        this.replaceInUnaryExpression(uMin);
    }

    @Override
    public void visit(QueryExpression.LogicalExpression.Not not) {
        this.replaceInUnaryExpression(not);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Sub sub) {
        this.replaceInBinaryExpression(sub);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Add add) {
        this.replaceInBinaryExpression(add);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Mul mul) {
        this.replaceInBinaryExpression(mul);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Div div) {
        this.replaceInBinaryExpression(div);
    }

    @Override
    public void visit(QueryExpression.ArithmeticExpression.Mod mod) {
        this.replaceInBinaryExpression(mod);
    }

    @Override
    public void visit(QueryExpression.LogicalExpression.And and) {
        this.replaceInBinaryExpression(and);
    }

    @Override
    public void visit(QueryExpression.LogicalExpression.Or or) {
        this.replaceInBinaryExpression(or);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.Equal equal) {
        this.replaceInBinaryExpression(equal);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.NotEqual notEqual) {
        this.replaceInBinaryExpression(notEqual);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.Greater greater) {
        this.replaceInBinaryExpression(greater);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.GreaterEqual greaterEqual) {
        this.replaceInBinaryExpression(greaterEqual);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.Less less) {
        this.replaceInBinaryExpression(less);
    }

    @Override
    public void visit(QueryExpression.RelationalExpression.LessEqual lessEqual) {
        this.replaceInBinaryExpression(lessEqual);
    }

    @Override
    public void visit(QueryExpression.ConcatExpression concat) {
        this.replaceInBinaryExpression(concat);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
        this.replaceInUnaryExpression(aggrCount);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
        this.replaceInUnaryExpression(aggrListagg);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
        this.replaceInUnaryExpression(aggrMin);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
        this.replaceInUnaryExpression(aggrMax);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
        this.replaceInUnaryExpression(aggrSum);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
        this.replaceInUnaryExpression(aggrAvg);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayAgg) {
        this.replaceInUnaryExpression(aggrArrayAgg);
    }

    @Override
    public void visit(QueryExpression.Aggregation.AggrJsonArrayagg aggrJsonArrayagg) {
        this.replaceInUnaryExpression(aggrJsonArrayagg);
    }

    @Override
    public void visit(QueryExpression.Function.Cast cast) {
        cast.setExp(this.replaceMatching(cast.getExp()));
    }

    @Override
    public void visit(QueryExpression.FunctionCall functionCall) {
        functionCall.getArgs().replaceAll(this::replaceMatching);
    }

    @Override
    public void visit(QueryExpression.ExtractExpression extractExpression) {
        extractExpression.setExp(this.replaceMatching(extractExpression.getExp()));
    }

    @Override
    public void visit(QueryExpression.InPredicate inPredicate) {
        inPredicate.setExp(this.replaceMatching(inPredicate.getExp()));
        inPredicate.setInValueList(this.replaceMatching(inPredicate.getInValueList()));
    }

    @Override
    public void visit(QueryExpression.IsNull isNull) {
        isNull.setExp(this.replaceMatching(isNull.getExp()));
    }

    @Override
    public void visit(QueryExpression.IfElse ifElse) {
        ifElse.setExp1(this.replaceMatching(ifElse.getExp1()));
        ifElse.setExp2(this.replaceMatching(ifElse.getExp2()));
        ifElse.setExp3(this.replaceMatching(ifElse.getExp3()));
    }

    @Override
    public void visit(QueryExpression.SimpleCase simpleCase) {
        simpleCase.setCaseOperand(this.replaceMatching(simpleCase.getCaseOperand()));
        simpleCase.setElseExp(this.replaceMatching(simpleCase.getElseExp()));
        for (QueryExpression.WhenThenExpression whenThenExp : simpleCase.getWhenThenExps()) {
            whenThenExp.setWhen(this.replaceMatching(whenThenExp.getWhen()));
            whenThenExp.setThen(this.replaceMatching(whenThenExp.getThen()));
        }
    }

    @Override
    public void visit(QueryExpression.SubstringExpression substringExpression) {
        substringExpression.setExp(this.replaceMatching(substringExpression.getExp()));
        substringExpression.setStartPosition(this.replaceMatching(substringExpression.getStartPosition()));
        substringExpression.setStringLength(this.replaceMatching(substringExpression.getStringLength()));
    }

    @Override
    public void visit(QueryExpression.BetweenPredicate betweenPredicate) {
        betweenPredicate.setExp1(this.replaceMatching(betweenPredicate.getExp1()));
        betweenPredicate.setExp2(this.replaceMatching(betweenPredicate.getExp2()));
        betweenPredicate.setExp3(this.replaceMatching(betweenPredicate.getExp3()));
    }

    @Override
    public void visit(QueryExpression.SourceDestinationPredicate sourceDestinationPredicate) {
    }

    @Override
    public void visit(Projection projection) {
        projection.getElements().forEach(this::visit);
    }

    private void replaceInUnaryExpression(QueryExpression.UnaryExpression unaryExpression) {
        unaryExpression.setExp(this.replaceMatching(unaryExpression.getExp()));
    }

    private void replaceInBinaryExpression(QueryExpression.BinaryExpression binaryExpression) {
        binaryExpression.setExp1(this.replaceMatching(binaryExpression.getExp1()));
        binaryExpression.setExp2(this.replaceMatching(binaryExpression.getExp2()));
    }

    private Set<QueryExpression> replaceInSet(Set<QueryExpression> expressions) {
        return expressions.stream().map(this::replaceMatching).collect(Collectors.toSet());
    }

    private List<QueryExpression> replaceInList(List<QueryExpression> expressions) {
        return expressions.stream().map(this::replaceMatching).collect(Collectors.toList());
    }

    @Override
    public void visit(QueryExpression.Constant.ConstInteger constInteger) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstDecimal constDecimal) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstString constString) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstBoolean constBoolean) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstDate constDate) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstTime constTime) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstTimestamp constTimestamp) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstTimeWithTimezone constTimeWithTimezone) {
    }

    @Override
    public void visit(QueryExpression.Constant.ConstTimestampWithTimezone constTimestampWithTimezone) {
    }

    @Override
    public void visit(QueryExpression.Interval interval) {
    }

    @Override
    public void visit(QueryExpression.VarRef varRef) {
    }

    @Override
    public void visit(QueryExpression.BindVariable bindVariable) {
    }

    @Override
    public void visit(QueryExpression.Star star) {
    }

    @Override
    public void visit(QueryExpression.AllProperties allProperties) {
        this.visit(allProperties.getVarRef());
    }

    @Override
    public void visit(QueryExpression.PropertyAccess propertyAccess) {
    }

    @Override
    public void visit(QueryExpression.Function.Exists exists) {
        this.visit(exists.getQuery());
    }

    @Override
    public void visit(QueryExpression.InPredicate.InValueList inValueList) {
    }

    @Override
    public void visit(QueryExpression.ScalarSubquery scalarSubquery) {
        this.visit(scalarSubquery.getQuery());
    }

    @Override
    public void visit(SelectQuery selectQuery) {
        this.visit(selectQuery.getProjection());
        this.visitQueryCommon(selectQuery);
    }

    public void visit(GraphQuery graphQuery) {
        switch (graphQuery.getQueryType()) {
            case SELECT: {
                this.visit((SelectQuery)graphQuery);
                break;
            }
            case MODIFY: {
                this.visit((ModifyQuery)graphQuery);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported query type: " + (Object)((Object)graphQuery.getQueryType()));
            }
        }
    }

    private void visitQueryCommon(GraphQuery graphQuery) {
        graphQuery.getTableExpressions().forEach(e -> e.accept(this));
        graphQuery.setConstraints(this.replaceInSet(graphQuery.getConstraints()));
        if (graphQuery.getGroupBy() != null) {
            this.visit(graphQuery.getGroupBy());
        }
        if (graphQuery.getHaving() != null) {
            graphQuery.setHaving(this.replaceMatching(graphQuery.getHaving()));
        }
        this.visit(graphQuery.getOrderBy());
        graphQuery.setLimit(this.replaceMatching(graphQuery.getLimit()));
        graphQuery.setOffset(this.replaceMatching(graphQuery.getOffset()));
    }

    @Override
    public void visit(GraphPattern graphPattern) {
        graphPattern.setConstraints(this.replaceInSet(graphPattern.getConstraints()));
    }

    @Override
    public void visit(OptionalGraphPattern optionalGraphPattern) {
        optionalGraphPattern.setConstraints(this.replaceInSet(optionalGraphPattern.getConstraints()));
    }

    @Override
    public void visit(ExpAsVar expAsVar) {
        expAsVar.setExp(this.replaceMatching(expAsVar.getExp()));
    }

    @Override
    public void visit(QueryVertex queryVertex) {
    }

    @Override
    public void visit(QueryEdge queryEdge) {
    }

    @Override
    public void visit(QueryPath queryPath) {
        queryPath.setConstraints(this.replaceInSet(queryPath.getConstraints()));
    }

    @Override
    public void visit(GroupBy groupBy) {
        groupBy.getElements().forEach(this::visit);
    }

    @Override
    public void visit(OrderBy orderBy) {
        orderBy.getElements().forEach(this::visit);
    }

    @Override
    public void visit(OrderByElem orderByElem) {
        orderByElem.setExp(this.replaceMatching(orderByElem.getExp()));
    }

    @Override
    public void visit(DerivedTable derivedTable) {
        this.visit(derivedTable.getQuery());
    }

    @Override
    public void visit(ModifyQuery modifyQuery) {
        modifyQuery.getModifications().forEach(modification -> modification.accept(this));
        this.visitQueryCommon(modifyQuery);
    }

    @Override
    public void visit(SetPropertyExpression setPropertyExpression) {
        setPropertyExpression.setValueExpression(this.replaceMatching(setPropertyExpression.getValueExpression()));
    }

    @Override
    public void visit(InsertClause insertClause) {
        insertClause.getInsertions().forEach(insertion -> insertion.accept(this));
    }

    @Override
    public void visit(UpdateClause updateClause) {
        updateClause.getUpdates().forEach(update -> update.accept(this));
    }

    @Override
    public void visit(DeleteClause deleteClause) {
    }

    @Override
    public void visit(VertexInsertion vertexInsertion) {
        vertexInsertion.setLabels(this.replaceInList(vertexInsertion.getLabels()));
        vertexInsertion.getProperties().forEach(property -> property.setValueExpression(this.replaceMatching(property.getValueExpression())));
    }

    @Override
    public void visit(EdgeInsertion edgeInsertion) {
        edgeInsertion.setLabels(this.replaceInList(edgeInsertion.getLabels()));
        edgeInsertion.getProperties().forEach(property -> property.setValueExpression(this.replaceMatching(property.getValueExpression())));
    }

    @Override
    public void visit(Update update) {
        update.getSetPropertyExpressions().forEach(propertyExpression -> propertyExpression.setValueExpression(this.replaceMatching(propertyExpression.getValueExpression())));
    }
}

