/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir.modify;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.modify.Insertion;
import oracle.pgql.lang.ir.modify.Modification;
import oracle.pgql.lang.ir.modify.ModificationType;

public class InsertClause
implements Modification {
    private SchemaQualifiedName graphName;
    private List<Insertion> insertions;

    public InsertClause(SchemaQualifiedName graphName, List<Insertion> insertions) {
        this.graphName = graphName;
        this.insertions = insertions;
    }

    public SchemaQualifiedName getGraphName() {
        return this.graphName;
    }

    public void setGraphName(SchemaQualifiedName graphName) {
        this.graphName = graphName;
    }

    public List<Insertion> getInsertions() {
        return this.insertions;
    }

    public void setInsertions(List<Insertion> insertions) {
        this.insertions = insertions;
    }

    public String toString() {
        String intoClause = this.graphName == null ? "" : "INTO " + this.graphName + " ";
        return "INSERT " + intoClause + this.insertions.stream().map(x -> x.toString()).collect(Collectors.joining(", "));
    }

    @Override
    public ModificationType getModificationType() {
        return ModificationType.INSERT;
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InsertClause other = (InsertClause)obj;
        if (this.graphName == null ? other.graphName != null : !this.graphName.equals(other.graphName)) {
            return false;
        }
        return !(this.insertions == null ? other.insertions != null : !this.insertions.equals(other.insertions));
    }

    @Override
    public void accept(QueryExpressionVisitor v) {
        v.visit(this);
    }
}

