/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.common.util.TemporalTypeUtils;

class AddRowsToFrameBuilderRequestDeserializer
extends JsonDeserializer<Map<String, Iterable<?>>> {
    private final ObjectMapper mapper = this.getObjectMapperInstance();

    AddRowsToFrameBuilderRequestDeserializer() {
    }

    private ObjectMapper getObjectMapperInstance() {
        ObjectMapper objectMapper = ConfigJsonUtil.forkObjectMapper();
        objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).enable(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS);
        return objectMapper;
    }

    public Map<String, Iterable<?>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        TypeReference typeRef = new TypeReference<Map<String, Iterable<?>>>(){};
        Map res = (Map)this.mapper.readValue(p, typeRef);
        AddRowsToFrameBuilderRequestDeserializer.forceTypes(res);
        return res;
    }

    private static void forceTypes(Map<String, Iterable<?>> map) {
        for (Map.Entry<String, Iterable<?>> entry : map.entrySet()) {
            String key = entry.getKey();
            Iterable<?> it = entry.getValue();
            if (!it.iterator().hasNext() || it.iterator().next().getClass() != LinkedHashMap.class) continue;
            Iterable<?> it2 = it;
            ArrayList list = new ArrayList();
            it2.forEach(hm -> AddRowsToFrameBuilderRequestDeserializer.convertTemporalType(hm, list));
            map.put(key, list);
        }
    }

    private static void convertTemporalType(Map<String, BigInteger> hm, List<?> list) {
        BigInteger val = hm.get("LOCAL_DATE");
        if (val != null) {
            list.add(LocalDate.ofEpochDay(val.longValue()));
            return;
        }
        val = hm.get("TIME");
        if (val != null) {
            list.add(TemporalTypeUtils.parseTimeFromMillis((int)val.intValue()));
            return;
        }
        val = hm.get("TIMESTAMP");
        if (val != null) {
            list.add(TemporalTypeUtils.parseTimestamp((long)val.longValue()));
            return;
        }
        val = hm.get("TIME_PART_OF_TIME_WITH_TZ");
        BigInteger valTz = hm.get("TZ_PART_OF_TIME_WITH_TZ");
        if (val != null && valTz != null) {
            OffsetTime offsetTime = TemporalTypeUtils.parseTimeWithTimezone((int)val.intValue(), (int)valTz.intValue());
            list.add(offsetTime);
            return;
        }
        val = hm.get("TIMESTAMP_PART_OF_TS_WITH_TZ");
        valTz = hm.get("TZ_PART_OF_TS_WITH_TZ");
        if (val != null && valTz != null) {
            OffsetDateTime offsetDateTime = TemporalTypeUtils.parseTimestampWithTimezone((long)val.longValue(), (int)valTz.intValue());
            list.add(offsetDateTime);
            return;
        }
        throw new IllegalArgumentException("INVALID_JSON");
    }
}

