/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.api.internal.PathProxy;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.SerializedPathProxy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemotePathProxyImpl;

public class PathProxyMarshaler
implements Marshaler<PathProxy> {
    @Override
    public PathProxy unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        List edges;
        List nodes;
        CollectionType nodeCollectionClass;
        SerializedPathProxy wrappedProxy = (SerializedPathProxy)((Object)JsonUtil.readTopLevelJson((String)jsonString, SerializedPathProxy.class));
        TypeFactory typeFactory = JsonUtil.getTypeFactory();
        if (Boolean.TRUE.equals(wrappedProxy.wrappedVertices)) {
            nodeCollectionClass = typeFactory.constructCollectionType(ArrayList.class, Vertex.class);
            nodes = (List)JsonUtil.readValue((String)wrappedProxy.serializedNodes, (JavaType)nodeCollectionClass);
        } else {
            nodeCollectionClass = typeFactory.constructCollectionType(ArrayList.class, wrappedProxy.nodeType.getTypeClass());
            nodes = (List)JsonUtil.readValue((String)wrappedProxy.serializedNodes, (JavaType)nodeCollectionClass);
        }
        if (Boolean.TRUE.equals(wrappedProxy.wrappedEdges)) {
            CollectionType edgeCollectionClass = typeFactory.constructCollectionType(ArrayList.class, Edge.class);
            edges = (List)JsonUtil.readValue((String)wrappedProxy.serializedEdges, (JavaType)edgeCollectionClass);
        } else {
            CollectionType edgeCollectionClass = typeFactory.constructCollectionType(ArrayList.class, IdType.LONG.getTypeClass());
            edges = (List)JsonUtil.readValue((String)wrappedProxy.serializedEdges, (JavaType)edgeCollectionClass);
        }
        return new RemotePathProxyImpl(wrappedProxy.exists, nodes, edges, wrappedProxy.edgeCosts, wrappedProxy.cost, wrappedProxy.pathLength);
    }

    @Override
    public String marshal(PathProxy object) throws IOException {
        boolean wrappedVertices;
        IdType nodeType;
        SerializedPathProxy response = new SerializedPathProxy();
        response.cost = object.getCost();
        response.exists = object.exists();
        response.pathLength = object.getPathLength();
        List<Object> nodes = object.getNodes();
        if (nodes != null && !nodes.isEmpty()) {
            Object node = nodes.get(0);
            if (node instanceof Entity) {
                nodeType = ((Entity)node).getIdType();
                wrappedVertices = true;
            } else {
                nodeType = IdType.getTypeFor(node.getClass());
                wrappedVertices = false;
            }
        } else {
            nodeType = IdType.LONG;
            wrappedVertices = false;
        }
        response.nodeType = nodeType;
        response.wrappedVertices = wrappedVertices;
        response.serializedNodes = JsonUtil.toJson(nodes);
        response.wrappedEdges = wrappedVertices;
        response.serializedEdges = JsonUtil.toJson(object.getEdges());
        response.edgeCosts = object.getEdgeCosts();
        return JsonUtil.toJson((Object)((Object)response));
    }
}

