/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.partitionedgraphbuilder;

import java.util.Map;
import oracle.pgx.api.internal.EdgeChanges;
import oracle.pgx.api.internal.partitionedgraphbuilder.PartitionedGraphBuilderEntity;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.utils.NameGenerator;

public class PartitionedGraphEdgeBuilderEntity
extends PartitionedGraphBuilderEntity {
    private final String sourceEntityName;
    private final String destinationEntityName;
    private String srcIdPropertyName;
    private String dstIdPropertyName;

    protected PartitionedGraphEdgeBuilderEntity(String entityName, Map<String, PropertyType> propertiesWithType, String sourceEntityName, String destinationEntityName, Map<Object, String> vertexIdToEntityMap) {
        super(entityName, propertiesWithType, vertexIdToEntityMap);
        this.sourceEntityName = sourceEntityName;
        this.destinationEntityName = destinationEntityName;
        this.srcIdPropertyName = NameGenerator.getUniqueName((String[])propertiesWithType.keySet().toArray(new String[0])) + "_srcId";
        this.dstIdPropertyName = NameGenerator.getUniqueName((String[])propertiesWithType.keySet().toArray(new String[0])) + "_dstId";
    }

    public String getSourceEntityName() {
        return this.sourceEntityName;
    }

    public String getDestinationEntityName() {
        return this.destinationEntityName;
    }

    public String getSrcIdPropertyName() {
        return this.srcIdPropertyName;
    }

    public String getDstIdPropertyName() {
        return this.dstIdPropertyName;
    }

    public static <ID> String constructEdgeEntityNameFromSrcDstAndEdgeLabel(EdgeChanges edgeChanges, Map<ID, String> vertexIdToEntityMapping) {
        if (edgeChanges.getLabelChange() != null && !edgeChanges.getLabelChange().isEmpty()) {
            Object srcVertex = edgeChanges.getSrcId();
            Object dstVertex = edgeChanges.getDstId();
            return PartitionedGraphEdgeBuilderEntity.generateEdgeEntityName(edgeChanges.getLabelChange(), vertexIdToEntityMapping.get(srcVertex), vertexIdToEntityMapping.get(dstVertex));
        }
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"PARTITIONED_GRAPH_BUILDER_INVALID_NUMBER_OF_LABELS_FOR_ENTITY", (Object[])new Object[]{"edges"}));
    }

    private static String generateEdgeEntityName(String edgeLabel, String srcVertexLabel, String dstVertexLabel) {
        return edgeLabel + '_' + srcVertexLabel + '_' + dstVertexLabel;
    }
}

