/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.executionenvironment;

import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PoolType;
import oracle.pgx.api.executionenvironment.AbstractEnvironment;
import oracle.pgx.api.executionenvironment.ExecutionEnvironmentField;
import oracle.pgx.api.internal.CoreSessionApi;

public final class IoEnvironment
extends AbstractEnvironment {
    private static final ExecutionEnvironmentField[] RELEVANT_FIELDS = new ExecutionEnvironmentField[]{ExecutionEnvironmentField.NUM_THREADS_PER_TASK};

    IoEnvironment(PgxSession session, CoreSessionApi coreSessionApi) {
        super(session, coreSessionApi, PoolType.IO_POOL);
    }

    public PgxFuture<Integer> getNumThreadsPerTaskAsync() {
        return this.getEnvironmentAsync(ExecutionEnvironmentField.NUM_THREADS_PER_TASK, Integer.class);
    }

    public PgxFuture<Void> setNumThreadsPerTaskAsync(Integer numThreadsPerTask) {
        return this.setEnvironmentAsync(ExecutionEnvironmentField.NUM_THREADS_PER_TASK, numThreadsPerTask);
    }

    public <T> PgxFuture<T> withNumThreadsPerTaskAsync(int numThreads, Supplier<PgxFuture<T>> asyncRequest) {
        return IoEnvironment.withValueAsync(numThreads, this::getNumThreadsPerTaskAsync, this::setNumThreadsPerTaskAsync, asyncRequest);
    }

    public int getNumThreadsPerTask() throws ExecutionException, InterruptedException {
        return this.getNumThreadsPerTaskAsync().get();
    }

    public void setNumThreadsPerTask(Integer numThreadsPerTask) throws ExecutionException, InterruptedException {
        this.setNumThreadsPerTaskAsync(numThreadsPerTask).get();
    }

    public <T> T withNumThreadsPerTask(int numThreads, Supplier<PgxFuture<T>> asyncSupplier) throws ExecutionException, InterruptedException {
        return this.withNumThreadsPerTaskAsync(numThreads, asyncSupplier).get();
    }

    @Override
    protected ExecutionEnvironmentField[] getRelevantFields() {
        return RELEVANT_FIELDS;
    }
}

