/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.function.Supplier;
import oracle.pgx.api.PartitionedIdBuilder;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.internal.GraphMetaDataKeyColumnMetaDataLookup;
import oracle.pgx.api.internal.KeyColumnMetaDataLookup;
import oracle.pgx.common.util.ErrorMessages;

@BetaApi
public class PartitionedIdBuilderFactory {
    private final Supplier<KeyColumnMetaDataLookup> keyColumnMetaDataProvider;
    private KeyColumnMetaDataLookup keyColumnMetaData;

    private PartitionedIdBuilderFactory(Supplier<KeyColumnMetaDataLookup> keyColumnMetaDataProvider) {
        ErrorMessages.requireNonNull(keyColumnMetaDataProvider, (String)"key column metadata provider");
        this.keyColumnMetaDataProvider = keyColumnMetaDataProvider;
    }

    public PartitionedIdBuilder newId() {
        return new PartitionedIdBuilder(this.getMetaData());
    }

    private KeyColumnMetaDataLookup getMetaData() {
        if (this.keyColumnMetaData == null) {
            this.keyColumnMetaData = this.keyColumnMetaDataProvider.get();
        }
        return this.keyColumnMetaData;
    }

    public static PartitionedIdBuilderFactory forGraph(PgxGraph graph) {
        return new PartitionedIdBuilderFactory(() -> new GraphMetaDataKeyColumnMetaDataLookup(graph.getMetaData()));
    }
}

