/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Arrays;
import java.util.Objects;
import oracle.pgx.api.IdBuilder;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.internal.KeyColumnMetaDataLookup;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.api.keys.KeyTypeUtils;
import oracle.pgx.api.keys.KeyUtils;
import oracle.pgx.common.PartitionedId;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;

@BetaApi
public class PartitionedIdBuilder
implements IdBuilder<PartitionedId, WithTableName> {
    private final KeyColumnMetaDataLookup keyColumnMetaDataLookup;

    PartitionedIdBuilder(KeyColumnMetaDataLookup keyColumnMetaDataLookup) {
        ErrorMessages.requireNonNull((Object)keyColumnMetaDataLookup, (String)"key column metadata");
        this.keyColumnMetaDataLookup = keyColumnMetaDataLookup;
    }

    @Override
    public WithTableName withTableName(String tableName) {
        KeyColumnDescriptor[] keyColumnsForProvider = this.keyColumnMetaDataLookup.getKeyColumnsForProvider(tableName);
        PartitionedIdBuilder.validateKeyColumnMetaData(keyColumnsForProvider);
        return new WithTableName(tableName, keyColumnsForProvider);
    }

    private static void validateKeyColumnMetaData(KeyColumnDescriptor[] keyColumns) {
        if (keyColumns == null) {
            PartitionedIdBuilder.failValidation(null);
        }
        try {
            KeyUtils.validateKey(Arrays.asList(keyColumns));
        }
        catch (IllegalArgumentException validationException) {
            PartitionedIdBuilder.failValidation(validationException);
        }
        for (KeyColumnDescriptor keyColumn : keyColumns) {
            if (!Objects.equals(keyColumn.getName(), "")) continue;
            PartitionedIdBuilder.failValidation(new IllegalArgumentException(ErrorMessages.getMessage((String)"KEY_COLUMN_NAME_NOT_ASSIGNED", (Object[])new Object[0])));
        }
    }

    private static void failValidation(Exception reason) {
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"KEY_COLUMN_METADATA_NOT_FOUND", (Object[])new Object[0]), reason);
    }

    public static class WithTableName
    implements IdBuilder.WithTableName<PartitionedId, WithTableName> {
        private final String tableName;
        private final KeyColumnDescriptor[] expectedKeys;
        private final Object[] keyValues;

        private WithTableName(String tableName, KeyColumnDescriptor[] expectedKeys) {
            this.tableName = tableName;
            this.expectedKeys = expectedKeys;
            this.keyValues = new Object[expectedKeys.length];
        }

        @Override
        public WithTableName withKeyValue(String keyColumnName, Object keyValue) {
            ErrorMessages.requireNonNull((Object)keyColumnName, (String)"key column name");
            ErrorMessages.requireNonNull((Object)keyValue, (String)"key value");
            for (int i = 0; i < this.expectedKeys.length; ++i) {
                if (!keyColumnName.equals(this.expectedKeys[i].getName())) continue;
                this.keyValues[i] = KeyTypeUtils.tryConvert((Object)keyValue, (IdType)this.expectedKeys[i].getType());
                return this;
            }
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"KEY_COLUMN_NOT_FOUND", (Object[])new Object[]{keyColumnName}));
        }

        @Override
        public PartitionedId build() {
            for (int i = 0; i < this.keyValues.length; ++i) {
                if (this.keyValues[i] != null) continue;
                throw new IllegalStateException(ErrorMessages.getMessage((String)"KEY_COLUMN_VALUE_MISSING", (Object[])new Object[]{this.expectedKeys[i].getName()}));
            }
            return new PartitionedId(this.tableName, this.keyValues);
        }

        public int hashCode() {
            return Objects.hash(this.tableName, Arrays.hashCode(this.expectedKeys), Arrays.hashCode(this.keyValues));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WithTableName)) {
                return false;
            }
            WithTableName that = (WithTableName)o;
            return Objects.equals(this.tableName, that.tableName) && Arrays.equals(this.expectedKeys, that.expectedKeys) && Arrays.equals(this.keyValues, that.keyValues);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append("PartitionedIdBuilder.WithTableName{tableName=").append(this.tableName).append(", keyValues=[");
            for (int k = 0; k < this.expectedKeys.length; ++k) {
                sb.append(this.expectedKeys[k].getName()).append(" <").append(this.expectedKeys[k].getType()).append('>');
                Object value = this.keyValues[k];
                if (value == null) {
                    sb.append(" not set");
                } else {
                    sb.append(" -> ").append(value);
                }
                if (k >= this.expectedKeys.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]}");
            return sb.toString();
        }
    }
}

