/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.PgxCollection;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxManagedObject;
import oracle.pgx.api.PgxMap;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.Scalar;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.internal.AnalysisResult;
import oracle.pgx.api.internal.Argument;
import oracle.pgx.api.internal.CompiledProgramMetaData;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.characteristic.CharacteristicPreset;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristic;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristicPreset;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristicSet;
import oracle.pgx.common.types.ArgumentType;
import oracle.pgx.common.types.Edge;
import oracle.pgx.common.types.Node;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.ReturnType;
import oracle.pgx.common.util.ErrorMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledProgram
extends PgxManagedObject {
    private static final Logger LOG = LoggerFactory.getLogger(CompiledProgram.class);
    private final PgxSession session;
    private final String id;
    private final String compilerOutput;
    private final Core core;
    private final ReturnType returnType;
    private final ArgumentType[] argumentTypes;

    CompiledProgram(PgxSession session, CompiledProgramMetaData metaData, String compilerOutput) {
        this.session = session;
        this.id = metaData.getId();
        this.compilerOutput = compilerOutput;
        this.core = this.session.getCore();
        this.returnType = metaData.getReturnType();
        this.argumentTypes = metaData.getArgumentTypes();
    }

    @Override
    public String getName() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public String getCompilerOutput() {
        return this.compilerOutput;
    }

    public PgxSession getSession() {
        return this.session;
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyAnalysis(this.session.getSessionContext(), this.id);
    }

    @Deprecated
    public PgxFuture<Void> destroyAsync(boolean ignoreNotFound) {
        return this.core.destroyAnalysis(this.session.getSessionContext(), this.id, ignoreNotFound);
    }

    public <T> PgxFuture<AnalysisResult<T>> runAsync(Object ... args) {
        return this.runAsync(CharacteristicPreset.ANALYSIS, args);
    }

    public <T> PgxFuture<AnalysisResult<T>> runAsync(Collection<WorkloadCharacteristic> characteristics, Object ... args) {
        WorkloadCharacteristicSet workloadCharacteristics = WorkloadCharacteristicSet.of(characteristics);
        return this.runAsync(args, (SessionContext sessionId, String analysisId, Argument[] arguments, Class<T> expectedReturnType) -> this.core.runAnalysis(sessionId, analysisId, arguments, expectedReturnType, workloadCharacteristics));
    }

    public <T> PgxFuture<AnalysisResult<T>> runAsync(WorkloadCharacteristicPreset characteristics, Object ... args) {
        return this.runAsync(characteristics.toList(), args);
    }

    private <T> PgxFuture<AnalysisResult<T>> runAsync(Object[] args, RunAnalysisCall<T> runAnalysisCall) {
        try {
            if (args == null || args.length != this.argumentTypes.length) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_LENGTH_MISMATCH", (Object[])new Object[]{this.argumentTypes.length, args == null ? 0 : args.length}));
            }
            Argument[] arguments = new Argument[args.length];
            for (int i = 0; i < args.length; ++i) {
                arguments[i] = CompiledProgram.convertArg(args[i], this.argumentTypes[i], i + 1);
            }
            Class expectedReturnType = this.returnType.getTypeClass();
            return runAnalysisCall.runAnalysis(this.session.getSessionContext(), this.id, arguments, expectedReturnType);
        }
        catch (Throwable th) {
            return PgxFuture.exceptionallyCompletedFuture(th);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CompiledProgram that = (CompiledProgram)obj;
        if (!this.session.equals(that.session)) {
            return false;
        }
        if (this.returnType != null && !this.returnType.equals((Object)that.returnType)) {
            return false;
        }
        return this.argumentTypes == null || Arrays.equals(this.argumentTypes, that.argumentTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.session) + Objects.hashCode(this.returnType) + Objects.hashCode(this.argumentTypes);
    }

    public static Argument convertArg(Object obj, ArgumentType type, int idx) throws Exception {
        LOG.debug("convert {} into {} (index = {})", new Object[]{obj, type, idx});
        if (obj == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        switch (type) {
            case BOOL_IN: {
                return Argument.createBooleanInArg(CompiledProgram.expect(obj, idx, Boolean.class));
            }
            case BOOL_OUT: {
                return Argument.createBooleanOutArg(CompiledProgram.expectScalar(obj, idx, Boolean.class));
            }
            case COLLECTION: {
                return Argument.createCollectionArg(CompiledProgram.expect(obj, idx, PgxCollection.class).getId());
            }
            case DOUBLE_IN: {
                if (obj instanceof BigDecimal) {
                    obj = ((BigDecimal)obj).doubleValue();
                }
                return Argument.createDoubleInArg(CompiledProgram.expect(obj, idx, Double.class));
            }
            case DOUBLE_OUT: {
                return Argument.createDoubleOutArg(CompiledProgram.expectScalar(obj, idx, Double.class));
            }
            case EDGE_ID_IN: {
                return Argument.createEdgeIdInArg(CompiledProgram.expect(obj, idx, PgxEdge.class).serialize());
            }
            case EDGE_ID_OUT: {
                return Argument.createEdgeIdOutArg(CompiledProgram.expectScalar(obj, idx, Edge.class));
            }
            case EDGE_PROPERTY: {
                return Argument.createEdgePropertyArg(CompiledProgram.expect(obj, idx, EdgeProperty.class).getPropertyId());
            }
            case GENERIC_FILTER: {
                return Argument.createGenericFilterArg(CompiledProgram.expect(obj, idx, GraphFilter.class));
            }
            case FLOAT_IN: {
                return Argument.createFloatInArg(CompiledProgram.expect(obj, idx, Float.class).floatValue());
            }
            case FLOAT_OUT: {
                return Argument.createFloatOutArg(CompiledProgram.expectScalar(obj, idx, Float.class));
            }
            case GRAPH: {
                return Argument.createGraphArg(CompiledProgram.expect(obj, idx, PgxGraph.class).getId());
            }
            case INT_IN: {
                return Argument.createIntInArg(CompiledProgram.expect(obj, idx, Integer.class));
            }
            case INT_OUT: {
                return Argument.createIntOutArg(CompiledProgram.expectScalar(obj, idx, Integer.class));
            }
            case LONG_IN: {
                return Argument.createLongInArg(CompiledProgram.expect(obj, idx, Long.class));
            }
            case LONG_OUT: {
                return Argument.createLongOutArg(CompiledProgram.expectScalar(obj, idx, Long.class));
            }
            case MAP: {
                return Argument.createMapArg(CompiledProgram.expect(obj, idx, PgxMap.class).getName());
            }
            case NODE_ID_IN: {
                return Argument.createNodeIdInArg(CompiledProgram.expect(obj, idx, PgxVertex.class).serialize());
            }
            case NODE_ID_OUT: {
                return Argument.createNodeIdOutArg(CompiledProgram.expectScalar(obj, idx, Node.class));
            }
            case NODE_PROPERTY: {
                return Argument.createNodePropertyArg(CompiledProgram.expect(obj, idx, VertexProperty.class).getPropertyId());
            }
            case STRING_IN: {
                return Argument.createStringInArg(CompiledProgram.expect(obj, idx, String.class));
            }
            case STRING_OUT: {
                return Argument.createStringOutArg(CompiledProgram.expectScalar(obj, idx, String.class));
            }
        }
        throw new UnsupportedOperationException(type.toString());
    }

    private static <T> T expect(Object obj, int idx, Class<T> type) {
        if (!type.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_TYPE_MISMATCH", (Object[])new Object[]{type.getSimpleName(), idx, obj.getClass().getSimpleName()}));
        }
        return (T)obj;
    }

    private static String expectScalar(Object obj, int idx, Class<?> type) {
        Scalar scalar = CompiledProgram.expect(obj, idx, Scalar.class);
        if (scalar.getType() != PropertyType.getTypeFor(type)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_SCALAR_TYPE_MISMATCH", (Object[])new Object[]{type.getSimpleName(), idx, scalar.getType().getTypeClass().getSimpleName()}));
        }
        return scalar.getName();
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public ArgumentType[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public String toString() {
        return this.toString(CompiledProgram.entry("name", this.getName()));
    }

    public <T> AnalysisResult<T> run(Object ... args) throws ExecutionException, InterruptedException {
        return this.runAsync(args).get();
    }

    public <T> AnalysisResult<T> run(Collection<WorkloadCharacteristic> characteristics, Object ... args) throws ExecutionException, InterruptedException {
        return this.runAsync(characteristics, args).get();
    }

    public <T> AnalysisResult<T> run(WorkloadCharacteristicPreset characteristics, Object ... args) throws ExecutionException, InterruptedException {
        return this.runAsync(characteristics, args).get();
    }

    private static interface RunAnalysisCall<T> {
        public PgxFuture<AnalysisResult<T>> runAnalysis(SessionContext var1, String var2, Argument[] var3, Class<T> var4);
    }
}

