/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Object to describe attributes of a vertex object on GVT format")
@JsonTypeName(value="Vertex")
public class Vertex {
    private String id;
    private List<String> labels = new ArrayList<String>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public Vertex id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the vertex/edge")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Vertex labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    @ApiModelProperty(required=true, value="Array with the edge labels")
    @JsonProperty(value="labels")
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public Vertex addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    public Vertex removeLabelsItem(String labelsItem) {
        if (labelsItem != null && this.labels != null) {
            this.labels.remove(labelsItem);
        }
        return this;
    }

    public Vertex properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(required=true, value="Object to describe the properties of the vertex/edge")
    @JsonProperty(value="properties")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Vertex putPropertiesItem(String key, Object propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    public Vertex removePropertiesItem(Object propertiesItem) {
        if (propertiesItem != null && this.properties != null) {
            this.properties.remove(propertiesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex vertex = (Vertex)o;
        return Objects.equals(this.id, vertex.id) && Objects.equals(this.labels, vertex.labels) && Objects.equals(this.properties, vertex.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.labels, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Vertex {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

