/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.DynamicForms;
import oracle.gvt.models.ExpandTemplate;

@ApiModel(description="expand object that is passed as part of the expand request")
@JsonTypeName(value="SmartExpand")
public class SmartExpand {
    private List<String> selectedVertices = new ArrayList<String>();
    private DynamicForms dynamicFormParams;
    private ExpandTemplate expandTemplate;

    public SmartExpand selectedVertices(List<String> selectedVertices) {
        this.selectedVertices = selectedVertices;
        return this;
    }

    @ApiModelProperty(required=true, value="array with the vertex IDs to expand")
    @JsonProperty(value="selectedVertices")
    public List<String> getSelectedVertices() {
        return this.selectedVertices;
    }

    @JsonProperty(value="selectedVertices")
    public void setSelectedVertices(List<String> selectedVertices) {
        this.selectedVertices = selectedVertices;
    }

    public SmartExpand addSelectedVerticesItem(String selectedVerticesItem) {
        if (this.selectedVertices == null) {
            this.selectedVertices = new ArrayList<String>();
        }
        this.selectedVertices.add(selectedVerticesItem);
        return this;
    }

    public SmartExpand removeSelectedVerticesItem(String selectedVerticesItem) {
        if (selectedVerticesItem != null && this.selectedVertices != null) {
            this.selectedVertices.remove(selectedVerticesItem);
        }
        return this;
    }

    public SmartExpand dynamicFormParams(DynamicForms dynamicFormParams) {
        this.dynamicFormParams = dynamicFormParams;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="dynamicFormParams")
    public DynamicForms getDynamicFormParams() {
        return this.dynamicFormParams;
    }

    @JsonProperty(value="dynamicFormParams")
    public void setDynamicFormParams(DynamicForms dynamicFormParams) {
        this.dynamicFormParams = dynamicFormParams;
    }

    public SmartExpand expandTemplate(ExpandTemplate expandTemplate) {
        this.expandTemplate = expandTemplate;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="expandTemplate")
    public ExpandTemplate getExpandTemplate() {
        return this.expandTemplate;
    }

    @JsonProperty(value="expandTemplate")
    public void setExpandTemplate(ExpandTemplate expandTemplate) {
        this.expandTemplate = expandTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmartExpand smartExpand = (SmartExpand)o;
        return Objects.equals(this.selectedVertices, smartExpand.selectedVertices) && Objects.equals(this.dynamicFormParams, smartExpand.dynamicFormParams) && Objects.equals(this.expandTemplate, smartExpand.expandTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.selectedVertices, this.dynamicFormParams, this.expandTemplate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmartExpand {\n");
        sb.append("    selectedVertices: ").append(this.toIndentedString(this.selectedVertices)).append("\n");
        sb.append("    dynamicFormParams: ").append(this.toIndentedString(this.dynamicFormParams)).append("\n");
        sb.append("    expandTemplate: ").append(this.toIndentedString(this.expandTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

