/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.PropertySchema;

@ApiModel(description="object to describe the schema of an edge on the database")
@JsonTypeName(value="SchemaEdge")
public class SchemaEdge {
    private List<String> sourceVertexLabels = new ArrayList<String>();
    private List<String> targetVertexLabels = new ArrayList<String>();
    private List<String> labels = new ArrayList<String>();
    private List<PropertySchema> properties = new ArrayList<PropertySchema>();

    public SchemaEdge sourceVertexLabels(List<String> sourceVertexLabels) {
        this.sourceVertexLabels = sourceVertexLabels;
        return this;
    }

    @ApiModelProperty(example="[\"EMPLOYEE\",\"PERSON\"]", required=true, value="array containing the lables of the source vertex")
    @JsonProperty(value="sourceVertexLabels")
    public List<String> getSourceVertexLabels() {
        return this.sourceVertexLabels;
    }

    @JsonProperty(value="sourceVertexLabels")
    public void setSourceVertexLabels(List<String> sourceVertexLabels) {
        this.sourceVertexLabels = sourceVertexLabels;
    }

    public SchemaEdge addSourceVertexLabelsItem(String sourceVertexLabelsItem) {
        if (this.sourceVertexLabels == null) {
            this.sourceVertexLabels = new ArrayList<String>();
        }
        this.sourceVertexLabels.add(sourceVertexLabelsItem);
        return this;
    }

    public SchemaEdge removeSourceVertexLabelsItem(String sourceVertexLabelsItem) {
        if (sourceVertexLabelsItem != null && this.sourceVertexLabels != null) {
            this.sourceVertexLabels.remove(sourceVertexLabelsItem);
        }
        return this;
    }

    public SchemaEdge targetVertexLabels(List<String> targetVertexLabels) {
        this.targetVertexLabels = targetVertexLabels;
        return this;
    }

    @ApiModelProperty(example="[\"EMPLOYEE\",\"PERSON\"]", required=true, value="array containing the lables of the source vertex")
    @JsonProperty(value="targetVertexLabels")
    public List<String> getTargetVertexLabels() {
        return this.targetVertexLabels;
    }

    @JsonProperty(value="targetVertexLabels")
    public void setTargetVertexLabels(List<String> targetVertexLabels) {
        this.targetVertexLabels = targetVertexLabels;
    }

    public SchemaEdge addTargetVertexLabelsItem(String targetVertexLabelsItem) {
        if (this.targetVertexLabels == null) {
            this.targetVertexLabels = new ArrayList<String>();
        }
        this.targetVertexLabels.add(targetVertexLabelsItem);
        return this;
    }

    public SchemaEdge removeTargetVertexLabelsItem(String targetVertexLabelsItem) {
        if (targetVertexLabelsItem != null && this.targetVertexLabels != null) {
            this.targetVertexLabels.remove(targetVertexLabelsItem);
        }
        return this;
    }

    public SchemaEdge labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    @ApiModelProperty(example="[EMPLOYEE, PERSON]", required=true, value="array containing the lables of the given vertex")
    @JsonProperty(value="labels")
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public SchemaEdge addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    public SchemaEdge removeLabelsItem(String labelsItem) {
        if (labelsItem != null && this.labels != null) {
            this.labels.remove(labelsItem);
        }
        return this;
    }

    public SchemaEdge properties(List<PropertySchema> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="properties")
    public List<PropertySchema> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(List<PropertySchema> properties) {
        this.properties = properties;
    }

    public SchemaEdge addPropertiesItem(PropertySchema propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertySchema>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    public SchemaEdge removePropertiesItem(PropertySchema propertiesItem) {
        if (propertiesItem != null && this.properties != null) {
            this.properties.remove(propertiesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaEdge schemaEdge = (SchemaEdge)o;
        return Objects.equals(this.sourceVertexLabels, schemaEdge.sourceVertexLabels) && Objects.equals(this.targetVertexLabels, schemaEdge.targetVertexLabels) && Objects.equals(this.labels, schemaEdge.labels) && Objects.equals(this.properties, schemaEdge.properties);
    }

    public int hashCode() {
        return Objects.hash(this.sourceVertexLabels, this.targetVertexLabels, this.labels, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemaEdge {\n");
        sb.append("    sourceVertexLabels: ").append(this.toIndentedString(this.sourceVertexLabels)).append("\n");
        sb.append("    targetVertexLabels: ").append(this.toIndentedString(this.targetVertexLabels)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

