/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Abstract representation of a result table")
@JsonTypeName(value="ResultTable")
public class ResultTable {
    private ResultTypeEnum resultType;
    private Integer resultId;
    private String graphName;
    private String table;

    public ResultTable resultType(ResultTypeEnum resultType) {
        this.resultType = resultType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="resultType")
    public ResultTypeEnum getResultType() {
        return this.resultType;
    }

    @JsonProperty(value="resultType")
    public void setResultType(ResultTypeEnum resultType) {
        this.resultType = resultType;
    }

    public ResultTable resultId(Integer resultId) {
        this.resultId = resultId;
        return this;
    }

    @ApiModelProperty(required=true, value="the identifier of the returned result")
    @JsonProperty(value="resultId")
    public Integer getResultId() {
        return this.resultId;
    }

    @JsonProperty(value="resultId")
    public void setResultId(Integer resultId) {
        this.resultId = resultId;
    }

    public ResultTable graphName(String graphName) {
        this.graphName = graphName;
        return this;
    }

    @ApiModelProperty(value="the graph name used for the executed query")
    @JsonProperty(value="graphName")
    public String getGraphName() {
        return this.graphName;
    }

    @JsonProperty(value="graphName")
    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public ResultTable table(String table) {
        this.table = table;
        return this;
    }

    @ApiModelProperty(required=true, value="string representing a table as markdown format")
    @JsonProperty(value="table")
    public String getTable() {
        return this.table;
    }

    @JsonProperty(value="table")
    public void setTable(String table) {
        this.table = table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultTable resultTable = (ResultTable)o;
        return Objects.equals((Object)this.resultType, (Object)resultTable.resultType) && Objects.equals(this.resultId, resultTable.resultId) && Objects.equals(this.graphName, resultTable.graphName) && Objects.equals(this.table, resultTable.table);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resultType, this.resultId, this.graphName, this.table});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResultTable {\n");
        sb.append("    resultType: ").append(this.toIndentedString((Object)this.resultType)).append("\n");
        sb.append("    resultId: ").append(this.toIndentedString(this.resultId)).append("\n");
        sb.append("    graphName: ").append(this.toIndentedString(this.graphName)).append("\n");
        sb.append("    table: ").append(this.toIndentedString(this.table)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResultTypeEnum {
        TABLE_ONLY(String.valueOf("TABLE_ONLY"));

        private String value;

        private ResultTypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultTypeEnum fromString(String s) {
            for (ResultTypeEnum b : ResultTypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static ResultTypeEnum fromValue(String value) {
            for (ResultTypeEnum b : ResultTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

