/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import oracle.gvt.models.Graph;
import oracle.gvt.models.ResultBoth;
import oracle.gvt.models.ResultGraph;
import oracle.gvt.models.ResultTable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resultType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ResultBoth.class, name="GRAPH_AND_TABLE"), @JsonSubTypes.Type(value=ResultGraph.class, name="GRAPH_ONLY"), @JsonSubTypes.Type(value=ResultTable.class, name="TABLE_ONLY")})
@JsonTypeName(value="ResultData")
public class ResultData {
    private String schema;
    private String name;
    private ResultTypeEnum resultType;
    private String resultSetId;
    private String graphName;
    private Graph graph;
    private String table;
    private Integer resultId;

    public ResultData schema(String schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public ResultData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public ResultData resultType(ResultTypeEnum resultType) {
        this.resultType = resultType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="resultType")
    public ResultTypeEnum getResultType() {
        return this.resultType;
    }

    @JsonProperty(value="resultType")
    public void setResultType(ResultTypeEnum resultType) {
        this.resultType = resultType;
    }

    public ResultData resultSetId(String resultSetId) {
        this.resultSetId = resultSetId;
        return this;
    }

    @ApiModelProperty(required=true, value="the identifier of the returned result")
    @JsonProperty(value="resultSetId")
    public String getResultSetId() {
        return this.resultSetId;
    }

    @JsonProperty(value="resultSetId")
    public void setResultSetId(String resultSetId) {
        this.resultSetId = resultSetId;
    }

    public ResultData graphName(String graphName) {
        this.graphName = graphName;
        return this;
    }

    @ApiModelProperty(value="the graph name used for the executed query")
    @JsonProperty(value="graphName")
    public String getGraphName() {
        return this.graphName;
    }

    @JsonProperty(value="graphName")
    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public ResultData graph(Graph graph) {
        this.graph = graph;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="graph")
    public Graph getGraph() {
        return this.graph;
    }

    @JsonProperty(value="graph")
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public ResultData table(String table) {
        this.table = table;
        return this;
    }

    @ApiModelProperty(required=true, value="string representing a table as markdown format")
    @JsonProperty(value="table")
    public String getTable() {
        return this.table;
    }

    @JsonProperty(value="table")
    public void setTable(String table) {
        this.table = table;
    }

    public ResultData resultId(Integer resultId) {
        this.resultId = resultId;
        return this;
    }

    @ApiModelProperty(required=true, value="the identifier of the returned result")
    @JsonProperty(value="resultId")
    public Integer getResultId() {
        return this.resultId;
    }

    @JsonProperty(value="resultId")
    public void setResultId(Integer resultId) {
        this.resultId = resultId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultData resultData = (ResultData)o;
        return Objects.equals(this.schema, resultData.schema) && Objects.equals(this.name, resultData.name) && Objects.equals((Object)this.resultType, (Object)resultData.resultType) && Objects.equals(this.resultSetId, resultData.resultSetId) && Objects.equals(this.graphName, resultData.graphName) && Objects.equals(this.graph, resultData.graph) && Objects.equals(this.table, resultData.table) && Objects.equals(this.resultId, resultData.resultId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schema, this.name, this.resultType, this.resultSetId, this.graphName, this.graph, this.table, this.resultId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResultData {\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resultType: ").append(this.toIndentedString((Object)this.resultType)).append("\n");
        sb.append("    resultSetId: ").append(this.toIndentedString(this.resultSetId)).append("\n");
        sb.append("    graphName: ").append(this.toIndentedString(this.graphName)).append("\n");
        sb.append("    graph: ").append(this.toIndentedString(this.graph)).append("\n");
        sb.append("    table: ").append(this.toIndentedString(this.table)).append("\n");
        sb.append("    resultId: ").append(this.toIndentedString(this.resultId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResultTypeEnum {
        TABLE_ONLY(String.valueOf("TABLE_ONLY"));

        private String value;

        private ResultTypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultTypeEnum fromString(String s) {
            for (ResultTypeEnum b : ResultTypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static ResultTypeEnum fromValue(String value) {
            for (ResultTypeEnum b : ResultTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

