/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import oracle.gvt.models.Graph;

@ApiModel(description="Abstract representation of a result with graph and table")
@JsonTypeName(value="ResultBoth")
public class ResultBoth {
    private String schema;
    private String name;
    private ResultTypeEnum resultType;
    private String resultSetId;
    private String graphName;
    private Graph graph;
    private String table;

    public ResultBoth schema(String schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public ResultBoth name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public ResultBoth resultType(ResultTypeEnum resultType) {
        this.resultType = resultType;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="resultType")
    public ResultTypeEnum getResultType() {
        return this.resultType;
    }

    @JsonProperty(value="resultType")
    public void setResultType(ResultTypeEnum resultType) {
        this.resultType = resultType;
    }

    public ResultBoth resultSetId(String resultSetId) {
        this.resultSetId = resultSetId;
        return this;
    }

    @ApiModelProperty(required=true, value="the identifier of the returned result")
    @JsonProperty(value="resultSetId")
    public String getResultSetId() {
        return this.resultSetId;
    }

    @JsonProperty(value="resultSetId")
    public void setResultSetId(String resultSetId) {
        this.resultSetId = resultSetId;
    }

    public ResultBoth graphName(String graphName) {
        this.graphName = graphName;
        return this;
    }

    @ApiModelProperty(value="the graph name used for the executed query")
    @JsonProperty(value="graphName")
    public String getGraphName() {
        return this.graphName;
    }

    @JsonProperty(value="graphName")
    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public ResultBoth graph(Graph graph) {
        this.graph = graph;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="graph")
    public Graph getGraph() {
        return this.graph;
    }

    @JsonProperty(value="graph")
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public ResultBoth table(String table) {
        this.table = table;
        return this;
    }

    @ApiModelProperty(required=true, value="string representing a table as markdown format")
    @JsonProperty(value="table")
    public String getTable() {
        return this.table;
    }

    @JsonProperty(value="table")
    public void setTable(String table) {
        this.table = table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultBoth resultBoth = (ResultBoth)o;
        return Objects.equals(this.schema, resultBoth.schema) && Objects.equals(this.name, resultBoth.name) && Objects.equals((Object)this.resultType, (Object)resultBoth.resultType) && Objects.equals(this.resultSetId, resultBoth.resultSetId) && Objects.equals(this.graphName, resultBoth.graphName) && Objects.equals(this.graph, resultBoth.graph) && Objects.equals(this.table, resultBoth.table);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schema, this.name, this.resultType, this.resultSetId, this.graphName, this.graph, this.table});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResultBoth {\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resultType: ").append(this.toIndentedString((Object)this.resultType)).append("\n");
        sb.append("    resultSetId: ").append(this.toIndentedString(this.resultSetId)).append("\n");
        sb.append("    graphName: ").append(this.toIndentedString(this.graphName)).append("\n");
        sb.append("    graph: ").append(this.toIndentedString(this.graph)).append("\n");
        sb.append("    table: ").append(this.toIndentedString(this.table)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResultTypeEnum {
        GRAPH_AND_TABLE(String.valueOf("GRAPH_AND_TABLE"));

        private String value;

        private ResultTypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultTypeEnum fromString(String s) {
            for (ResultTypeEnum b : ResultTypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static ResultTypeEnum fromValue(String value) {
            for (ResultTypeEnum b : ResultTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

