/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="resources affected by the work request")
@JsonTypeName(value="Resources")
public class Resources {
    private String entityType;
    private String entityUri;
    private String identifier;

    public Resources entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(example="GRAPH", value="The resource type the work request affects")
    @JsonProperty(value="entityType")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public Resources entityUri(String entityUri) {
        this.entityUri = entityUri;
        return this;
    }

    @ApiModelProperty(value="The URI path that the user can do a GET on to access the resource metadata")
    @JsonProperty(value="entityUri")
    public String getEntityUri() {
        return this.entityUri;
    }

    @JsonProperty(value="entityUri")
    public void setEntityUri(String entityUri) {
        this.entityUri = entityUri;
    }

    public Resources identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @ApiModelProperty(example="gvtRq1fhjhe", value="The identifier of the resource the work request affects")
    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resources resources = (Resources)o;
        return Objects.equals(this.entityType, resources.entityType) && Objects.equals(this.entityUri, resources.entityUri) && Objects.equals(this.identifier, resources.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.entityUri, this.identifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resources {\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    entityUri: ").append(this.toIndentedString(this.entityUri)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

