/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Object to describe the schema properties of vertices or edges")
@JsonTypeName(value="PropertySchema")
public class PropertySchema {
    private String name;
    private String dataType;
    private List<Integer> limits;
    private Boolean mandatory;

    public PropertySchema name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name of the property (column name on the database)")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public PropertySchema dataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    @ApiModelProperty(required=true, value="data type to validate the property value")
    @JsonProperty(value="dataType")
    public String getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public PropertySchema limits(List<Integer> limits) {
        this.limits = limits;
        return this;
    }

    @ApiModelProperty(example="[1,2]", value="to specify the precision of the property")
    @JsonProperty(value="limits")
    public List<Integer> getLimits() {
        return this.limits;
    }

    @JsonProperty(value="limits")
    public void setLimits(List<Integer> limits) {
        this.limits = limits;
    }

    public PropertySchema addLimitsItem(Integer limitsItem) {
        if (this.limits == null) {
            this.limits = new ArrayList<Integer>();
        }
        this.limits.add(limitsItem);
        return this;
    }

    public PropertySchema removeLimitsItem(Integer limitsItem) {
        if (limitsItem != null && this.limits != null) {
            this.limits.remove(limitsItem);
        }
        return this;
    }

    public PropertySchema mandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    @ApiModelProperty(value="flag to specify if the property can be null or not on the database side")
    @JsonProperty(value="mandatory")
    public Boolean getMandatory() {
        return this.mandatory;
    }

    @JsonProperty(value="mandatory")
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertySchema propertySchema = (PropertySchema)o;
        return Objects.equals(this.name, propertySchema.name) && Objects.equals(this.dataType, propertySchema.dataType) && Objects.equals(this.limits, propertySchema.limits) && Objects.equals(this.mandatory, propertySchema.mandatory);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType, this.limits, this.mandatory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PropertySchema {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    mandatory: ").append(this.toIndentedString(this.mandatory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

