/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import oracle.gvt.models.GraphInformation;

@ApiModel(description="Information that is returned for a graph stored on PGX server")
@JsonTypeName(value="PgxGraphInformation")
public class PgxGraphInformation
extends GraphInformation {
    private Integer numVertices;
    private Integer numEdges;

    public PgxGraphInformation numVertices(Integer numVertices) {
        this.numVertices = numVertices;
        return this;
    }

    @ApiModelProperty(value="Number of vertices of the graph")
    @JsonProperty(value="numVertices")
    public Integer getNumVertices() {
        return this.numVertices;
    }

    @JsonProperty(value="numVertices")
    public void setNumVertices(Integer numVertices) {
        this.numVertices = numVertices;
    }

    public PgxGraphInformation numEdges(Integer numEdges) {
        this.numEdges = numEdges;
        return this;
    }

    @ApiModelProperty(value="Number of edges of the graph")
    @JsonProperty(value="numEdges")
    public Integer getNumEdges() {
        return this.numEdges;
    }

    @JsonProperty(value="numEdges")
    public void setNumEdges(Integer numEdges) {
        this.numEdges = numEdges;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgxGraphInformation pgxGraphInformation = (PgxGraphInformation)o;
        return Objects.equals(this.numVertices, pgxGraphInformation.numVertices) && Objects.equals(this.numEdges, pgxGraphInformation.numEdges) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.numVertices, this.numEdges, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PgxGraphInformation {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    numVertices: ").append(this.toIndentedString(this.numVertices)).append("\n");
        sb.append("    numEdges: ").append(this.toIndentedString(this.numEdges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

