/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.SchemaEdge;
import oracle.gvt.models.SchemaVertex;

@ApiModel(description="object to describe the schema of a graph in database")
@JsonTypeName(value="GraphSchema")
public class GraphSchema {
    private List<SchemaVertex> vertices = new ArrayList<SchemaVertex>();
    private List<SchemaEdge> edges = new ArrayList<SchemaEdge>();

    public GraphSchema vertices(List<SchemaVertex> vertices) {
        this.vertices = vertices;
        return this;
    }

    @ApiModelProperty(required=true, value="array of vertices describing the properties of each label")
    @JsonProperty(value="vertices")
    public List<SchemaVertex> getVertices() {
        return this.vertices;
    }

    @JsonProperty(value="vertices")
    public void setVertices(List<SchemaVertex> vertices) {
        this.vertices = vertices;
    }

    public GraphSchema addVerticesItem(SchemaVertex verticesItem) {
        if (this.vertices == null) {
            this.vertices = new ArrayList<SchemaVertex>();
        }
        this.vertices.add(verticesItem);
        return this;
    }

    public GraphSchema removeVerticesItem(SchemaVertex verticesItem) {
        if (verticesItem != null && this.vertices != null) {
            this.vertices.remove(verticesItem);
        }
        return this;
    }

    public GraphSchema edges(List<SchemaEdge> edges) {
        this.edges = edges;
        return this;
    }

    @ApiModelProperty(required=true, value="array of edges describing the properties of each label")
    @JsonProperty(value="edges")
    public List<SchemaEdge> getEdges() {
        return this.edges;
    }

    @JsonProperty(value="edges")
    public void setEdges(List<SchemaEdge> edges) {
        this.edges = edges;
    }

    public GraphSchema addEdgesItem(SchemaEdge edgesItem) {
        if (this.edges == null) {
            this.edges = new ArrayList<SchemaEdge>();
        }
        this.edges.add(edgesItem);
        return this;
    }

    public GraphSchema removeEdgesItem(SchemaEdge edgesItem) {
        if (edgesItem != null && this.edges != null) {
            this.edges.remove(edgesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphSchema graphSchema = (GraphSchema)o;
        return Objects.equals(this.vertices, graphSchema.vertices) && Objects.equals(this.edges, graphSchema.edges);
    }

    public int hashCode() {
        return Objects.hash(this.vertices, this.edges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GraphSchema {\n");
        sb.append("    vertices: ").append(this.toIndentedString(this.vertices)).append("\n");
        sb.append("    edges: ").append(this.toIndentedString(this.edges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

