/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.ExpandCondition;

@ApiModel(description="Navigation or destination object")
@JsonTypeName(value="ExpandConditions")
public class ExpandConditions {
    private List<ExpandCondition> conditions;
    private String operator;

    public ExpandConditions conditions(List<ExpandCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    @ApiModelProperty(value="array with the condition to be applied for the expand action")
    @JsonProperty(value="conditions")
    public List<ExpandCondition> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    public void setConditions(List<ExpandCondition> conditions) {
        this.conditions = conditions;
    }

    public ExpandConditions addConditionsItem(ExpandCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ExpandCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public ExpandConditions removeConditionsItem(ExpandCondition conditionsItem) {
        if (conditionsItem != null && this.conditions != null) {
            this.conditions.remove(conditionsItem);
        }
        return this;
    }

    public ExpandConditions operator(String operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(value="operator to be used for concatenate conditions")
    @JsonProperty(value="operator")
    public String getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    public void setOperator(String operator) {
        this.operator = operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandConditions expandConditions = (ExpandConditions)o;
        return Objects.equals(this.conditions, expandConditions.conditions) && Objects.equals(this.operator, expandConditions.operator);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.operator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpandConditions {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

